/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.traceview.internal;

import eu.geclipse.traceview.IEvent;
import eu.geclipse.traceview.IEventMarker;
import eu.geclipse.traceview.ITrace;
import eu.geclipse.traceview.TraceVisualization;
import eu.geclipse.traceview.internal.AbstractGraphMouseAdapter;
import eu.geclipse.traceview.internal.AbstractGraphPaintListener;
import eu.geclipse.traceview.internal.Activator;
import eu.geclipse.traceview.internal.EventMarkers;
import eu.geclipse.traceview.internal.LineType;
import eu.geclipse.traceview.internal.MarkerOrderDialog;
import eu.geclipse.traceview.internal.MarkerSelectionMenuCreator;
import eu.geclipse.traceview.internal.Messages;
import eu.geclipse.traceview.views.TraceView;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewSite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGraphVisualization
extends TraceVisualization {
    protected EventMarkers eventMarkers;
    protected LineType hLines;
    protected LineType vLines;
    protected ITrace trace;
    protected List<SortedSet<Integer>> lineToProcMapping;
    protected int[] procToLineMapping;
    protected boolean[] hideProcess;

    public AbstractGraphVisualization(Composite parent, int style, IViewSite viewSite, ITrace trace) {
        super(parent, style | 0x200 | 0x100);
        this.trace = trace;
        GridData layoutData = new GridData();
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.verticalAlignment = 4;
        layoutData.grabExcessVerticalSpace = true;
        this.setLayoutData(layoutData);
        this.hLines = LineType.Lines_1;
        this.vLines = LineType.Lines_1;
        this.resetOrdering();
        this.eventMarkers = new EventMarkers(trace);
        TraceView view = (TraceView)Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        Menu menu = view.getContextMenuManager().createContextMenu((Control)this);
        this.setMenu(menu);
        this.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                AbstractGraphVisualization.this.handleResize();
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                IPreferenceStore store = Activator.getDefault().getPreferenceStore();
                store.removePropertyChangeListener(AbstractGraphVisualization.this.getEventGraphPaintListener().listener);
            }
        });
    }

    public void registerPaintListener(AbstractGraphPaintListener eventGraphPaintListener) {
        eventGraphPaintListener.setHorizontalScrollBar(this.getHorizontalBar());
        eventGraphPaintListener.setVerticalScrollBar(this.getVerticalBar());
        eventGraphPaintListener.setFont(this.getFont());
        eventGraphPaintListener.setTrace(this.trace);
        this.addPaintListener(eventGraphPaintListener);
    }

    public void registerMouseListener(final AbstractGraphMouseAdapter mouseAdapter) {
        this.addMouseListener(mouseAdapter);
        this.addMouseMoveListener(mouseAdapter);
        new DefaultToolTip((Control)this){

            protected boolean shouldCreateToolTip(Event event) {
                Object[] objs = mouseAdapter.getObjectsForPosition(event.x, event.y);
                return objs.length != 0 && this.getText(objs) != null;
            }

            protected String getText(Event event) {
                Object[] objs = mouseAdapter.getObjectsForPosition(event.x, event.y);
                return this.getText(objs);
            }

            protected String getText(Object[] objs) {
                String result = null;
                if (objs.length != 0) {
                    result = "";
                    Object[] objectArray = objs;
                    int n = objs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        if (result.length() != 0) {
                            result = String.valueOf(result) + '\n';
                        }
                        if (obj.toString() != null) {
                            result = String.valueOf(result) + obj.toString();
                        }
                        if (obj instanceof IEvent) {
                            for (IEventMarker eventmarker : AbstractGraphVisualization.this.getEventMarkers()) {
                                eventmarker.mark((IEvent)obj);
                                String markerString = eventmarker.getToolTip();
                                if (markerString == null) continue;
                                result = String.valueOf(result) + '\n' + markerString;
                            }
                        }
                        ++n2;
                    }
                    if (result.length() == 0) {
                        result = null;
                    }
                }
                return result;
            }
        };
    }

    private void setHLines(LineType lines) {
        this.hLines = lines;
        this.redraw();
    }

    private void setVLines(LineType lines) {
        this.vLines = lines;
        this.redraw();
    }

    protected void changeLineStyle(int direction) {
        LineType style = null;
        style = direction < 0 ? this.getVLines() : this.getHLines();
        if (style == LineType.Lines_None) {
            style = LineType.Lines_1;
        } else if (style == LineType.Lines_1) {
            style = LineType.Lines_5;
        } else if (style == LineType.Lines_5) {
            style = LineType.Lines_10;
        } else if (style == LineType.Lines_10) {
            style = LineType.Lines_None;
        }
        if (direction < 0) {
            this.setVLines(style);
        } else {
            this.setHLines(style);
        }
    }

    public List<IEventMarker> getEventMarkers() {
        return this.eventMarkers.getEventMarkers();
    }

    protected void handleResize() {
        this.getEventGraphPaintListener().handleResize();
    }

    public LineType getHLines() {
        return this.hLines;
    }

    public LineType getVLines() {
        return this.vLines;
    }

    @Override
    public ITrace getTrace() {
        return this.trace;
    }

    @Override
    public void printTrace(GC gc) {
        this.getEventGraphPaintListener().print(gc);
    }

    void setLineToProcessMapping(List<SortedSet<Integer>> mapping) {
        this.lineToProcMapping = mapping;
        this.updateProcessToLineMapping();
        this.redraw();
    }

    void updateProcessToLineMapping() {
        int i = 0;
        while (i < this.trace.getNumberOfProcesses()) {
            this.procToLineMapping[i] = -1;
            ++i;
        }
        int line = 0;
        while (line < this.lineToProcMapping.size()) {
            for (Integer proc : this.lineToProcMapping.get(line)) {
                this.procToLineMapping[proc.intValue()] = line;
            }
            ++line;
        }
    }

    public List<SortedSet<Integer>> getLineToProcessMapping() {
        return this.lineToProcMapping;
    }

    public void setProcessToLineMapping(int[] procToLineMapping) {
        this.procToLineMapping = procToLineMapping;
        this.updateLineToProcessMapping();
        this.redraw();
    }

    void removeEmptyLines() {
        Iterator<SortedSet<Integer>> it = this.lineToProcMapping.iterator();
        while (it.hasNext()) {
            SortedSet<Integer> set = it.next();
            if (!set.isEmpty()) continue;
            it.remove();
        }
        this.updateProcessToLineMapping();
        this.redraw();
    }

    void updateLineToProcessMapping() {
        this.lineToProcMapping = new LinkedList<SortedSet<Integer>>();
        int proc = 0;
        while (proc < this.procToLineMapping.length) {
            int line = this.procToLineMapping[proc];
            if (line != -1) {
                while (this.lineToProcMapping.size() <= line) {
                    this.lineToProcMapping.add(new TreeSet());
                }
                this.lineToProcMapping.get(line).add(proc);
            }
            ++proc;
        }
    }

    public int[] getProcessToLineMapping() {
        return this.procToLineMapping;
    }

    public boolean[] getHideProcess() {
        return this.hideProcess;
    }

    public void setHideProcess(boolean[] hideProcess) {
        this.hideProcess = hideProcess;
        this.redraw();
    }

    void resetOrdering() {
        this.procToLineMapping = new int[this.trace.getNumberOfProcesses()];
        this.hideProcess = new boolean[this.trace.getNumberOfProcesses()];
        int i = 0;
        while (i < this.trace.getNumberOfProcesses()) {
            this.procToLineMapping[i] = i;
            ++i;
        }
        this.updateLineToProcessMapping();
    }

    @Override
    public IContributionItem[] getToolBarItems() {
        Vector<ActionContributionItem> items = new Vector<ActionContributionItem>();
        Action reset = new Action(Messages.getString("AbstractGraphVisualization.Reset"), Activator.getImageDescriptor("icons/reset.gif")){

            public void run() {
                AbstractGraphVisualization.this.resetOrdering();
                AbstractGraphVisualization.this.redraw();
            }
        };
        items.add(new ActionContributionItem((IAction)reset));
        Action markerSelectionAction = new Action(Messages.getString("AbstractGraphVisualization.toggleMarkers"), Activator.getImageDescriptor("icons/marker.gif")){

            public void run() {
                MarkerOrderDialog dialog = new MarkerOrderDialog(AbstractGraphVisualization.this.getShell());
                dialog.setEventMarkerEntries(AbstractGraphVisualization.this.eventMarkers.getEventMarkerEntries());
                if (dialog.open() == 0) {
                    AbstractGraphVisualization.this.eventMarkers.eventMarkerEntries = dialog.getEventMarkerEntries();
                    AbstractGraphVisualization.this.eventMarkers.buildEventMarkersList();
                    AbstractGraphVisualization.this.redraw();
                }
            }
        };
        MarkerSelectionMenuCreator menuCreator = new MarkerSelectionMenuCreator(this);
        markerSelectionAction.setMenuCreator((IMenuCreator)menuCreator);
        items.add(new ActionContributionItem((IAction)markerSelectionAction));
        return items.toArray(new IContributionItem[items.size()]);
    }

    public abstract AbstractGraphPaintListener getEventGraphPaintListener();

    public void mergeProcessLines(int fromLine, int toLine) {
        int[] mapping = this.getProcessToLineMapping();
        for (Integer proc : this.getLineToProcessMapping().get(fromLine)) {
            mapping[proc.intValue()] = toLine;
        }
        this.setProcessToLineMapping(mapping);
        this.removeEmptyLines();
    }

    public void swapProcessLines(int lineA, int lineB) {
        int[] mapping = this.getProcessToLineMapping();
        int i = 0;
        while (i < mapping.length) {
            if (mapping[i] == lineA) {
                mapping[i] = lineB;
            } else if (mapping[i] == lineB) {
                mapping[i] = lineA;
            }
            ++i;
        }
        this.setProcessToLineMapping(mapping);
    }

    public void moveProcessLine(int oldLine, int newLine) {
        int[] mapping = this.getProcessToLineMapping();
        int i = 0;
        while (i < mapping.length) {
            if (oldLine > newLine) {
                if (mapping[i] >= newLine && mapping[i] < oldLine) {
                    int n = i;
                    mapping[n] = mapping[n] + 1;
                } else if (mapping[i] == oldLine) {
                    mapping[i] = newLine;
                }
            } else if (mapping[i] <= newLine && mapping[i] > oldLine) {
                int n = i;
                mapping[n] = mapping[n] - 1;
            } else if (mapping[i] == oldLine) {
                mapping[i] = newLine;
            }
            ++i;
        }
        this.setProcessToLineMapping(mapping);
    }
}

