/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.traceview.internal;

import eu.geclipse.traceview.IProcess;
import eu.geclipse.traceview.ITraceView;
import eu.geclipse.traceview.TraceVisualization;
import eu.geclipse.traceview.internal.AbstractGraphVisualization;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractProcessAction
extends Action
implements IActionDelegate {
    private Object[] selectedObjs;

    public void run(IAction action) {
        boolean allProcs = true;
        Object[] objectArray = this.selectedObjs;
        int n = this.selectedObjs.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (!(obj instanceof IProcess)) {
                allProcs = false;
            }
            ++n2;
        }
        if (!allProcs) {
            ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"This action can only be performed on processes", (IStatus)new Status(4, "eu.geclipse.traceview", "This action can only be performed on processes"));
        } else {
            try {
                IProcess[] procs = new IProcess[this.selectedObjs.length];
                int i = 0;
                while (i < procs.length) {
                    procs[i] = (IProcess)this.selectedObjs[i];
                    ++i;
                }
                ITraceView traceView = (ITraceView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("eu.geclipse.traceview.views.TraceView");
                TraceVisualization vis = traceView.getVisualisationForTrace(((IProcess)this.selectedObjs[0]).getTrace());
                if (vis instanceof AbstractGraphVisualization) {
                    AbstractGraphVisualization graphVis = (AbstractGraphVisualization)vis;
                    this.performAction(graphVis, procs);
                }
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }

    abstract void performAction(AbstractGraphVisualization var1, IProcess[] var2);

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            this.selectedObjs = structuredSelection.toArray();
        }
    }
}

