/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.traceview.internal;

import eu.geclipse.traceview.ITrace;
import eu.geclipse.traceview.ITraceView;
import eu.geclipse.traceview.IVectorEvent;
import eu.geclipse.traceview.internal.Activator;
import eu.geclipse.traceview.internal.CauseEffectMarker;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class CauseEffectAction
extends Action
implements IActionDelegate {
    private Object selectedObj;

    public void run(IAction action) {
        boolean equal = true;
        IVectorEvent event = (IVectorEvent)this.selectedObj;
        ITrace trace = event.getProcess().getTrace();
        IVectorEvent causeEvent = (IVectorEvent)trace.getUserData(CauseEffectMarker.MARKER_ID);
        int i = 0;
        while (i < event.getVectorClock().length) {
            if (causeEvent == null || event.getVectorClock()[i] != causeEvent.getVectorClock()[i]) {
                equal = false;
            }
            ++i;
        }
        IVectorEvent newCauseEvent = !equal ? (IVectorEvent)this.selectedObj : null;
        trace.setUserData(CauseEffectMarker.MARKER_ID, newCauseEvent);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    ITraceView traceView = (ITraceView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("eu.geclipse.traceview.views.TraceView");
                    traceView.redraw();
                }
                catch (PartInitException exception) {
                    Activator.logException((Exception)((Object)exception));
                }
            }
        });
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            this.selectedObj = structuredSelection.getFirstElement();
        }
    }
}

