/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.traceview.internal;

import eu.geclipse.traceview.EventType;
import eu.geclipse.traceview.IEvent;
import eu.geclipse.traceview.ITraceView;
import eu.geclipse.traceview.internal.Activator;
import eu.geclipse.traceview.utils.AbstractEventMarker;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class DefaultEventMarker
extends AbstractEventMarker {
    protected static boolean sendEventDraw;
    protected static boolean recvEventDraw;
    protected static boolean testEventDraw;
    protected static boolean otherEventDraw;
    protected static boolean sendEventFill;
    protected static boolean recvEventFill;
    protected static boolean testEventFill;
    protected static boolean otherEventFill;
    protected static Color sendEventFillColor;
    protected static Color recvEventFillColor;
    protected static Color testEventFillColor;
    protected static Color otherEventFillColor;
    protected static Color sendEventColor;
    protected static Color recvEventColor;
    protected static Color testEventColor;
    protected static Color otherEventColor;
    protected static Color messageColor;
    protected static IPropertyChangeListener listener;
    protected Color bgColor;
    protected Color fgColor;

    public DefaultEventMarker() {
        if (listener == null) {
            listener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    DefaultEventMarker.this.handleProperyChanged(event);
                }
            };
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            store.addPropertyChangeListener(listener);
            this.updatePropertiesFromPreferences();
        }
    }

    public Color getBackgroundColor(int type) {
        return this.bgColor;
    }

    public Color getForegroundColor(int type) {
        return this.fgColor;
    }

    public Color getMessageColor() {
        return messageColor;
    }

    public int mark(IEvent event) {
        int result = 0;
        if (event.getType().equals((Object)EventType.SEND)) {
            this.bgColor = sendEventFill ? sendEventFillColor : null;
            this.fgColor = sendEventDraw ? sendEventColor : null;
            result = 4;
        } else if (event.getType().equals((Object)EventType.RECV)) {
            this.bgColor = recvEventFill ? recvEventFillColor : null;
            this.fgColor = recvEventDraw ? recvEventColor : null;
            result = 4;
        } else if (event.getType().equals((Object)EventType.TEST)) {
            this.bgColor = testEventFill ? testEventFillColor : null;
            this.fgColor = testEventDraw ? testEventColor : null;
            result = 2;
        } else if (event.getType().equals((Object)EventType.OTHER)) {
            this.bgColor = otherEventFill ? otherEventFillColor : null;
            this.fgColor = otherEventDraw ? otherEventColor : null;
            result = 32;
        }
        return result;
    }

    void updatePropertiesFromPreferences() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        sendEventDraw = store.getBoolean("sendEventPreferencedrawPreference");
        recvEventDraw = store.getBoolean("receiverEventPreferencedrawPreference");
        testEventDraw = store.getBoolean("testEventPreferencedrawPreference");
        otherEventDraw = store.getBoolean("receiverEventPreferencedrawPreference");
        sendEventFill = store.getBoolean("sendEventPreferencefillPreference");
        recvEventFill = store.getBoolean("receiverEventPreferencefillPreference");
        testEventFill = store.getBoolean("testEventPreferencefillPreference");
        otherEventFill = store.getBoolean("receiverEventPreferencefillPreference");
        messageColor = new Color((Device)Display.getDefault(), PreferenceConverter.getColor((IPreferenceStore)store, (String)"messagePreferencecolorPreference"));
        sendEventColor = new Color((Device)Display.getDefault(), PreferenceConverter.getColor((IPreferenceStore)store, (String)"sendEventPreferencecolorPreference"));
        recvEventColor = new Color((Device)Display.getDefault(), PreferenceConverter.getColor((IPreferenceStore)store, (String)"receiverEventPreferencecolorPreference"));
        testEventColor = new Color((Device)Display.getDefault(), PreferenceConverter.getColor((IPreferenceStore)store, (String)"testEventPreferencecolorPreference"));
        otherEventColor = new Color((Device)Display.getDefault(), PreferenceConverter.getColor((IPreferenceStore)store, (String)"otherEventPreferencecolorPreference"));
        sendEventFillColor = new Color((Device)Display.getDefault(), PreferenceConverter.getColor((IPreferenceStore)store, (String)"sendEventPreferencefillColorPreference"));
        recvEventFillColor = new Color((Device)Display.getDefault(), PreferenceConverter.getColor((IPreferenceStore)store, (String)"receiverEventPreferencefillColorPreference"));
        testEventFillColor = new Color((Device)Display.getDefault(), PreferenceConverter.getColor((IPreferenceStore)store, (String)"testEventPreferencefillColorPreference"));
        otherEventFillColor = new Color((Device)Display.getDefault(), PreferenceConverter.getColor((IPreferenceStore)store, (String)"otherEventPreferencefillColorPreference"));
    }

    protected void handleProperyChanged(PropertyChangeEvent event) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String property = event.getProperty();
        if (property.equals("sendEventPreferencedrawPreference")) {
            sendEventDraw = store.getBoolean(property);
        } else if (property.equals("receiverEventPreferencedrawPreference")) {
            recvEventDraw = store.getBoolean(property);
        } else if (property.equals("testEventPreferencedrawPreference")) {
            testEventDraw = store.getBoolean(property);
        } else if (property.equals("otherEventPreferencedrawPreference")) {
            otherEventDraw = store.getBoolean(property);
        } else if (property.equals("sendEventPreferencefillPreference")) {
            sendEventFill = store.getBoolean(property);
        } else if (property.equals("receiverEventPreferencefillPreference")) {
            recvEventFill = store.getBoolean(property);
        } else if (property.equals("testEventPreferencefillPreference")) {
            testEventFill = store.getBoolean(property);
        } else if (property.equals("otherEventPreferencefillPreference")) {
            otherEventFill = store.getBoolean(property);
        } else if (property.equals("messagePreferencecolorPreference")) {
            messageColor.dispose();
            messageColor = new Color((Device)Display.getDefault(), PreferenceConverter.getColor((IPreferenceStore)store, (String)property));
        } else if (property.equals("sendEventPreferencecolorPreference")) {
            sendEventColor.dispose();
            sendEventColor = new Color((Device)Display.getDefault(), PreferenceConverter.getColor((IPreferenceStore)store, (String)property));
        } else if (property.equals("receiverEventPreferencecolorPreference")) {
            recvEventColor.dispose();
            recvEventColor = new Color((Device)Display.getDefault(), PreferenceConverter.getColor((IPreferenceStore)store, (String)property));
        } else if (property.equals("testEventPreferencecolorPreference")) {
            testEventColor.dispose();
            testEventColor = new Color((Device)Display.getDefault(), PreferenceConverter.getColor((IPreferenceStore)store, (String)property));
        } else if (property.equals("otherEventPreferencecolorPreference")) {
            otherEventColor.dispose();
            otherEventColor = new Color((Device)Display.getDefault(), PreferenceConverter.getColor((IPreferenceStore)store, (String)property));
        } else if (property.equals("sendEventPreferencefillColorPreference")) {
            sendEventFillColor.dispose();
            sendEventFillColor = new Color((Device)Display.getDefault(), PreferenceConverter.getColor((IPreferenceStore)store, (String)property));
        } else if (property.equals("receiverEventPreferencefillColorPreference")) {
            recvEventFillColor.dispose();
            recvEventFillColor = new Color((Device)Display.getDefault(), PreferenceConverter.getColor((IPreferenceStore)store, (String)property));
        } else if (property.equals("testEventPreferencefillColorPreference")) {
            testEventFillColor.dispose();
            testEventFillColor = new Color((Device)Display.getDefault(), PreferenceConverter.getColor((IPreferenceStore)store, (String)property));
        } else if (property.equals("otherEventPreferencefillColorPreference")) {
            otherEventFillColor.dispose();
            otherEventFillColor = new Color((Device)Display.getDefault(), PreferenceConverter.getColor((IPreferenceStore)store, (String)property));
        }
        try {
            ITraceView traceView = (ITraceView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("eu.geclipse.traceview.views.TraceView");
            traceView.redraw();
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }
}

