/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.traceview.internal;

import eu.geclipse.traceview.IEventMarker;
import eu.geclipse.traceview.ITrace;
import eu.geclipse.traceview.internal.Activator;
import eu.geclipse.traceview.internal.EventMarkerEntry;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventMarkers {
    protected List<EventMarkerEntry> eventMarkerEntries;
    protected List<IEventMarker> eventMarkers;

    public EventMarkers(ITrace trace) {
        if (this.eventMarkerEntries == null) {
            this.eventMarkerEntries = new ArrayList<EventMarkerEntry>();
            IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("eu.geclipse.traceview.EventMarker");
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                try {
                    String defaultEnabled;
                    EventMarkerEntry entry = new EventMarkerEntry();
                    entry.marker = (IEventMarker)configurationElement.createExecutableExtension("class");
                    entry.id = configurationElement.getAttribute("id");
                    entry.label = configurationElement.getAttribute("label");
                    entry.enabled = true;
                    String priority = configurationElement.getAttribute("priority");
                    if (priority != null) {
                        entry.priority = Integer.parseInt(priority);
                    }
                    if ((defaultEnabled = configurationElement.getAttribute("defaultEnabled")) != null) {
                        entry.enabled = Boolean.parseBoolean(defaultEnabled);
                    }
                    entry.marker.setTrace(trace);
                    boolean added = false;
                    int i = 0;
                    while (i < this.eventMarkerEntries.size()) {
                        if (entry.priority < this.eventMarkerEntries.get((int)i).priority) {
                            this.eventMarkerEntries.add(i, entry);
                            added = true;
                            break;
                        }
                        ++i;
                    }
                    if (!added) {
                        this.eventMarkerEntries.add(entry);
                    }
                }
                catch (CoreException coreException) {
                    Activator.logException((Exception)((Object)coreException));
                }
                ++n2;
            }
        }
        this.buildEventMarkersList();
    }

    public void buildEventMarkersList() {
        this.eventMarkers = new ArrayList<IEventMarker>();
        for (EventMarkerEntry entry : this.eventMarkerEntries) {
            if (!entry.enabled) continue;
            this.eventMarkers.add(entry.marker);
        }
    }

    public List<IEventMarker> getEventMarkers() {
        return this.eventMarkers;
    }

    public List<EventMarkerEntry> getEventMarkerEntries() {
        return this.eventMarkerEntries;
    }
}

