/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.traceview.internal;

import eu.geclipse.traceview.internal.AbstractGraphVisualization;
import eu.geclipse.traceview.internal.EventMarkerEntry;
import eu.geclipse.traceview.internal.Messages;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

class MarkerSelectionMenuCreator
implements IMenuCreator {
    private AbstractGraphVisualization graphVis;

    MarkerSelectionMenuCreator(AbstractGraphVisualization graphVis) {
        this.graphVis = graphVis;
    }

    public void dispose() {
    }

    public Menu getMenu(Control parent) {
        Menu menu = new Menu(parent);
        this.fill(menu);
        return menu;
    }

    public Menu getMenu(Menu parent) {
        Menu m = new Menu(parent);
        MenuItem item = new MenuItem(m, 8);
        item.setText(Messages.getString("MarkerSelectionMenuCreator.toggleMarkers"));
        return m;
    }

    void fill(Menu menu) {
        for (final EventMarkerEntry entry : this.graphVis.eventMarkers.getEventMarkerEntries()) {
            MenuItem item = new MenuItem(menu, 32);
            item.setText(entry.label);
            item.setSelection(entry.enabled);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    entry.enabled ^= true;
                    ((MarkerSelectionMenuCreator)MarkerSelectionMenuCreator.this).graphVis.eventMarkers.buildEventMarkersList();
                    MarkerSelectionMenuCreator.this.graphVis.redraw();
                }
            });
        }
    }
}

