/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.traceview.physicalgraph;

import eu.geclipse.traceview.EventType;
import eu.geclipse.traceview.IEvent;
import eu.geclipse.traceview.IEventMarker;
import eu.geclipse.traceview.IPhysicalEvent;
import eu.geclipse.traceview.IPhysicalProcess;
import eu.geclipse.traceview.IPhysicalTrace;
import eu.geclipse.traceview.IProcess;
import eu.geclipse.traceview.ITrace;
import eu.geclipse.traceview.internal.AbstractGraphPaintListener;
import eu.geclipse.traceview.internal.Activator;
import eu.geclipse.traceview.physicalgraph.PhysicalGraph;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.LineAttributes;

class PhysicalGraphPaintListener
extends AbstractGraphPaintListener {
    private float hzoomfactor = 1.0f;
    private int vzoomfactor = 1;
    private int maxTimeStop;
    private IPhysicalTrace trace;
    private int fromTime = 0;
    private int toTime = 0;
    private int xStep;
    private IEvent selectedEvent = null;
    private int arrowsize;
    private boolean drawMessages = true;

    PhysicalGraphPaintListener(PhysicalGraph eventGraph) {
        super(eventGraph);
    }

    protected IEvent getSelectedEvent() {
        return this.selectedEvent;
    }

    protected void setSelectedEvent(IEvent selectedEvent) {
        this.selectedEvent = selectedEvent;
    }

    protected float getHZoomfactor() {
        return this.hzoomfactor;
    }

    protected int getVZoomfactor() {
        return this.vzoomfactor;
    }

    protected boolean isDrawMessages() {
        return this.drawMessages;
    }

    protected void setDrawMessages(boolean drawMessages) {
        this.drawMessages = drawMessages;
        this.eventGraph.redraw();
    }

    public void handleResize() {
        this.correctScrollbar();
    }

    private void drawGraph() {
        int i = 0;
        while (i < this.numProc) {
            if (this.procDrawingEnabled(i)) {
                int y = this.getYPosForProcId(i) - this.eventSize / 2;
                IPhysicalProcess process = (IPhysicalProcess)this.eventGraph.getTrace().getProcess(i);
                IPhysicalEvent[] events = process.getEventsByPhysicalClock(this.fromTime - 20, this.toTime);
                Color drawColor = null;
                Color fillColor = null;
                IPhysicalEvent[] iPhysicalEventArray = events;
                int n = events.length;
                int n2 = 0;
                while (n2 < n) {
                    String name;
                    IPhysicalEvent event = iPhysicalEventArray[n2];
                    for (IEventMarker eventmarker : this.eventGraph.getEventMarkers()) {
                        int mark = eventmarker.mark(event);
                        if (mark == 0) continue;
                        Color newFillColor = eventmarker.getBackgroundColor(mark);
                        Color newDrawColor = eventmarker.getForegroundColor(mark);
                        if (newFillColor != null) {
                            fillColor = newFillColor;
                        }
                        if (newDrawColor == null) continue;
                        drawColor = newDrawColor;
                    }
                    if (drawColor != null) {
                        this.gc.setForeground(drawColor);
                    }
                    if (fillColor != null) {
                        this.gc.setBackground(fillColor);
                    }
                    int x = this.getXPosForClock(event.getPhysicalStartClock());
                    int rectangleWidth = this.getXPosForClock(event.getPhysicalStopClock()) - x;
                    int rectangleHeight = 2 * this.vzoomfactor;
                    if (fillColor != null) {
                        this.gc.fillRectangle(x, y, rectangleWidth, rectangleHeight);
                    }
                    if (rectangleHeight > this.fontsize + 2 && (name = event.getName()) != null) {
                        int textWidth = this.gc.textExtent((String)name).x;
                        int textHeight = this.gc.textExtent((String)name).y;
                        if (textWidth < rectangleWidth) {
                            this.gc.drawText(name, x + rectangleWidth / 2 - textWidth / 2, y + rectangleHeight / 2 - textHeight / 2);
                        }
                    }
                    if (drawColor != null) {
                        this.gc.drawRectangle(x, y, rectangleWidth, rectangleHeight);
                    }
                    ++n2;
                }
            }
            ++i;
        }
    }

    private void drawConnections() {
        this.arrowsize = this.vzoomfactor;
        if (this.arrowsize > 6) {
            this.arrowsize = 6;
        }
        int i = 0;
        while (i < this.numProc) {
            IPhysicalEvent[] events;
            IPhysicalEvent[] iPhysicalEventArray = events = ((IPhysicalProcess)this.eventGraph.getTrace().getProcess(i)).getEventsByPhysicalClock(this.fromTime, this.toTime);
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                IPhysicalEvent event = iPhysicalEventArray[n2];
                if (event.getType().equals((Object)EventType.SEND) || event.getType().equals((Object)EventType.RECV)) {
                    Color messageColor = null;
                    for (IEventMarker marker : this.eventGraph.getEventMarkers()) {
                        Color newColor;
                        if (marker.mark(event) == 0 || (newColor = marker.getMessageColor()) == null) continue;
                        messageColor = newColor;
                    }
                    if (messageColor != null) {
                        this.gc.setBackground(messageColor);
                        this.gc.setForeground(messageColor);
                        this.drawConnection(event);
                    }
                }
                ++n2;
            }
            ++i;
        }
    }

    private void calculateXStep() {
        int to = this.fromTime + (int)((float)this.width / this.hzoomfactor);
        int mid = (to + this.fromTime) / 2;
        int midSize = this.gc.textExtent((String)Integer.toString((int)mid)).x + 20;
        this.xStep = (int)((float)midSize / this.hzoomfactor);
    }

    private void drawHRuler() {
        this.gc.setForeground(this.gc.getDevice().getSystemColor(2));
        this.gc.setFont(this.smallFont);
        int y = this.height - 22;
        this.gc.setClipping(31, this.height - 26, this.width - 31, 26);
        int from = this.fromTime / this.xStep * this.xStep;
        int to = this.toTime / this.xStep * this.xStep + (int)((float)this.width / this.hzoomfactor);
        int i = from;
        while (i <= to) {
            int x = this.getXPosForClock(i) - this.gc.textExtent((String)Integer.toString((int)i)).x / 2;
            this.gc.drawText(Integer.toString(i), x, y);
            i += this.xStep;
        }
    }

    private void drawGridVLines() {
        this.gc.setForeground(this.line1);
        int from = this.fromTime / this.xStep * this.xStep;
        int to = this.toTime / this.xStep * this.xStep + (int)((float)this.width / this.hzoomfactor);
        int i = from;
        while (i <= to) {
            int x = this.getXPosForClock(i);
            this.gc.drawLine(x, 1, x, this.height - 31);
            i += this.xStep;
        }
    }

    public void paintControl(PaintEvent e) {
        this.gc = e.gc;
        if (this.antialiasing) {
            this.gc.setAntialias(1);
        }
        this.height = this.eventGraph.getClientArea().height - 1;
        this.width = this.eventGraph.getClientArea().width - 1;
        this.correctScrollbar();
        this.drawBackground();
        if (this.eventGraph.getTrace() != null) {
            this.toTime = Math.min(this.maxTimeStop, (int)((float)this.fromTime + (float)this.width / this.hzoomfactor));
            this.toProcessLine = Math.min(this.eventGraph.getLineToProcessMapping().size(), this.fromProcessLine + (this.height - 31 + this.eventSize) / this.vSpace + 2);
            this.calculateXStep();
            this.drawVRuler(this.gc, -1);
            this.drawHRuler();
            this.gc.setClipping(31, 1, this.width - 31, this.height - 31);
            this.drawGridHLines();
            this.drawGridVLines();
            this.drawSelection();
            this.drawGraph();
            if (this.drawMessages) {
                this.drawConnections();
            }
        }
    }

    void drawSelection() {
        ISelection selection = null;
        try {
            selection = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite().getSelectionProvider().getSelection();
        }
        catch (Exception exception) {}
        if (selection != null && selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            for (Object obj : structuredSelection.toList()) {
                IProcess process;
                if (obj instanceof IPhysicalEvent) {
                    IPhysicalEvent event = (IPhysicalEvent)obj;
                    if (event.getProcess().getTrace() != this.trace || !this.procDrawingEnabled(event.getProcessId(), true) || this.fromTime > event.getPhysicalStopClock() && event.getPartnerPhysicalStartClock() > this.toTime) continue;
                    int y = this.getYPosForProcId(event.getProcessId()) - this.eventSize / 2;
                    this.gc.setForeground(this.selectionColor);
                    this.gc.setBackground(this.selectionColor);
                    int x = this.getXPosForClock(event.getPhysicalStartClock());
                    int rectWidth = this.getXPosForClock(event.getPhysicalStopClock()) - x;
                    this.gc.fillRectangle(x - 2, y - 2, rectWidth + 5, 2 * this.vzoomfactor + 5);
                    continue;
                }
                if (!(obj instanceof IProcess) || (process = (IProcess)obj).getTrace() != this.trace || !this.procDrawingEnabled(process.getProcessId(), true)) continue;
                int x = 0;
                int y = this.getYPosForProcId(process.getProcessId()) - this.eventSize / 2;
                this.gc.setForeground(this.selectionColor);
                this.gc.setBackground(this.selectionColor);
                this.gc.fillRectangle(x, y + this.eventSize / 4, this.width, this.eventSize / 2);
            }
        }
    }

    private void correctScrollbar() {
        int max = (int)((float)this.maxTimeStop * this.hzoomfactor - (float)this.width + 250.0f) / 10;
        if (max < 1) {
            this.horizontalScrollBar.setMaximum(1);
            this.fromTime = 0;
        } else {
            this.horizontalScrollBar.setMaximum(max);
        }
        this.verticalScrollBar.setMaximum(this.vSpace * this.numProc);
    }

    public void setHorizontal(int selection) {
        this.fromTime = (int)((float)selection / this.hzoomfactor) * 10;
    }

    public int getDiff() {
        return this.toTime - this.fromTime;
    }

    public void setTrace(ITrace trace) {
        this.trace = (IPhysicalTrace)trace;
        if (this.trace != null) {
            this.maxTimeStop = this.trace.getMaximumPhysicalClock();
            this.numProc = this.trace.getNumberOfProcesses();
        }
    }

    void updateMaxTimeStop() {
        this.maxTimeStop = this.trace.getMaximumPhysicalClock();
        this.correctScrollbar();
    }

    protected int getNumProc() {
        return this.numProc;
    }

    protected int getMaxTimeStop() {
        return this.maxTimeStop;
    }

    protected void setZoomfactor(int zoomfactor) {
        this.hSpace = 6 * zoomfactor;
        this.vSpace = 6 * zoomfactor;
        this.eventSize = 2 * zoomfactor;
        this.correctScrollbar();
        this.horizontalScrollBar.setPageIncrement(this.hSpace);
        this.verticalScrollBar.setPageIncrement(this.vSpace);
    }

    protected void setHZoomfactor(float zoomfactor) {
        this.hSpace = (int)(6.0f * zoomfactor);
        if (this.hSpace < 1) {
            this.hSpace = 1;
        }
        this.hzoomfactor = zoomfactor;
    }

    protected void setVZoomfactor(int zoomfactor) {
        this.vSpace = 6 * zoomfactor;
        if (this.vSpace < 12) {
            this.vSpace = 12;
        }
        this.eventSize = 2 * zoomfactor;
        this.vzoomfactor = zoomfactor;
        this.correctScrollbar();
        this.verticalScrollBar.setPageIncrement(this.vSpace);
    }

    protected void setNumProc(int numProc) {
        this.numProc = numProc;
    }

    public void print(GC gc2) {
        this.gc = gc2;
        this.gc.setLineAttributes(new LineAttributes(1.0f));
        this.calculateXStep();
        this.drawVRuler(this.gc, -1);
        this.drawHRuler();
        this.gc.setClipping(31, 1, this.width - 31, this.height - 31);
        this.drawGridHLines();
        this.drawGridVLines();
        this.drawSelection();
        this.drawGraph();
        if (this.drawMessages) {
            this.drawConnections();
        }
    }

    public int getArrowSize() {
        return this.arrowsize;
    }

    void drawConnection(IPhysicalEvent event) {
        if (event.getPartnerProcessId() != -1 && this.procDrawingEnabled(event.getProcessId()) && this.procDrawingEnabled(event.getPartnerProcessId())) {
            int x1 = this.getXPosForClock(event.getPhysicalStopClock());
            int y1 = this.getYPosForProcId(event.getProcessId());
            int x2 = this.getXPosForClock(event.getPartnerPhysicalStopClock());
            int y2 = this.getYPosForProcId(event.getPartnerProcessId());
            if (y1 == y2) {
                return;
            }
            if (event.getType() == EventType.SEND) {
                this.connection(x1, y1, x2, y2, false);
            } else {
                this.connection(x2, y2, x1, y1, false);
            }
        }
    }

    private int getXPosForClock(int physicalClock) {
        return (int)(50.0f + (float)(physicalClock - this.fromTime) * this.hzoomfactor);
    }
}

