/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.traceview.preferences;

import eu.geclipse.traceview.internal.Activator;
import eu.geclipse.traceview.internal.Messages;
import eu.geclipse.traceview.preferences.EventPreferenceEditor;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    IPreferenceStore store = Activator.getDefault().getPreferenceStore();
    Button button;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        this.setTitle(Messages.getString("PreferencePage.Title"));
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        GridData layoutData = new GridData(4, 4, true, true);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)layoutData);
        this.createEventsGroup(composite);
        this.createMessagesGroup(composite);
        this.createSettingsGroup(composite);
        this.createCacheGroup(composite);
        return null;
    }

    private void createCacheGroup(Composite composite) {
        GridLayout layout = new GridLayout();
        GridData layoutData = new GridData(4, 4, true, false);
        layout.numColumns = 2;
        Group cacheGroup = new Group(composite, 0);
        cacheGroup.setLayout((Layout)layout);
        cacheGroup.setLayoutData((Object)layoutData);
        cacheGroup.setText("Trace cache");
        cacheGroup.setLayout((Layout)new GridLayout(3, false));
        Label cacheDirLabel = new Label((Composite)cacheGroup, 0);
        cacheDirLabel.setText("Cache directory:");
        final Text cacheDirText = new Text((Composite)cacheGroup, 2056);
        GridData gData = new GridData(4, 4, true, false);
        cacheDirText.setLayoutData((Object)gData);
        cacheDirText.setText(this.store.getString("cacheDir"));
        Button cacheDirBrowseButton = new Button((Composite)cacheGroup, 0);
        cacheDirBrowseButton.setText("Browse...");
        cacheDirBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(PreferencesPage.this.getShell(), 4096);
                dialog.setText("Select trace cache directory");
                dialog.setFilterPath(cacheDirText.getText());
                String dir = dialog.open();
                if (dir != null) {
                    cacheDirText.setText(dir);
                    PreferencesPage.this.store.setValue("cacheDir", dir);
                }
            }
        });
    }

    private void createEventsGroup(Composite composite) {
        GridLayout layout = new GridLayout();
        GridData layoutData = new GridData(4, 4, true, false);
        layout.numColumns = 6;
        Group eventGroup = new Group(composite, 0);
        eventGroup.setLayout((Layout)layout);
        eventGroup.setLayoutData((Object)layoutData);
        eventGroup.setText(Messages.getString("PreferencePage.Events"));
        new EventPreferenceEditor((Composite)eventGroup, Messages.getString("PreferencePage.SendEvents"), "sendEventPreference");
        new EventPreferenceEditor((Composite)eventGroup, Messages.getString("PreferencePage.ReceiveEvents"), "receiverEventPreference");
        new EventPreferenceEditor((Composite)eventGroup, Messages.getString("PreferencePage.TestEvents"), "testEventPreference");
        new EventPreferenceEditor((Composite)eventGroup, Messages.getString("PreferencePage.OtherEvents"), "otherEventPreference");
    }

    private void createMessagesGroup(Composite composite) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData layoutData = new GridData(4, 4, true, false);
        Group messageGroup = new Group(composite, 0);
        messageGroup.setLayout((Layout)layout);
        messageGroup.setLayoutData((Object)layoutData);
        messageGroup.setText(Messages.getString("PreferencePage.Messages"));
        Label name = new Label((Composite)messageGroup, 0);
        name.setText(Messages.getString("PreferencePage.Message"));
        ColorSelector colorSelector = new ColorSelector((Composite)messageGroup);
        colorSelector.setColorValue(PreferenceConverter.getColor((IPreferenceStore)this.store, (String)"messagePreferencecolorPreference"));
        GridData gd = new GridData();
        gd.widthHint = 32;
        gd.heightHint = 16;
        colorSelector.getButton().setLayoutData((Object)gd);
        colorSelector.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getNewValue() instanceof RGB) {
                    RGB rgb = (RGB)event.getNewValue();
                    PreferenceConverter.setValue((IPreferenceStore)PreferencesPage.this.store, (String)"messagePreferencecolorPreference", (RGB)rgb);
                }
            }
        });
    }

    private void createSettingsGroup(Composite composite) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData layoutData = new GridData(4, 4, true, false);
        Group settingsGroup = new Group(composite, 0);
        settingsGroup.setLayout((Layout)layout);
        settingsGroup.setLayoutData((Object)layoutData);
        settingsGroup.setText(Messages.getString("PreferencePage.Settings"));
        layoutData = new GridData(4, 4, true, false);
        layoutData.horizontalSpan = 2;
        this.button = new Button((Composite)settingsGroup, 32);
        this.button.setText(Messages.getString("PreferencePage.AntiAliasing"));
        this.button.setSelection(this.store.getBoolean("antiAliasingPreference"));
        this.button.setLayoutData((Object)layoutData);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PreferencesPage.this.store.setValue("antiAliasingPreference", PreferencesPage.this.button.getSelection());
            }
        });
        Label name = new Label((Composite)settingsGroup, 0);
        name.setText(Messages.getString("PreferencePage.SelectionColor"));
        ColorSelector colorSelector = new ColorSelector((Composite)settingsGroup);
        colorSelector.setColorValue(PreferenceConverter.getColor((IPreferenceStore)this.store, (String)"selectionColorPreference"));
        GridData gd = new GridData();
        gd.widthHint = 32;
        gd.heightHint = 16;
        colorSelector.getButton().setLayoutData((Object)gd);
        colorSelector.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getNewValue() instanceof RGB) {
                    RGB rgb = (RGB)event.getNewValue();
                    PreferenceConverter.setValue((IPreferenceStore)PreferencesPage.this.store, (String)"selectionColorPreference", (RGB)rgb);
                }
            }
        });
    }
}

