/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.traceview.utils;

import eu.geclipse.traceview.IEvent;
import eu.geclipse.traceview.ILamportEvent;
import eu.geclipse.traceview.IPhysicalEvent;
import eu.geclipse.traceview.ISourceLocation;
import eu.geclipse.traceview.IVectorEvent;
import java.util.Arrays;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public abstract class AbstractEvent
implements IEvent {
    public static final String PROP_TYPE = "Event.Type";
    public static final String PROP_PROCESS = "Event.Process";
    public static final String PROP_PARTNER_PROCESS = "Event.PartnerProcess";
    public static final String PROP_LOGICALCLOCK = "Event.LogicalClock";
    public static final String PROP_PARTNER_LOGICALCLOCK = "Event.PartnerLogicalClock";
    public static final String PROP_LAMPORTCLOCK = "LamportEvent.LamportClock";
    public static final String PROP_PARTNER_LAMPORTCLOCK = "LamportEvent.PartnerLamportClock";
    public static final String PROP_SOURCE_FILE = "SourceLocation.SourceFile";
    public static final String PROP_SOURCE_LINE = "SourceLocation.SourceLine";
    public static final String PROP_TIME_START = "PhysicalEvent.TimeStart";
    public static final String PROP_TIME_END = "PhysicalEvent.TimeEnd";
    public static final String PROP_VECTORCLOCK = "VectorEvent.VectorClock";
    private static IPropertyDescriptor[] eventDescriptors = new IPropertyDescriptor[]{new PropertyDescriptor((Object)"Event.Type", "Message Type"), new PropertyDescriptor((Object)"Event.Process", "Process"), new PropertyDescriptor((Object)"Event.LogicalClock", "Logical Clock"), new PropertyDescriptor((Object)"Event.PartnerLogicalClock", "Partner Logical Clock")};
    private static IPropertyDescriptor[] lamportEventDescriptors = new IPropertyDescriptor[]{new PropertyDescriptor((Object)"LamportEvent.LamportClock", "Lamport Clock"), new PropertyDescriptor((Object)"LamportEvent.PartnerLamportClock", "Partner Lamport Clock")};
    private static IPropertyDescriptor[] sourceLocationDescriptors = new IPropertyDescriptor[]{new PropertyDescriptor((Object)"SourceLocation.SourceFile", "Source File"), new PropertyDescriptor((Object)"SourceLocation.SourceLine", "Source Line")};
    private static IPropertyDescriptor[] physicalEventDescriptors = new IPropertyDescriptor[]{new PropertyDescriptor((Object)"PhysicalEvent.TimeStart", "Time Start"), new PropertyDescriptor((Object)"PhysicalEvent.TimeEnd", "Time End")};
    private static IPropertyDescriptor[] vectorEventDescriptors = new IPropertyDescriptor[]{new PropertyDescriptor((Object)"VectorEvent.VectorClock", "Vector Clock")};

    public String toString() {
        return "Type: " + this.getType().name();
    }

    public String getName() {
        return this.getType().name();
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        int count = eventDescriptors.length;
        if (this instanceof ILamportEvent) {
            count += lamportEventDescriptors.length;
        }
        if (this instanceof IPhysicalEvent) {
            count += physicalEventDescriptors.length;
        }
        if (this instanceof ISourceLocation) {
            count += sourceLocationDescriptors.length;
        }
        if (this instanceof IVectorEvent) {
            count += vectorEventDescriptors.length;
        }
        IPropertyDescriptor[] descriptors = new IPropertyDescriptor[count];
        int pos = 0;
        System.arraycopy(eventDescriptors, 0, descriptors, 0, eventDescriptors.length);
        pos += eventDescriptors.length;
        if (this instanceof ILamportEvent) {
            System.arraycopy(lamportEventDescriptors, 0, descriptors, pos, lamportEventDescriptors.length);
            pos += lamportEventDescriptors.length;
        }
        if (this instanceof IPhysicalEvent) {
            System.arraycopy(physicalEventDescriptors, 0, descriptors, pos, physicalEventDescriptors.length);
            pos += physicalEventDescriptors.length;
        }
        if (this instanceof ISourceLocation) {
            System.arraycopy(sourceLocationDescriptors, 0, descriptors, pos, sourceLocationDescriptors.length);
            pos += sourceLocationDescriptors.length;
        }
        if (this instanceof IVectorEvent) {
            System.arraycopy(vectorEventDescriptors, 0, descriptors, pos, vectorEventDescriptors.length);
            pos += vectorEventDescriptors.length;
        }
        return descriptors;
    }

    public Object getPropertyValue(Object id) {
        Object result = null;
        if (id.equals(PROP_TYPE)) {
            result = this.getType();
        } else if (id.equals(PROP_PROCESS)) {
            result = this.getProcessId();
        } else if (id.equals(PROP_PARTNER_PROCESS)) {
            result = this.getPartnerProcessId();
        } else if (id.equals(PROP_LOGICALCLOCK)) {
            result = this.getLogicalClock();
        } else if (id.equals(PROP_PARTNER_LOGICALCLOCK)) {
            result = this.getPartnerLogicalClock();
        } else if (this instanceof ILamportEvent && id.equals(PROP_LAMPORTCLOCK)) {
            result = ((ILamportEvent)((Object)this)).getLamportClock();
        } else if (this instanceof ILamportEvent && id.equals(PROP_PARTNER_LAMPORTCLOCK)) {
            result = ((ILamportEvent)((Object)this)).getPartnerLamportClock();
        } else if (this instanceof IPhysicalEvent && id.equals(PROP_TIME_START)) {
            result = ((IPhysicalEvent)((Object)this)).getPhysicalStartClock();
        } else if (this instanceof IPhysicalEvent && id.equals(PROP_TIME_END)) {
            result = ((IPhysicalEvent)((Object)this)).getPhysicalStopClock();
        } else if (this instanceof ISourceLocation && id.equals(PROP_SOURCE_FILE)) {
            result = ((ISourceLocation)((Object)this)).getSourceFilename();
        } else if (this instanceof ISourceLocation && id.equals(PROP_SOURCE_LINE)) {
            result = ((ISourceLocation)((Object)this)).getSourceLineNumber();
        } else if (this instanceof IVectorEvent && id.equals(PROP_VECTORCLOCK)) {
            result = Arrays.toString(((IVectorEvent)((Object)this)).getVectorClock());
        }
        return result;
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public Object getEditableValue() {
        return null;
    }

    public boolean equals(Object obj) {
        return obj instanceof AbstractEvent && ((AbstractEvent)obj).getProcess() == this.getProcess() && ((AbstractEvent)obj).getLogicalClock() == this.getLogicalClock();
    }

    public int hashCode() {
        return this.getProcess().hashCode() + this.getLogicalClock();
    }
}

