/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.traceview.utils;

import eu.geclipse.traceview.ITrace;
import eu.geclipse.traceview.utils.AbstractProcess;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFileCacheProcess
extends AbstractProcess {
    protected static final int sizeInc = 1000;
    protected IntBuffer buffer;
    protected int eventSize;
    protected RandomAccessFile file;
    protected File cacheDir;
    protected int processId;
    protected List<String> sourceFilenames;
    protected ITrace trace;

    public AbstractFileCacheProcess(ITrace trace, int processId, List<String> sourceFilenames, File cacheDir) {
        this.trace = trace;
        this.processId = processId;
        this.cacheDir = cacheDir;
        this.sourceFilenames = sourceFilenames;
    }

    @Override
    public int getMaximumLogicalClock() {
        return this.buffer.limit() / (this.eventSize / 4) - 1;
    }

    @Override
    public int getProcessId() {
        return this.processId;
    }

    public String getSourceFilenameForIndex(int index) {
        return this.sourceFilenames.get(index);
    }

    public IntBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public ITrace getTrace() {
        return this.trace;
    }

    public int getEventSize() {
        return this.eventSize;
    }

    public void checkCacheLimit(int logClock) throws IOException {
        if (this.getMaximumLogicalClock() < logClock) {
            if (logClock < this.buffer.capacity() / (this.eventSize / 4)) {
                this.buffer.limit((logClock + 1) * (this.eventSize / 4));
            } else {
                this.buffer = this.file.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, (logClock + 1000) * this.eventSize).order(ByteOrder.nativeOrder()).asIntBuffer();
                this.buffer.limit((logClock + 1) * (this.eventSize / 4));
            }
        }
    }

    public void truncateToTraceSize() throws IOException {
        int nrOfEvents = this.getMaximumLogicalClock() + 1;
        this.buffer = null;
        File out = new File(this.cacheDir, Integer.toString(this.processId));
        RandomAccessFile ran = new RandomAccessFile(out, "rw");
        this.file.getChannel().transferTo(0L, this.file.length(), ran.getChannel());
        ran.setLength(nrOfEvents * this.eventSize);
        this.buffer = ran.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, ran.length()).order(ByteOrder.nativeOrder()).asIntBuffer();
    }
}

