/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.traceview.utils;

import eu.geclipse.traceview.internal.BufferedRandomAccessFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;

public class TraceCacheFile {
    private IntBuffer buffer;
    private BufferedRandomAccessFile randAccFile;

    public TraceCacheFile(File dir, int fileNr) throws FileNotFoundException {
        this.openCacheFile(new File(dir, "cachefile_" + fileNr));
    }

    public void close() throws IOException {
        if (this.randAccFile != null) {
            this.randAccFile.close();
        }
    }

    public void openCacheFile(File file) throws FileNotFoundException {
        this.randAccFile = new BufferedRandomAccessFile(file, "rw");
    }

    public void enableMemoryMap() throws IOException {
        this.buffer = this.randAccFile.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, this.randAccFile.length()).order(ByteOrder.nativeOrder()).asIntBuffer();
        this.randAccFile.close();
    }

    public int read(int offset) throws IOException {
        int value;
        if (this.buffer != null) {
            value = this.buffer.get(offset);
        } else {
            this.randAccFile.seek(4 * offset);
            value = this.randAccFile.readInt();
            if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
                value = TraceCacheFile.swapInt(value);
            }
        }
        return value;
    }

    public void read(int offset, int[] data) throws IOException {
        if (this.buffer != null) {
            this.buffer.position(offset);
            this.buffer.get(data, 0, data.length);
        } else {
            this.randAccFile.seek(offset * 4);
            int i = 0;
            while (i < data.length) {
                int value = this.randAccFile.readInt();
                if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
                    value = TraceCacheFile.swapInt(value);
                }
                data[i] = value;
                ++i;
            }
        }
    }

    private static int swapInt(int value) {
        int b1 = value >> 0 & 0xFF;
        int b2 = value >> 8 & 0xFF;
        int b3 = value >> 16 & 0xFF;
        int b4 = value >> 24 & 0xFF;
        return b1 << 24 | b2 << 16 | b3 << 8 | b4 << 0;
    }

    public void write(int offset, int value) throws IOException {
        if (this.buffer != null) {
            this.buffer.put(offset, value);
        } else {
            int outVal = value;
            if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
                outVal = TraceCacheFile.swapInt(value);
            }
            this.randAccFile.seek(offset * 4);
            this.randAccFile.writeInt(outVal);
        }
    }

    public void write(int offset, int[] value) throws IOException {
        if (this.buffer != null) {
            this.buffer.position(offset);
            this.buffer.put(value, 0, value.length);
        } else {
            this.randAccFile.seek(offset * 4);
            int i = 0;
            while (i < value.length) {
                int outVal = value[i];
                if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
                    outVal = TraceCacheFile.swapInt(outVal);
                }
                this.randAccFile.writeInt(outVal);
                ++i;
            }
        }
    }
}

