/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.traceview.views;

import eu.geclipse.traceview.ITrace;
import eu.geclipse.traceview.ITraceReader;
import eu.geclipse.traceview.ITraceView;
import eu.geclipse.traceview.TraceVisualization;
import eu.geclipse.traceview.internal.Activator;
import eu.geclipse.traceview.internal.Messages;
import eu.geclipse.traceview.views.DropDown;
import eu.geclipse.traceview.views.internal.SelectionProvider;
import eu.geclipse.traceview.views.internal.TraceVisPage;
import java.io.IOException;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;

public class TraceView
extends ViewPart
implements ITraceView {
    protected TraceVisPage traceVisPage = null;
    FileDialog fileDialog;
    CTabFolder cTabFolder = null;
    private ISelectionProvider selectionProvider;
    private MenuManager contextMenuMgr;
    private Action visualisationDropDownAction;

    public void addTrace(ITrace trace) {
        if (trace != null) {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("eu.geclipse.traceview.views.TraceView");
                this.getViewSite().getActionBars().getToolBarManager().removeAll();
                this.traceVisPage = new TraceVisPage(this.cTabFolder, 0, this.getViewSite(), this, trace);
            }
            catch (PartInitException exception) {
                Activator.logException((Exception)((Object)exception));
            }
        }
    }

    public void createToolbar(String id) {
        Action add = new Action(Messages.getString("TraceView.Open"), Activator.getImageDescriptor("icons/open.gif")){

            public void run() {
                String tracePathString = TraceView.this.fileDialog.open();
                if (tracePathString != null) {
                    Path path = new Path(tracePathString);
                    String extension = path.getFileExtension();
                    IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("eu.geclipse.traceview.TraceReader");
                    int n = iConfigurationElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                        if (configurationElement.getAttribute("fileextension").equals(extension)) {
                            try {
                                final ITraceReader traceReader = (ITraceReader)configurationElement.createExecutableExtension("class");
                                Job openTraceJob = new Job("Opening Trace", (IPath)path){
                                    private final /* synthetic */ IPath val$path;
                                    {
                                        this.val$path = iPath;
                                        super($anonymous0);
                                    }

                                    protected IStatus run(IProgressMonitor monitor) {
                                        IStatus status = Status.OK_STATUS;
                                        try {
                                            final ITrace trace = traceReader.openTrace(this.val$path, monitor);
                                            if (trace != null) {
                                                Display.getDefault().syncExec(new Runnable(){

                                                    public void run() {
                                                        TraceView.this.addTrace(trace);
                                                    }
                                                });
                                            }
                                        }
                                        catch (IOException exception) {
                                            Activator.logException(exception);
                                            status = Status.CANCEL_STATUS;
                                        }
                                        return status;
                                    }
                                };
                                openTraceJob.setUser(true);
                                openTraceJob.schedule();
                            }
                            catch (CoreException exception) {
                                Activator.logException((Exception)((Object)exception));
                            }
                        }
                        ++n2;
                    }
                }
            }
        };
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        this.visualisationDropDownAction = new Action(Messages.getString("TraceView.switchVisualization"), Activator.getImageDescriptor("icons/changevis.gif")){

            public void run() {
            }
        };
        DropDown menuCreator = new DropDown(this, id);
        this.visualisationDropDownAction.setMenuCreator((IMenuCreator)menuCreator);
        this.visualisationDropDownAction.setEnabled(id != null && this.cTabFolder != null && this.cTabFolder.getItemCount() != 0);
        mgr.add((IAction)this.visualisationDropDownAction);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)add);
    }

    public void createPartControl(Composite parent) {
        this.selectionProvider = new SelectionProvider();
        this.fileDialog = new FileDialog(this.getSite().getShell(), 4096);
        this.fileDialog.setText(Messages.getString("TraceView.openTrace"));
        Vector<String> extensions = new Vector<String>();
        Vector<String> names = new Vector<String>();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("eu.geclipse.traceview.TraceReader");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            names.add(configurationElement.getAttribute("label"));
            extensions.add("*." + configurationElement.getAttribute("fileextension"));
            ++n2;
        }
        this.fileDialog.setFilterExtensions(extensions.toArray(new String[0]));
        this.fileDialog.setFilterNames(names.toArray(new String[0]));
        this.createToolbar(null);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        this.cTabFolder = new CTabFolder(parent, 0x800400);
        this.cTabFolder.setLayoutData((Object)gridData);
        this.getSite().setSelectionProvider(this.selectionProvider);
        this.cTabFolder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void close(CTabFolderEvent event) {
                if (TraceView.this.cTabFolder.getItemCount() == 1) {
                    TraceView.this.getViewSite().getActionBars().getToolBarManager().removeAll();
                    TraceView.this.createToolbar(null);
                    TraceView.this.getViewSite().getActionBars().getToolBarManager().update(true);
                }
            }
        });
        this.cTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TraceView.this.getViewSite().getActionBars().getToolBarManager().removeAll();
                if (e.item instanceof CTabItem) {
                    CTabItem item = (CTabItem)e.item;
                    TraceView.this.traceVisPage = (TraceVisPage)item.getControl();
                    if (((TraceVisPage)item.getControl()).getItems() != null) {
                        IContributionItem[] iContributionItemArray = ((TraceVisPage)item.getControl()).getItems();
                        int n = iContributionItemArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IContributionItem citem = iContributionItemArray[n2];
                            TraceView.this.getViewSite().getActionBars().getToolBarManager().add(citem);
                            ++n2;
                        }
                    }
                }
                TraceView.this.createToolbar(TraceView.this.traceVisPage.getVisualisationID());
                TraceView.this.getViewSite().getActionBars().getToolBarManager().update(true);
                super.widgetSelected(e);
            }
        });
        this.contextMenuMgr = new MenuManager("#PopupMenu");
        this.contextMenuMgr.add((IContributionItem)new Separator("additions"));
        this.contextMenuMgr.add((IContributionItem)new Separator("additions-end"));
        this.getSite().registerContextMenu(this.contextMenuMgr, this.getSite().getSelectionProvider());
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.PRINT.getId(), (IAction)new Action(){

            public void run() {
                CTabItem item = TraceView.this.cTabFolder.getSelection();
                if (item != null && item.getControl() != null) {
                    PrintDialog printDialog = new PrintDialog(Display.getDefault().getActiveShell());
                    printDialog.setText("Print Trace");
                    PrinterData printerData = printDialog.open();
                    if (printerData != null) {
                        Printer printer = new Printer(printerData);
                        if (printer.startJob("Trace graph")) {
                            GC gc = new GC((Drawable)printer);
                            if (printer.startPage()) {
                                ((TraceVisPage)item.getControl()).printTrace(gc);
                                printer.endPage();
                            }
                            gc.dispose();
                            printer.endJob();
                        }
                        printer.dispose();
                    }
                }
            }
        });
    }

    public MenuManager getContextMenuManager() {
        return this.contextMenuMgr;
    }

    public void setFocus() {
        this.cTabFolder.setFocus();
    }

    public ITrace getTrace() {
        return ((TraceVisPage)this.cTabFolder.getSelection().getControl()).getTrace();
    }

    public void redraw() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                CTabItem item = TraceView.this.cTabFolder.getSelection();
                if (item != null) {
                    ((TraceVisPage)item.getControl()).redrawVisualisation();
                }
            }
        });
    }

    public TraceVisualization getVisualisationForTrace(final ITrace trace) {
        final TraceVisualization[] vis = new TraceVisualization[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                CTabItem[] items;
                CTabItem[] cTabItemArray = items = TraceView.this.cTabFolder.getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    CTabItem item = cTabItemArray[n2];
                    TraceVisPage visPage = (TraceVisPage)item.getControl();
                    if (visPage.getTrace() == trace) {
                        vis[0] = visPage.getVisualization();
                    }
                    ++n2;
                }
            }
        });
        return vis[0];
    }
}

