/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.traceview.views.internal;

import eu.geclipse.traceview.ITrace;
import eu.geclipse.traceview.ITraceVisProvider;
import eu.geclipse.traceview.TraceVisualization;
import eu.geclipse.traceview.views.TraceView;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewSite;

public class TraceVisPage
extends Composite {
    protected IContributionItem[] items = new IContributionItem[0];
    private TraceVisualization visualization;
    private ITrace trace;
    private IViewSite viewSite;
    private TraceView traceView;
    private String visualisationID;

    public TraceVisPage(CTabFolder cTabFolder, int style, IViewSite viewSite, TraceView traceView, ITrace trace) {
        super((Composite)cTabFolder, style);
        this.traceView = traceView;
        this.viewSite = viewSite;
        this.trace = trace;
        GridLayout gridLayout = new GridLayout();
        GridData gridData = new GridData();
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(gridData);
        CTabItem cTabItem = new CTabItem(cTabFolder, 64);
        cTabItem.setControl((Control)this);
        cTabItem.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TraceVisPage.this.dispose();
            }
        });
        cTabItem.setText(this.trace.getName());
        cTabFolder.setSelection(cTabItem);
        this.changeToVisualisation("eu.geclipse.traceview.logicalgraph.LogicalGraphProvider");
    }

    public String getVisualisationID() {
        return this.visualisationID;
    }

    public void changeToVisualisation(String id) {
        if (id != null) {
            this.visualisationID = id;
            IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("eu.geclipse.traceview.TraceVisualization");
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                if (id.equals(configurationElement.getAttribute("id"))) {
                    this.traceView.getViewSite().getActionBars().getToolBarManager().removeAll();
                    this.traceView.getViewSite().getActionBars().getToolBarManager().update(true);
                    if (this.visualization != null && !this.visualization.isDisposed()) {
                        this.visualization.dispose();
                    }
                    try {
                        ITraceVisProvider provider = (ITraceVisProvider)configurationElement.createExecutableExtension("class");
                        this.visualization = provider.getTraceVis(this, 0, this.viewSite, this.trace);
                        this.items = this.visualization.getToolBarItems();
                    }
                    catch (CoreException coreException) {}
                    if (this.items != null) {
                        IContributionItem[] iContributionItemArray = this.items;
                        int n3 = this.items.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IContributionItem item = iContributionItemArray[n4];
                            this.traceView.getViewSite().getActionBars().getToolBarManager().add(item);
                            ++n4;
                        }
                    }
                    this.traceView.createToolbar(id);
                    this.viewSite.getActionBars().getToolBarManager().update(true);
                    this.layout(true);
                }
                ++n2;
            }
        }
    }

    public IContributionItem[] getItems() {
        return this.items;
    }

    public void dispose() {
        IContributionItem[] iContributionItemArray = this.items;
        int n = this.items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            this.viewSite.getActionBars().getToolBarManager().remove(item);
            ++n2;
        }
        this.viewSite.getActionBars().getToolBarManager().update(true);
        this.layout(true);
        super.dispose();
    }

    public ITrace getTrace() {
        return this.trace;
    }

    public void redrawVisualisation() {
        if (this.visualization != null && !this.visualization.isDisposed()) {
            this.visualization.redraw();
        }
    }

    public void printTrace(GC gc) {
        this.visualization.printTrace(gc);
    }

    public TraceVisualization getVisualization() {
        return this.visualization;
    }
}

