/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui;

import eu.geclipse.core.auth.AuthTokenRequest;
import eu.geclipse.core.auth.AuthenticationException;
import eu.geclipse.core.auth.CoreAuthTokenProvider;
import eu.geclipse.core.auth.IAuthTokenProvider;
import eu.geclipse.core.auth.IAuthenticationToken;
import eu.geclipse.core.auth.IAuthenticationTokenDescription;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.Messages;
import eu.geclipse.ui.dialogs.ProblemDialog;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.wizards.wizardselection.ExtPointWizardSelectionListPage;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.cheatsheets.CheatSheetListener;
import org.eclipse.ui.cheatsheets.ICheatSheetEvent;
import org.eclipse.ui.cheatsheets.ICheatSheetManager;

public class UIAuthTokenProvider
extends CheatSheetListener
implements IAuthTokenProvider {
    protected static ICheatSheetManager cheatSheetManager;
    private static final String WIZARD_PAGE_NAME = "pagename";
    protected Shell shell;
    protected Display display;

    public UIAuthTokenProvider() {
        this(null);
    }

    public UIAuthTokenProvider(Shell shell) {
        IWorkbenchWindow window;
        IWorkbench workbench = PlatformUI.getWorkbench();
        this.display = workbench.getDisplay();
        this.shell = shell;
        if (shell == null && (window = workbench.getActiveWorkbenchWindow()) != null) {
            this.shell = window.getShell();
        }
    }

    public IAuthenticationToken requestToken() throws ProblemException {
        return this.requestToken(null);
    }

    public IAuthenticationToken requestToken(AuthTokenRequest request) throws ProblemException {
        IAuthenticationToken token = null;
        Throwable t = null;
        CoreAuthTokenProvider cProvider = new CoreAuthTokenProvider();
        try {
            token = cProvider.requestToken(request);
        }
        catch (Exception e) {
            t = e;
        }
        if (token == null && t == null) {
            Runner runner = new Runner(request, cProvider);
            this.runInUIThread(runner);
            if (runner.exc != null) {
                throw runner.exc;
            }
            token = runner.token;
        }
        if (token != null) {
            try {
                if (!token.isValid()) {
                    this.validateToken(token);
                }
                if (!token.isActive()) {
                    this.activateToken(token);
                }
            }
            catch (InvocationTargetException itExc) {
                t = itExc.getCause();
                if (t == null) {
                    t = itExc;
                }
            }
            catch (InterruptedException intExc) {
                t = intExc;
            }
        }
        if (t != null) {
            ProblemDialog.openProblem(this.shell, Messages.getString("UIAuthTokenProvider.token_activation_error_title"), Messages.getString("UIAuthTokenProvider.token_activation_error_message"), t);
        }
        return token;
    }

    public boolean showNewTokenWizard(final String tokenWizardId, final boolean forceWizardId, final IAuthenticationTokenDescription description) {
        URL imgUrl = Activator.getDefault().getBundle().getEntry("icons/wizban/newtoken_wiz.gif");
        Wizard wizard = new Wizard(){

            public boolean performFinish() {
                return false;
            }

            public void addPages() {
                LinkedList<String> filterList = null;
                if (tokenWizardId != null) {
                    filterList = new LinkedList<String>();
                    filterList.add(tokenWizardId);
                }
                ExtPointWizardSelectionListPage page = new ExtPointWizardSelectionListPage(UIAuthTokenProvider.WIZARD_PAGE_NAME, "eu.geclipse.ui.authTokenUI", filterList, forceWizardId, Messages.getString("UIAuthTokenProvider.wizard_first_page_title"), Messages.getString("UIAuthTokenProvider.wizard_first_page_description"), Messages.getString("UIAuthTokenProvider.noTokenCreator"));
                page.setInitData(description);
                page.setCheatSheetManager(cheatSheetManager);
                this.addPage((IWizardPage)page);
            }
        };
        wizard.setNeedsProgressMonitor(true);
        wizard.setForcePreviousAndNextButtons(true);
        wizard.setWindowTitle(Messages.getString("UIAuthTokenProvider.wizard_title"));
        wizard.setDefaultPageImageDescriptor(ImageDescriptor.createFromURL((URL)imgUrl));
        WizardDialog dialog = new WizardDialog(this.shell, (IWizard)wizard);
        return dialog.open() == 0;
    }

    protected void validateToken(final IAuthenticationToken token) throws InvocationTargetException, InterruptedException {
        final Exception[] exc = new Exception[1];
        Runnable runnable = new Runnable(){

            public void run() {
                ProgressMonitorDialog progMon = new ProgressMonitorDialog(UIAuthTokenProvider.this.shell);
                try {
                    progMon.run(false, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                token.validate(monitor);
                            }
                            catch (AuthenticationException authExc) {
                                throw new InvocationTargetException(authExc);
                            }
                        }
                    });
                }
                catch (InvocationTargetException exception) {
                    exc[0] = exception;
                }
                catch (InterruptedException exception) {
                    exc[0] = exception;
                }
            }
        };
        this.runInUIThread(runnable);
        if (exc[0] instanceof InvocationTargetException) {
            throw (InvocationTargetException)exc[0];
        }
        if (exc[0] instanceof InterruptedException) {
            throw (InterruptedException)exc[0];
        }
    }

    protected void activateToken(final IAuthenticationToken token) throws InvocationTargetException, InterruptedException {
        final Exception[] exc = new Exception[1];
        Runnable uiRunnable = new Runnable(){

            public void run() {
                ProgressMonitorDialog progMon = new ProgressMonitorDialog(UIAuthTokenProvider.this.shell);
                try {
                    progMon.run(false, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException {
                            try {
                                token.setActive(true, monitor);
                            }
                            catch (AuthenticationException authExc) {
                                throw new InvocationTargetException(authExc);
                            }
                        }
                    });
                }
                catch (InvocationTargetException exception) {
                    exc[0] = exception;
                }
                catch (InterruptedException exception) {
                    exc[0] = exception;
                }
            }
        };
        this.runInUIThread(uiRunnable);
        if (exc[0] instanceof InvocationTargetException) {
            throw (InvocationTargetException)exc[0];
        }
        if (exc[0] instanceof InterruptedException) {
            throw (InterruptedException)exc[0];
        }
    }

    public void cheatSheetEvent(ICheatSheetEvent event) {
        cheatSheetManager = event.getCheatSheetManager();
        if (cheatSheetManager.getData("startingPageName") == null) {
            cheatSheetManager.setData("startingPageName", "none");
        }
    }

    private void runInUIThread(Runnable runnable) {
        this.display.syncExec(runnable);
    }

    private class Runner
    implements Runnable {
        AuthTokenRequest request;
        IAuthenticationToken token;
        ProblemException exc;
        private CoreAuthTokenProvider cProvider;

        public Runner(AuthTokenRequest request, CoreAuthTokenProvider cProvider) {
            this.request = request;
            this.cProvider = cProvider;
        }

        public void run() {
            boolean result;
            String message;
            String title = this.request.getRequester();
            if (title == null) {
                title = Messages.getString("UIAuthTokenProvider.req_token_title");
            }
            if ((message = this.request.getPurpose()) == null) {
                message = Messages.getString("UIAuthTokenProvider.new_token_question");
            }
            if (result = MessageDialog.openQuestion((Shell)UIAuthTokenProvider.this.shell, (String)title, (String)message)) {
                IAuthenticationTokenDescription description = this.request.getDescription();
                String tokenWizardId = description.getWizardId();
                if (UIAuthTokenProvider.this.showNewTokenWizard(tokenWizardId, false, description)) {
                    this.token = this.cProvider.requestToken(this.request);
                } else {
                    this.exc = new ProblemException("eu.geclipse.core.problem.auth.tokenRequestCanceled", "eu.geclipse.ui");
                }
            } else {
                this.exc = new ProblemException("eu.geclipse.core.problem.auth.tokenRequestCanceled", "eu.geclipse.ui");
            }
        }
    }
}

