/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.actions;

import eu.geclipse.core.auth.AbstractAuthTokenProvider;
import eu.geclipse.core.filesystem.GEclipseFileSystem;
import eu.geclipse.core.filesystem.GEclipseURI;
import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridConnection;
import eu.geclipse.core.model.IGridConnectionElement;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridPreferences;
import eu.geclipse.core.model.IGridProject;
import eu.geclipse.core.model.IMountable;
import eu.geclipse.core.model.IVirtualOrganization;
import eu.geclipse.core.reporting.IProblem;
import eu.geclipse.core.reporting.ISolution;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.dialogs.ProblemDialog;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.internal.actions.Messages;
import eu.geclipse.ui.problems.RemountSolution;
import eu.geclipse.ui.wizards.ConnectionWizard;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;

public class MountAction
extends Action {
    private IMountable[] mountables;
    private IMountable.MountPointID mountID;
    private Shell shell;
    private boolean mountAs;

    public MountAction(Shell shell, IMountable[] mountables, IMountable.MountPointID mountID, boolean mountAs) {
        super(mountID.getUID());
        this.shell = shell;
        this.mountables = mountables;
        this.mountID = mountID;
        this.mountAs = mountAs;
    }

    public void run() {
        Job mountJob = new Job(Messages.getString("MountAction.mount_job_name")){

            protected IStatus run(IProgressMonitor monitor) {
                return MountAction.this.mountOperation(monitor);
            }
        };
        mountJob.setUser(true);
        mountJob.schedule();
    }

    protected IStatus mountOperation(IProgressMonitor monitor) {
        SubMonitor sMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.getString("MountAction.monitor_title"), (int)this.mountables.length);
        IMountable[] iMountableArray = this.mountables;
        int n = this.mountables.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                IMountable mountable = iMountableArray[n2];
                try {
                    if (sMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    sMonitor.subTask(String.valueOf(Messages.getString("MountAction.monitor_subtask_mounting")) + mountable.getName());
                    this.createMount(mountable, (IProgressMonitor)sMonitor.newChild(1));
                }
                catch (CoreException cExc) {
                    if (AbstractAuthTokenProvider.isTokenRequestCanceledException((Throwable)cExc)) break block4;
                    ProblemDialog.openProblem(this.shell, String.format(Messages.getString("MountAction.problem_dialog_title"), new Object[0]), String.format(Messages.getString("MountAction.failed_mount_info"), mountable.getName()), cExc);
                }
            }
            ++n2;
        }
        sMonitor.done();
        IStatus result = Status.OK_STATUS;
        return result;
    }

    protected void createMount(IMountable mountable, IProgressMonitor monitor) throws CoreException {
        IMountable.MountPoint mountPoint;
        boolean global = false;
        if (mountable instanceof IGridConnectionElement) {
            IGridConnectionElement root = (IGridConnectionElement)mountable;
            while (!(root instanceof IGridConnection) && root != null) {
                root = root.getParent();
            }
            if (root != null && root instanceof IGridConnection) {
                global = ((IGridConnection)root).isGlobal();
            }
        }
        if ((mountPoint = mountable.getMountPoint(this.mountID)) != null) {
            String mountName = mountPoint.getName();
            URI uri = mountPoint.getURI();
            if (this.mountAs) {
                ConnectionWizard wizard = new ConnectionWizard(uri, mountName, global);
                if (!global) {
                    IGridProject project = mountable.getProject();
                    IGridContainer mountFolder = project.getProjectFolder(IGridConnection.class);
                    wizard.init(null, (IStructuredSelection)new StructuredSelection((Object)mountFolder.getResource()));
                }
                final WizardDialog dialog = new WizardDialog(this.shell, (IWizard)wizard);
                this.shell.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        dialog.open();
                    }
                });
            } else if (global) {
                MountAction.createGlobalMount(uri, mountName, monitor);
            } else {
                IGridProject project = mountable.getProject();
                IGridContainer mountFolder = project.getProjectFolder(IGridConnection.class);
                IPath path = mountFolder.getPath().append(mountName);
                if (!this.checkExists(mountable, path)) {
                    MountAction.createLocalMount(uri, path, monitor);
                }
            }
        }
    }

    public static void createGlobalMount(URI uri, String name, IProgressMonitor monitor) throws CoreException {
        SubMonitor sMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            sMonitor.subTask(String.format(Messages.getString("MountAction.monitor_subtask_preparing_resources"), name));
            GEclipseURI geclURI = new GEclipseURI(uri);
            MountAction.isDirectory(geclURI);
            sMonitor.worked(4);
            if (sMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            sMonitor.subTask(Messages.getString("MountAction.monitor_subtask_creating_connection"));
            IGridPreferences preferences = GridModel.getPreferences();
            preferences.createGlobalConnection(name, geclURI.toMasterURI(), (IProgressMonitor)sMonitor.newChild(6));
        }
        finally {
            sMonitor.done();
        }
    }

    public static void createLocalMount(URI uri, IPath path, IProgressMonitor monitor) throws CoreException {
        SubMonitor sMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            sMonitor.subTask(String.format(Messages.getString("MountAction.monitor_subtask_preparing_resources"), path.toString()));
            String projectName = path.segment(0);
            IGridProject project = (IGridProject)GridModel.getRoot().findChild(projectName);
            IVirtualOrganization vo = project.getVO();
            String voName = vo != null ? vo.getName() : null;
            URI newUri = MountAction.processURI(voName, uri);
            GEclipseURI geclURI = new GEclipseURI(newUri);
            boolean isDirectory = MountAction.isDirectory(geclURI);
            sMonitor.worked(4);
            if (sMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            sMonitor.subTask(Messages.getString("MountAction.monitor_subtask_creating_connection"));
            if (isDirectory) {
                IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
                folder.createLink(geclURI.toMasterURI(), 16, (IProgressMonitor)sMonitor.newChild(6));
            } else {
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                file.createLink(geclURI.toMasterURI(), 16, (IProgressMonitor)sMonitor.newChild(6));
            }
        }
        finally {
            sMonitor.done();
        }
    }

    private static URI processURI(String voName, URI uri) {
        URI result = uri;
        if (voName != null && uri != null && !uri.getScheme().equals("file")) {
            try {
                String schemeSpecificPart = uri.getSchemeSpecificPart();
                schemeSpecificPart = schemeSpecificPart.contains("?") ? String.valueOf(schemeSpecificPart) + "&vo=" + voName : String.valueOf(schemeSpecificPart) + "?vo=" + voName;
                result = new URI(uri.getScheme(), schemeSpecificPart, uri.getFragment());
            }
            catch (URISyntaxException e) {
                Activator.logException(e);
            }
        }
        return result;
    }

    private boolean checkExists(IMountable mountable, IPath target) {
        boolean result;
        boolean bl = result = ResourcesPlugin.getWorkspace().getRoot().getFile(target).exists() || ResourcesPlugin.getWorkspace().getRoot().getFolder(target).exists();
        if (result) {
            ProblemException problemExc = new ProblemException("eu.geclipse.ui.problem.mountAlreadyExists", "eu.geclipse.ui");
            IProblem problem = problemExc.getProblem();
            if (this.mountID != null) {
                problem.addSolution((ISolution)new RemountSolution(mountable, this.mountID));
            }
            ProblemDialog.openProblem(this.shell, Messages.getString("MountAction.resource_exists_problem"), String.format(Messages.getString("MountAction.resource_exists_info"), target.toString()), (Throwable)problemExc);
        }
        return result;
    }

    private static boolean isDirectory(GEclipseURI uri) throws CoreException, ProblemException {
        URI masterURI = uri.toMasterURI();
        IFileStore fileStore = EFS.getStore((URI)masterURI);
        GEclipseFileSystem.assureFileStoreIsActive((IFileStore)fileStore);
        IFileInfo fileInfo = null;
        try {
            fileInfo = fileStore.fetchInfo(0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreExc) {
            throw new ProblemException("eu.geclipse.core.filesystem.serverCouldNotBeContacted", String.format(Messages.getString("MountAction.cannot_fetch_info_error"), uri.toSlaveURI()), (Throwable)coreExc, "eu.geclipse.ui");
        }
        if (fileInfo == null || !fileInfo.exists()) {
            throw new ProblemException("eu.geclipse.core.filesystem.serverCouldNotBeContacted", String.format(Messages.getString("MountAction.server_not_responding_info"), uri.toSlaveURI()), "eu.geclipse.ui");
        }
        return fileInfo.isDirectory();
    }
}

