/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.dialogs;

import eu.geclipse.core.accesscontrol.ActorType;
import eu.geclipse.core.accesscontrol.IACLActor;
import eu.geclipse.core.accesscontrol.IACLCapability;
import eu.geclipse.core.accesscontrol.IACLEntry;
import eu.geclipse.core.accesscontrol.IACLPolicy;
import eu.geclipse.ui.dialogs.Messages;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.widgets.StoredCombo;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AccessControlRuleDialog
extends Dialog {
    boolean withSaveButton;
    Combo actorTypeCombo;
    private Group entryGroup;
    private Combo policyCombo;
    private Combo capCombo;
    private CertificateComposite actorDNCertComposite;
    private CertificateComposite actorCACertComposite;
    private FieldComposite groupNameComposite;
    private FieldComposite userNameComposite;
    private FieldComposite userEmailComposite;
    private SAMLComposite samlComposite;
    private IACLEntry entry;
    private ActorType type;

    protected AccessControlRuleDialog(IACLEntry entry, boolean withSaveButton, Shell parentShell) {
        super(parentShell);
        this.setShellStyle(68848);
        this.withSaveButton = withSaveButton;
        this.entry = entry;
        this.type = this.entry.getActor().getActorType();
    }

    public Control createDialogArea(Composite parent) {
        ActorType aType;
        ActorType[] aTypes;
        IACLCapability capability;
        IACLCapability[] capabilities;
        IACLPolicy policy;
        IACLPolicy[] policies;
        Composite mainComp = new Composite(parent, 0);
        mainComp.setLayout((Layout)new GridLayout(1, false));
        GridData gData = new GridData(4, 4, true, true);
        gData.grabExcessHorizontalSpace = true;
        gData.grabExcessVerticalSpace = true;
        mainComp.setLayoutData((Object)gData);
        this.entryGroup = new Group(mainComp, 0);
        this.entryGroup.setLayout((Layout)new GridLayout(2, false));
        this.entryGroup.setText(Messages.getString("AccessControlRuleDialog.group_title"));
        gData = new GridData(4, 4, true, true);
        gData.heightHint = 260;
        gData.widthHint = 500;
        this.entryGroup.setLayoutData((Object)gData);
        this.createDialogWidgets((Composite)this.entryGroup);
        ArrayList<String> policyNames = new ArrayList<String>(5);
        IACLPolicy[] iACLPolicyArray = policies = this.entry.getSupportedPolicies();
        int n = policies.length;
        int n2 = 0;
        while (n2 < n) {
            policy = iACLPolicyArray[n2];
            String name = policy.toString();
            policyNames.add(name != null ? name : "");
            ++n2;
        }
        this.policyCombo.setItems(policyNames.toArray(new String[policyNames.size()]));
        policy = this.entry.getPolicy();
        if (policy != null) {
            this.policyCombo.select(this.policyCombo.indexOf(policy.toString()));
        }
        ArrayList<String> capNames = new ArrayList<String>(5);
        IACLCapability[] iACLCapabilityArray = capabilities = this.entry.getSupportedCapabilities();
        int n3 = capabilities.length;
        int name = 0;
        while (name < n3) {
            capability = iACLCapabilityArray[name];
            String name2 = capability.getName();
            capNames.add(name2 != null ? name2 : "");
            ++name;
        }
        this.capCombo.setItems(capNames.toArray(new String[capNames.size()]));
        capability = this.entry.getCapability();
        if (capability != null) {
            this.capCombo.select(this.capCombo.indexOf(capability.getName()));
        }
        ArrayList<String> aTypeNames = new ArrayList<String>(5);
        IACLActor actor = this.entry.getActor();
        assert (actor != null) : "Null actor in ACL entry: implementation BUG.";
        ActorType[] actorTypeArray = aTypes = actor.getSupportedTypes();
        int n4 = aTypes.length;
        int n5 = 0;
        while (n5 < n4) {
            aType = actorTypeArray[n5];
            String name3 = aType.getName();
            aTypeNames.add(name3 != null ? name3 : "");
            ++n5;
        }
        this.actorTypeCombo.setItems(aTypeNames.toArray(new String[aTypeNames.size()]));
        aType = actor.getActorType();
        int index = this.actorTypeCombo.indexOf(aType.getName());
        this.actorTypeCombo.select(index);
        this.updateDialogContents(aType);
        return mainComp;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("AccessControlRuleDialog.dialog_title"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        String buttonText = null;
        buttonText = this.withSaveButton ? Messages.getString("AccessControlRuleDialog.save_button_text") : IDialogConstants.OK_LABEL;
        Button button = this.createButton(parent, 0, buttonText, true);
        button.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private void createDialogWidgets(Composite group) {
        Label policyLabel = new Label(group, 16384);
        GridData gData = new GridData(16384, 0x1000000, false, false);
        policyLabel.setLayoutData((Object)gData);
        policyLabel.setText(Messages.getString("AccessControlRuleDialog.policy_label"));
        this.policyCombo = new Combo(group, 16396);
        gData = new GridData(4, 0x1000000, true, false);
        this.policyCombo.setLayoutData((Object)gData);
        Label capLabel = new Label(group, 16384);
        gData = new GridData(16384, 0x1000000, false, false);
        capLabel.setLayoutData((Object)gData);
        capLabel.setText(Messages.getString("AccessControlRuleDialog.capability_label"));
        this.capCombo = new Combo(group, 16396);
        gData = new GridData(4, 0x1000000, true, false);
        this.capCombo.setLayoutData((Object)gData);
        Label actorTypeLabel = new Label(group, 16384);
        gData = new GridData(16384, 0x1000000, false, false);
        actorTypeLabel.setLayoutData((Object)gData);
        actorTypeLabel.setText(Messages.getString("AccessControlRuleDialog.actor_type_label"));
        this.actorTypeCombo = new Combo(group, 16396);
        gData = new GridData(4, 0x1000000, true, false);
        this.actorTypeCombo.setLayoutData((Object)gData);
        this.actorTypeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ActorType aType = AccessControlRuleDialog.this.getSelectedActorType(AccessControlRuleDialog.this.actorTypeCombo.getText());
                AccessControlRuleDialog.this.updateDialogContents(aType);
            }
        });
        this.actorDNCertComposite = new CertificateComposite((Composite)this.entryGroup, Messages.getString("AccessControlRuleDialog.actor_DN_label"));
        gData = new GridData(4, 0x1000000, true, false);
        gData.horizontalSpan = 2;
        this.actorDNCertComposite.setLayoutData(gData);
        this.setVisibility((Control)this.actorDNCertComposite, false);
        this.actorCACertComposite = new CertificateComposite((Composite)this.entryGroup, Messages.getString("AccessControlRuleDialog.signing_CA_label"));
        gData = new GridData(4, 0x1000000, true, false);
        gData.horizontalSpan = 2;
        this.actorCACertComposite.setLayoutData(gData);
        this.setVisibility((Control)this.actorCACertComposite, false);
        this.groupNameComposite = new FieldComposite((Composite)this.entryGroup, Messages.getString("AccessControlRuleDialog.group_name_label"));
        gData = new GridData(4, 0x1000000, true, false);
        gData.horizontalSpan = 2;
        this.groupNameComposite.setLayoutData(gData);
        this.setVisibility((Control)this.groupNameComposite, false);
        this.userNameComposite = new FieldComposite((Composite)this.entryGroup, Messages.getString("AccessControlRuleDialog.user_name_label"));
        gData = new GridData(4, 0x1000000, true, false);
        gData.horizontalSpan = 2;
        this.userNameComposite.setLayoutData(gData);
        this.setVisibility((Control)this.userNameComposite, false);
        this.userEmailComposite = new FieldComposite((Composite)this.entryGroup, Messages.getString("AccessControlRuleDialog.user_email_label"));
        gData = new GridData(4, 0x1000000, true, false);
        gData.horizontalSpan = 2;
        this.userEmailComposite.setLayoutData(gData);
        this.setVisibility((Control)this.userEmailComposite, false);
        this.samlComposite = new SAMLComposite((Composite)this.entryGroup);
        gData = new GridData(4, 0x1000000, true, false);
        gData.horizontalSpan = 2;
        gData.exclude = true;
        this.samlComposite.setLayoutData(gData);
        this.setVisibility((Control)this.samlComposite, false);
    }

    void updateDialogContents(ActorType newType) {
        String actorID = this.entry.getActor().getID();
        this.actorDNCertComposite.setDN(actorID != null ? actorID : "");
        String actorCA = this.entry.getActor().getCA();
        this.actorCACertComposite.setDN(actorCA != null ? actorCA : "");
        if (!this.type.equals((Object)ActorType.ANYBODY) && !this.type.equals((Object)ActorType.CA_ANY_DN_ANY)) {
            if (this.type.equals((Object)ActorType.CA_NAME_DN_ANY)) {
                this.setVisibility((Control)this.actorCACertComposite, false);
            } else if (!this.type.equals((Object)ActorType.CA_NAME_DN_PATTERN)) {
                if (this.type.equals((Object)ActorType.CA_NAME_DN_NAME)) {
                    this.setVisibility((Control)this.actorDNCertComposite, false);
                    this.setVisibility((Control)this.actorCACertComposite, false);
                } else if (!this.type.equals((Object)ActorType.GROUP_PATTERN)) {
                    if (this.type.equals((Object)ActorType.GROUP_NAME)) {
                        this.setVisibility((Control)this.groupNameComposite, false);
                    } else if (!this.type.equals((Object)ActorType.USER_PATTERN)) {
                        if (this.type.equals((Object)ActorType.USER_NAME)) {
                            this.setVisibility((Control)this.userNameComposite, false);
                        } else if (this.type.equals((Object)ActorType.USER_EMAIL)) {
                            this.setVisibility((Control)this.userEmailComposite, false);
                        } else if (this.type.equals((Object)ActorType.SAML_ATTRIBUTE)) {
                            this.setVisibility((Control)this.samlComposite, false);
                        }
                    }
                }
            }
        }
        if (!newType.equals((Object)ActorType.ANYBODY) && !newType.equals((Object)ActorType.CA_ANY_DN_ANY)) {
            if (newType.equals((Object)ActorType.CA_NAME_DN_ANY)) {
                this.setVisibility((Control)this.actorCACertComposite, true);
            } else if (!newType.equals((Object)ActorType.CA_NAME_DN_PATTERN)) {
                if (newType.equals((Object)ActorType.CA_NAME_DN_NAME)) {
                    this.setVisibility((Control)this.actorDNCertComposite, true);
                    this.setVisibility((Control)this.actorCACertComposite, true);
                } else if (!newType.equals((Object)ActorType.GROUP_PATTERN)) {
                    if (newType.equals((Object)ActorType.GROUP_NAME)) {
                        this.setVisibility((Control)this.groupNameComposite, true);
                    } else if (!newType.equals((Object)ActorType.USER_PATTERN)) {
                        if (newType.equals((Object)ActorType.USER_NAME)) {
                            this.setVisibility((Control)this.userNameComposite, true);
                        } else if (newType.equals((Object)ActorType.USER_EMAIL)) {
                            this.setVisibility((Control)this.userEmailComposite, true);
                        } else if (newType.equals((Object)ActorType.SAML_ATTRIBUTE)) {
                            this.setVisibility((Control)this.samlComposite, true);
                        }
                    }
                }
            }
        }
        this.type = newType;
        this.entryGroup.layout();
    }

    private void setVisibility(Control control, boolean visible) {
        control.setVisible(visible);
        ((GridData)control.getLayoutData()).exclude = !visible;
    }

    ActorType getSelectedActorType(String selectedItem) {
        ActorType[] aTypes;
        ActorType result = null;
        IACLActor actor = this.entry.getActor();
        ActorType[] actorTypeArray = aTypes = actor.getSupportedTypes();
        int n = aTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ActorType aType = actorTypeArray[n2];
            String name = aType.getName();
            if (name.equals(selectedItem)) {
                result = aType;
                break;
            }
            ++n2;
        }
        return result;
    }

    protected String showFileDialog(String path, String title) {
        String[] filterExtensions = new String[]{"*.pem", "*.p12", "*;*.*"};
        String[] filterNames = new String[]{"Base64 encoded certificate", "PKCS#12 encoded certificate", "All Files"};
        FileDialog fileDialog = new FileDialog(this.getShell(), 4100);
        fileDialog.setFilterExtensions(filterExtensions);
        fileDialog.setFilterNames(filterNames);
        fileDialog.setFileName(path);
        fileDialog.setText(title);
        String selected = fileDialog.open();
        return selected;
    }

    class CertFileSelectionAdapter
    extends SelectionAdapter {
        private Combo widget;

        public CertFileSelectionAdapter(Combo widget) {
            this.widget = widget;
        }

        public void widgetSelected(SelectionEvent e) {
            String filename = this.widget.getText();
            if ((filename = AccessControlRuleDialog.this.showFileDialog(filename, Messages.getString("AccessControlRuleDialog.file_dialog_title"))) != null) {
                this.widget.setText(filename);
            }
        }
    }

    class CertificateComposite
    extends Composite {
        private Text dnText;
        private StoredCombo certFileCombo;

        CertificateComposite(Composite parent, String label) {
            super(parent, 0);
            this.setLayout((Layout)new GridLayout(2, false));
            URL openFileIcon = Activator.getDefault().getBundle().getEntry("icons/obj16/open_file.gif");
            Image openFileImage = ImageDescriptor.createFromURL((URL)openFileIcon).createImage();
            Label dnLabel = new Label((Composite)this, 16384);
            GridData gData = new GridData(16384, 0x1000000, false, false);
            dnLabel.setLayoutData((Object)gData);
            dnLabel.setText(label);
            this.dnText = new Text((Composite)this, 16392);
            gData = new GridData(4, 0x1000000, true, false);
            this.dnText.setLayoutData((Object)gData);
            Label certFileLabel = new Label((Composite)this, 131072);
            gData = new GridData(4, 0x1000000, false, false);
            certFileLabel.setLayoutData((Object)gData);
            certFileLabel.setText(Messages.getString("AccessControlRuleDialog.dn_file_label"));
            Composite dnComp = new Composite((Composite)this, 0);
            dnComp.setLayout((Layout)new GridLayout(2, false));
            gData = new GridData(4, 4, true, false);
            dnComp.setLayoutData((Object)gData);
            this.certFileCombo = new StoredCombo(dnComp, 16388);
            gData = new GridData(4, 0x1000000, true, false);
            this.certFileCombo.setLayoutData(gData);
            Button dnFileButton = new Button(dnComp, 8);
            dnFileButton.setImage(openFileImage);
            gData = new GridData();
            dnFileButton.setLayoutData((Object)gData);
            dnFileButton.setToolTipText(Messages.getString("AccessControlRuleDialog.dn_file_button_tooltip"));
            dnFileButton.addSelectionListener((SelectionListener)new CertFileSelectionAdapter(this.certFileCombo));
        }

        void setDN(String text) {
            this.dnText.setText(text);
        }

        String getCertificateFile() {
            return this.certFileCombo.getText();
        }
    }

    class FieldComposite
    extends Composite {
        private StoredCombo combo;

        FieldComposite(Composite parent, String label) {
            super(parent, 0);
            this.setLayout((Layout)new GridLayout(2, false));
            Label dnLabel = new Label((Composite)this, 16384);
            GridData gData = new GridData(16384, 0x1000000, false, false);
            dnLabel.setLayoutData((Object)gData);
            dnLabel.setText(label);
            this.combo = new StoredCombo(this, 16388);
            gData = new GridData(4, 0x1000000, true, false);
            this.combo.setLayoutData(gData);
        }

        void setText(String text) {
            this.combo.setText(text);
        }

        String getText() {
            return this.combo.getText();
        }
    }

    class SAMLComposite
    extends Composite {
        private FieldComposite samlAttr;
        private FieldComposite samlValue;

        SAMLComposite(Composite parent) {
            super(parent, 0);
            this.setLayout((Layout)new GridLayout(1, false));
            this.samlAttr = new FieldComposite(this, Messages.getString("AccessControlRuleDialog.SAML_attribute_label"));
            GridData gData = new GridData(4, 0x1000000, true, false);
            this.samlAttr.setLayoutData(gData);
            this.samlValue = new FieldComposite(this, Messages.getString("AccessControlRuleDialog.SAML_value_label"));
            gData = new GridData(4, 0x1000000, true, false);
            this.samlValue.setLayoutData(gData);
        }

        void setAttribute(String attr) {
            this.samlAttr.setText(attr);
        }

        void setValue(String value) {
            this.samlValue.setText(value);
        }

        String getAttribute() {
            return this.samlAttr.getText();
        }

        String getValue() {
            return this.samlValue.getText();
        }
    }
}

