/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.dialogs;

import eu.geclipse.core.auth.IAuthenticationToken;
import eu.geclipse.ui.dialogs.Messages;
import eu.geclipse.ui.internal.Activator;
import java.util.Date;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AuthTokenInfoDialog
extends IconAndMessageDialog {
    private IAuthenticationToken token;

    public AuthTokenInfoDialog(IAuthenticationToken token, Shell parentShell) {
        super(parentShell);
        this.setShellStyle(68848);
        this.token = token;
    }

    protected IAuthenticationToken getToken() {
        return this.token;
    }

    protected Control createDialogArea(Composite parent) {
        this.createMessageArea(parent);
        Composite mainComp = new Composite(parent, 0);
        mainComp.setLayout((Layout)new GridLayout(2, false));
        GridData gData = new GridData(1808);
        gData.grabExcessHorizontalSpace = true;
        gData.grabExcessVerticalSpace = true;
        gData.widthHint = 600;
        gData.heightHint = 400;
        mainComp.setLayoutData((Object)gData);
        Label idLabel = new Label(mainComp, 16384);
        idLabel.setText(Messages.getString("AuthTokenInfoDialog.token_id_label"));
        gData = new GridData();
        gData.horizontalAlignment = 1;
        idLabel.setLayoutData((Object)gData);
        Text idText = new Text(mainComp, 18432);
        idText.setText(this.token.getID());
        gData = new GridData(768);
        gData.grabExcessHorizontalSpace = true;
        idText.setLayoutData((Object)gData);
        idText.setEditable(false);
        Label typeLabel = new Label(mainComp, 16384);
        typeLabel.setText(Messages.getString("AuthTokenInfoDialog.token_type_label"));
        gData = new GridData();
        gData.horizontalAlignment = 1;
        typeLabel.setLayoutData((Object)gData);
        Text typeText = new Text(mainComp, 18432);
        typeText.setText(this.token.getDescription().getTokenTypeName());
        gData = new GridData(768);
        gData.grabExcessHorizontalSpace = true;
        typeText.setLayoutData((Object)gData);
        typeText.setEditable(false);
        Label stateLabel = new Label(mainComp, 16384);
        stateLabel.setText(Messages.getString("AuthTokenInfoDialog.token_state_label"));
        gData = new GridData();
        gData.horizontalAlignment = 1;
        stateLabel.setLayoutData((Object)gData);
        String state = this.token.isActive() ? Messages.getString("AuthTokenInfoDialog.state_active") : Messages.getString("AuthTokenInfoDialog.state_inactive");
        Text stateText = new Text(mainComp, 18432);
        stateText.setText(state);
        gData = new GridData(768);
        gData.grabExcessHorizontalSpace = true;
        stateText.setLayoutData((Object)gData);
        stateText.setEditable(false);
        Label expLabel = new Label(mainComp, 16384);
        expLabel.setText(Messages.getString("AuthTokenInfoDialog.exp_date_label"));
        gData = new GridData();
        gData.horizontalAlignment = 1;
        expLabel.setLayoutData((Object)gData);
        Text expText = new Text(mainComp, 18432);
        gData = new GridData(768);
        gData.grabExcessHorizontalSpace = true;
        expText.setLayoutData((Object)gData);
        expText.setEditable(false);
        if (!this.token.isActive()) {
            expText.setText(Messages.getString("AuthTokenInfoDialog.token_not_active_message"));
        } else {
            long lifetime = this.token.getTimeLeft();
            if (lifetime < 0L) {
                expText.setText(Messages.getString("AuthTokenInfoDialog.infinite_lifetime_message"));
            } else if (lifetime == 0L) {
                expText.setText(Messages.getString("AuthTokenInfoDialog.token_expired_message"));
            } else {
                Date expDate = new Date();
                expDate.setTime(expDate.getTime() + lifetime * 1000L);
                StringBuilder bf = new StringBuilder(expDate.toString());
                int days = (int)(lifetime / 86400L);
                int hours = (int)(lifetime % 86400L / 3600L);
                int minutes = (int)(lifetime % 3600L / 60L);
                int seconds = (int)(lifetime % 60L);
                String ltString = String.format(" (%1$dd %2$2dh %3$2dm %4$2ds)", days, hours, minutes, seconds);
                expText.setText(String.valueOf(bf.toString()) + ltString);
            }
        }
        Control infoArea = this.createInfoArea(mainComp);
        gData = new GridData(1808);
        gData.horizontalSpan = 2;
        gData.grabExcessHorizontalSpace = true;
        gData.grabExcessVerticalSpace = true;
        infoArea.setLayoutData((Object)gData);
        return mainComp;
    }

    protected Image getImage() {
        return this.getInfoImage();
    }

    protected Control createInfoArea(Composite parent) {
        Composite mainComp = new Composite(parent, 2048);
        mainComp.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(mainComp, 0);
        label.setText(Messages.getString("AuthTokenInfoDialog.no_info_label"));
        GridData gData = new GridData();
        label.setLayoutData((Object)gData);
        return mainComp;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return Activator.getDefault().getDialogSettings();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        String tokenType = this.token.getDescription().getTokenTypeName();
        shell.setText(String.valueOf(tokenType) + " " + Messages.getString("AuthTokenInfoDialog.info_suffix"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, "Close", false);
    }
}

