/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.dialogs;

import eu.geclipse.core.filesystem.GEclipseURI;
import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridConnectionElement;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridModelEvent;
import eu.geclipse.core.model.IGridModelListener;
import eu.geclipse.ui.comparators.TreeColumnComparator;
import eu.geclipse.ui.dialogs.Messages;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.listeners.TreeColumnListener;
import eu.geclipse.ui.providers.DecoratingGridModelLabelProvider;
import eu.geclipse.ui.providers.GridFileDialogContentProvider;
import eu.geclipse.ui.providers.NewGridModelLabelProvider;
import eu.geclipse.ui.providers.ProgressTreeNode;
import eu.geclipse.ui.widgets.StoredCombo;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.PlatformUI;

public class GridFileDialog
extends TitleAreaDialog {
    public static final int STYLE_NONE = 0;
    public static final int STYLE_ALLOW_ONLY_LOCAL = 1;
    public static final int STYLE_ALLOW_ONLY_CONNECTIONS = 2;
    public static final int STYLE_ALLOW_ONLY_REMOTE_CONNECTIONS = 4;
    public static final int STYLE_ALLOW_ONLY_FILES = 8;
    public static final int STYLE_ALLOW_ONLY_FOLDERS = 16;
    public static final int STYLE_ALLOW_ONLY_EXISTING = 32;
    public static final int STYLE_MULTI_SELECTION = 64;
    private static final String EMPTY_STRING = "";
    private static final String PATH_SEPARATOR = "/";
    private static final String HOME_PROPERTY = "user.home";
    private static final String ROOT_FOLDER = "/";
    private static final Pattern POSIX_FILENAME = Pattern.compile("^[\\w\\.][\\w\\.-]*");
    protected TreeViewer treeViewer;
    protected Combo filetypeCombo;
    protected StoredCombo uriCombo;
    protected Hashtable<String, FileTypeFilter> filetypeFilters = new Hashtable();
    private StoredCombo filenameCombo;
    private ModeManager modeManager;
    private IGridModelListener modelListener;
    private ModifyListener uriListener;
    private VerifyListener filenameListener;
    private ISelectionChangedListener selectionListener;
    private int style;
    private IFileStore[] currentSelection;

    public GridFileDialog(Shell parent, int style) {
        super(parent);
        this.style = style;
        this.assertStyle();
        this.setShellStyle(67696);
        URL imgURL = Activator.getDefault().getBundle().getResource("icons/wizban/newconn_wiz.gif");
        ImageDescriptor imgDesc = ImageDescriptor.createFromURL((URL)imgURL);
        this.setTitleImage(imgDesc.createImage());
    }

    public static URI[] openFileDialog(Shell parent, int style) {
        URI[] result = null;
        GridFileDialog dialog = new GridFileDialog(parent, style);
        if (dialog.open() == 0) {
            result = dialog.getSelectedURIs();
        }
        return result;
    }

    public void addFileTypeFilter(String prefix, String description) {
        FileTypeFilter filter = new FileTypeFilter(prefix);
        this.addFileTypeFilter(filter, description);
    }

    public boolean close() {
        if (this.modelListener != null) {
            GridModel.getRoot().removeGridModelListener(this.modelListener);
        }
        return super.close();
    }

    public IFileStore[] getSelectedFileStores() {
        IFileStore[] result = null;
        if (this.currentSelection != null && this.currentSelection.length > 0) {
            result = new IFileStore[this.currentSelection.length];
            System.arraycopy(this.currentSelection, 0, result, 0, result.length);
        }
        return result;
    }

    public URI[] getSelectedURIs() {
        URI[] result = null;
        IFileStore[] stores = this.getSelectedFileStores();
        if (stores != null && stores.length > 0) {
            result = new URI[stores.length];
            int i = 0;
            while (i < stores.length) {
                URI uri = stores[i].toURI();
                GEclipseURI gUri = new GEclipseURI(uri);
                result[i] = gUri.toSlaveURI();
                ++i;
            }
        }
        return result;
    }

    protected void configureViewerFilters() {
        if (this.treeViewer != null) {
            this.treeViewer.resetFilters();
            if (this.hasStyle(16)) {
                this.treeViewer.addFilter((ViewerFilter)new FolderFilter());
            }
            if (this.hasStyle(4)) {
                this.treeViewer.addFilter((ViewerFilter)new RemoteConnectionFilter());
            }
            if (this.filetypeCombo != null) {
                String key;
                FileTypeFilter filter;
                if (this.filetypeCombo.getItemCount() != this.filetypeFilters.size()) {
                    this.initializeFileTypeCombo();
                }
                if ((filter = this.filetypeFilters.get(key = this.filetypeCombo.getText())) != null) {
                    this.treeViewer.addFilter((ViewerFilter)filter);
                }
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.modeManager = new ModeManager();
        this.modeManager.addModeChangeListener(new IModeChangeListener(){

            public void modeChanged(int mode) {
                GridFileDialog.this.setMode(mode);
            }
        });
        Label topRule = new Label(parent, 258);
        topRule.setLayoutData((Object)new GridData(768));
        Composite mainComp = new Composite(parent, 0);
        mainComp.setLayout((Layout)new GridLayout(2, false));
        GridData gData = new GridData(1808);
        gData.grabExcessHorizontalSpace = true;
        gData.grabExcessVerticalSpace = true;
        gData.widthHint = 500;
        gData.heightHint = 400;
        mainComp.setLayoutData((Object)gData);
        Label bottomRule = new Label(parent, 258);
        bottomRule.setLayoutData((Object)new GridData(768));
        if (!this.hasStyle(64)) {
            Composite uriComp = new Composite(mainComp, 0);
            uriComp.setLayout((Layout)new GridLayout(2, false));
            gData = new GridData(768);
            gData.grabExcessHorizontalSpace = true;
            gData.horizontalSpan = 2;
            uriComp.setLayoutData((Object)gData);
            Label uriLabel = new Label(uriComp, 0);
            uriLabel.setText(Messages.getString("GridFileDialog.label_URI"));
            gData = new GridData();
            uriLabel.setLayoutData((Object)gData);
            this.uriCombo = new StoredCombo(uriComp, 0);
            gData = new GridData(768);
            gData.grabExcessHorizontalSpace = true;
            this.uriCombo.setLayoutData(gData);
            this.uriCombo.setEnabled(!this.hasStyle(32));
        }
        if (!this.hasStyle(6)) {
            ToolBar modeBar = new ToolBar(mainComp, 2560);
            modeBar.setBackground(this.getShell().getDisplay().getSystemColor(1));
            gData = new GridData(1040);
            gData.grabExcessVerticalSpace = true;
            modeBar.setLayoutData((Object)gData);
            if (!this.hasStyle(1)) {
                URL connURL = Activator.getDefault().getBundle().getResource("icons/extras/grid_file_dialog_conn_mode.gif");
                ImageDescriptor connDesc = ImageDescriptor.createFromURL((URL)connURL);
                ToolItem connItem = new ToolItem(modeBar, 32);
                connItem.setImage(connDesc.createImage());
                connItem.setToolTipText(Messages.getString("GridFileDialog.switch_to_connections"));
                this.modeManager.addModeItem(connItem, 1);
            }
            if (!this.hasStyle(6)) {
                URL wsURL = Activator.getDefault().getBundle().getResource("icons/extras/grid_file_dialog_ws_mode.gif");
                ImageDescriptor wsDesc = ImageDescriptor.createFromURL((URL)wsURL);
                ToolItem wsItem = new ToolItem(modeBar, 32);
                wsItem.setImage(wsDesc.createImage());
                wsItem.setToolTipText(Messages.getString("GridFileDialog.switch_to_workspace"));
                this.modeManager.addModeItem(wsItem, 3);
                URL homeURL = Activator.getDefault().getBundle().getResource("icons/extras/grid_file_dialog_home_mode.gif");
                ImageDescriptor homeDesc = ImageDescriptor.createFromURL((URL)homeURL);
                ToolItem homeItem = new ToolItem(modeBar, 32);
                homeItem.setImage(homeDesc.createImage());
                homeItem.setToolTipText(Messages.getString("GridFileDialog.switch_to_home"));
                this.modeManager.addModeItem(homeItem, 2);
                URL rootURL = Activator.getDefault().getBundle().getResource("icons/extras/grid_file_dialog_root_mode.gif");
                ImageDescriptor rootDesc = ImageDescriptor.createFromURL((URL)rootURL);
                ToolItem rootItem = new ToolItem(modeBar, 32);
                rootItem.setImage(rootDesc.createImage());
                rootItem.setToolTipText(Messages.getString("GridFileDialog.switch_to_root"));
                this.modeManager.addModeItem(rootItem, 4);
            }
        }
        Composite browserComp = new Composite(mainComp, 0);
        GridLayout browserLayout = new GridLayout(1, false);
        browserLayout.marginWidth = 0;
        browserLayout.marginHeight = 0;
        browserComp.setLayout((Layout)browserLayout);
        gData = new GridData(1808);
        gData.grabExcessHorizontalSpace = true;
        gData.grabExcessVerticalSpace = true;
        browserComp.setLayoutData((Object)gData);
        int treeStyle = 2816;
        treeStyle = this.hasStyle(64) ? (treeStyle |= 2) : (treeStyle |= 4);
        this.treeViewer = new TreeViewer(browserComp, treeStyle);
        this.treeViewer.setContentProvider((IContentProvider)new GridFileDialogContentProvider());
        NewGridModelLabelProvider lProvider = new NewGridModelLabelProvider();
        lProvider.addColumn(0, "NAME");
        lProvider.addColumn(1, "SIZE");
        lProvider.addColumn(2, "MOD_DATE");
        ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        DecoratingGridModelLabelProvider dProvider = new DecoratingGridModelLabelProvider(lProvider, decorator);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)dProvider);
        Tree tree = this.treeViewer.getTree();
        tree.setHeaderVisible(true);
        gData = new GridData(1808);
        gData.grabExcessHorizontalSpace = true;
        gData.grabExcessVerticalSpace = true;
        tree.setLayoutData((Object)gData);
        TreeColumn nameColumn = new TreeColumn(tree, 0);
        nameColumn.setText(Messages.getString("GridFileDialog.column_title_name"));
        nameColumn.setAlignment(16384);
        nameColumn.setWidth(300);
        TreeColumn sizeColumn = new TreeColumn(tree, 0);
        sizeColumn.setText(Messages.getString("GridFileDialog.column_title_size"));
        sizeColumn.setAlignment(131072);
        sizeColumn.setWidth(100);
        TreeColumn modColumn = new TreeColumn(tree, 0);
        modColumn.setText(Messages.getString("GridFileDialog.column_title_last_modification"));
        modColumn.setAlignment(0x1000000);
        modColumn.setWidth(200);
        TreeColumnListener columnListener = new TreeColumnListener(this.treeViewer);
        TreeColumn[] treeColumnArray = tree.getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            column.addSelectionListener((SelectionListener)columnListener);
            ++n2;
        }
        tree.setSortColumn(nameColumn);
        tree.setSortDirection(128);
        this.treeViewer.setComparator((ViewerComparator)new TreeColumnComparator(nameColumn));
        Composite fileComp = new Composite(browserComp, 0);
        fileComp.setLayout((Layout)new GridLayout(2, false));
        gData = new GridData(768);
        gData.grabExcessHorizontalSpace = true;
        fileComp.setLayoutData((Object)gData);
        if (!this.hasStyle(64)) {
            Label filenameLabel = new Label(fileComp, 0);
            filenameLabel.setText(this.hasStyle(16) ? Messages.getString("GridFileDialog.label_foldername") : (this.hasStyle(8) ? Messages.getString("GridFileDialog.label_filename") : Messages.getString("GridFileDialog.label_name")));
            gData = new GridData();
            gData.horizontalAlignment = 1;
            filenameLabel.setLayoutData((Object)gData);
            this.filenameCombo = new StoredCombo(fileComp, 2048);
            gData = new GridData(768);
            gData.grabExcessHorizontalSpace = true;
            this.filenameCombo.setLayoutData(gData);
            this.filenameCombo.setEnabled(!this.hasStyle(32));
        }
        if (!this.hasStyle(16)) {
            Label filetypeLabel = new Label(fileComp, 0);
            filetypeLabel.setText(Messages.getString("GridFileDialog.label_filetype"));
            gData = new GridData();
            gData.horizontalAlignment = 1;
            filetypeLabel.setLayoutData((Object)gData);
            this.filetypeCombo = new Combo(fileComp, 2056);
            gData = new GridData(768);
            gData.grabExcessHorizontalSpace = true;
            this.filetypeCombo.setLayoutData((Object)gData);
        }
        int mode = !this.hasStyle(1) ? 1 : 3;
        this.modeManager.setMode(mode);
        this.setMode(mode);
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                GridFileDialog.this.handleDoubleClick();
            }
        });
        this.selectionListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                GridFileDialog.this.setNotificationEnabled(false);
                GridFileDialog.this.handleSelectionChanged();
                GridFileDialog.this.setNotificationEnabled(true);
            }
        };
        this.treeViewer.addSelectionChangedListener(this.selectionListener);
        if (this.uriCombo != null) {
            this.uriListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    GridFileDialog.this.setNotificationEnabled(false);
                    GridFileDialog.this.handleUriChanged();
                    GridFileDialog.this.setNotificationEnabled(true);
                }
            };
            this.uriCombo.addModifyListener(this.uriListener);
        }
        if (this.filenameCombo != null) {
            this.filenameListener = new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    GridFileDialog.this.setNotificationEnabled(false);
                    GridFileDialog.this.handleFilenameChanged(e);
                    GridFileDialog.this.setNotificationEnabled(true);
                }
            };
            this.filenameCombo.addVerifyListener(this.filenameListener);
        }
        if (this.filetypeCombo != null) {
            this.filetypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    GridFileDialog.this.configureViewerFilters();
                }
            });
        }
        this.modelListener = new IGridModelListener(){

            public void gridModelChanged(IGridModelEvent event) {
                if (event.getType() == 1 || event.getType() == 2) {
                    GridFileDialog.this.refreshViewer(event.getSource());
                }
            }
        };
        GridModel.getRoot().addGridModelListener(this.modelListener);
        Shell shell = this.getShell();
        if (this.hasStyle(8)) {
            if (this.hasStyle(64)) {
                shell.setText(Messages.getString("GridFileDialog.shell_title_files"));
            } else {
                shell.setText(Messages.getString("GridFileDialog.shell_title_file"));
            }
        } else if (this.hasStyle(16)) {
            if (this.hasStyle(64)) {
                shell.setText(Messages.getString("GridFileDialog.shell_title_folders"));
            } else {
                shell.setText(Messages.getString("GridFileDialog.shell_title_folder"));
            }
        } else if (this.hasStyle(64)) {
            shell.setText(Messages.getString("GridFileDialog.shell_title_files_folders"));
        } else {
            shell.setText(Messages.getString("GridFileDialog.shell_title_file_folder"));
        }
        this.setTitle(Messages.getString("GridFileDialog.title"));
        if (this.hasStyle(8)) {
            if (this.hasStyle(64)) {
                this.setMessage(Messages.getString("GridFileDialog.title_files"));
            } else {
                this.setMessage(Messages.getString("GridFileDialog.title_file"));
            }
        } else if (this.hasStyle(16)) {
            if (this.hasStyle(64)) {
                this.setMessage(Messages.getString("GridFileDialog.title_folders"));
            } else {
                this.setMessage(Messages.getString("GridFileDialog.title_folder"));
            }
        } else if (this.hasStyle(64)) {
            this.setMessage(Messages.getString("GridFileDialog.title_files_folders"));
        } else {
            this.setMessage(Messages.getString("GridFileDialog.title_file_folder"));
        }
        this.addFileTypeFilter(new FileTypeFilter(), Messages.getString("GridFileDialog.label_all_files"));
        if (this.filenameCombo != null && this.filenameCombo.getItemCount() != 0) {
            this.filetypeCombo.select(0);
        }
        return mainComp;
    }

    protected void handleDoubleClick() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        Object object = selection.getFirstElement();
        if (this.treeViewer.isExpandable(object)) {
            boolean state = this.treeViewer.getExpandedState(object);
            this.treeViewer.setExpandedState(object, !state);
        } else {
            this.setReturnCode(0);
            this.close();
        }
    }

    protected void handleFilenameChanged(VerifyEvent e) {
        String errMsg;
        block13: {
            errMsg = null;
            URI uri = this.getURI();
            if (uri != null) {
                String newFilename;
                Path path = new Path(uri.getPath());
                String lastSegment = path.lastSegment();
                String filename = this.getFilename();
                if (filename == null) {
                    filename = EMPTY_STRING;
                }
                if (lastSegment != null && lastSegment.equals(filename)) {
                    path = path.removeLastSegments(1);
                }
                if ((newFilename = String.valueOf(filename.substring(0, e.start)) + e.text + filename.substring(e.end)).length() > 0 && !this.validateFilename(newFilename)) {
                    e.doit = false;
                } else {
                    String spath = (path = path.append(newFilename)).toString();
                    if (!spath.startsWith("/")) {
                        spath = "/" + spath;
                    }
                    try {
                        uri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), spath, uri.getQuery(), uri.getFragment());
                        this.setURI(uri);
                        try {
                            IFileStore fileStore = EFS.getStore((URI)uri);
                            IFileInfo fileInfo = fileStore.fetchInfo();
                            if (this.hasStyle(8) && fileInfo.isDirectory()) {
                                errMsg = Messages.getString("GridFileDialog.file_only_mode_warning");
                                break block13;
                            }
                            if (this.hasStyle(16) && !fileInfo.isDirectory()) {
                                errMsg = Messages.getString("GridFileDialog.folder_only_mode_warning");
                                break block13;
                            }
                            this.setCurrentSelection(new IFileStore[]{fileStore});
                        }
                        catch (CoreException cExc) {
                            errMsg = String.format(Messages.getString("GridFileDialog.create_file_store_error"), cExc.getLocalizedMessage());
                        }
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        errMsg = String.format(Messages.getString("GridFileDialog.invalid_file_name_error"), newFilename);
                    }
                }
            }
        }
        if (errMsg != null) {
            this.setCurrentSelection(null);
        }
        this.setErrorMessage(errMsg);
    }

    protected void handleSelectionChanged() {
        String errMsg = null;
        IFileStore[] selection = this.getSelection();
        if (selection == null || selection.length == 0) {
            this.setFilename(null);
            this.setURI(null);
        } else if (this.hasStyle(8) || this.hasStyle(16)) {
            IFileStore[] iFileStoreArray = selection;
            int n = selection.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStore store = iFileStoreArray[n2];
                IFileInfo info = store.fetchInfo();
                if (this.hasStyle(8) && info.isDirectory()) {
                    errMsg = Messages.getString("GridFileDialog.file_only_mode_warning");
                    break;
                }
                if (this.hasStyle(16) && !info.isDirectory()) {
                    errMsg = Messages.getString("GridFileDialog.folder_only_mode_warning");
                    break;
                }
                ++n2;
            }
        }
        if (selection != null && selection.length == 1) {
            this.setURI(selection[0].toURI());
            if (errMsg == null) {
                this.setFilename(selection[0].getName());
            } else {
                this.setFilename(null);
            }
        } else {
            this.setURI(null);
            this.setFilename(null);
        }
        if (errMsg == null) {
            this.setCurrentSelection(selection);
        } else {
            this.setCurrentSelection(null);
        }
        this.setErrorMessage(errMsg);
    }

    protected void handleUriChanged() {
        URI uri = this.getURI();
        if (uri != null) {
            String errMsg = null;
            try {
                IFileStore fileStore = EFS.getStore((URI)uri);
                IFileInfo fileInfo = fileStore.fetchInfo();
                if (this.hasStyle(8) && fileInfo.isDirectory()) {
                    errMsg = Messages.getString("GridFileDialog.file_only_mode_warning");
                } else if (this.hasStyle(16) && !fileInfo.isDirectory()) {
                    errMsg = Messages.getString("GridFileDialog.folder_only_mode_warning");
                } else {
                    this.setFilename(fileInfo.getName());
                    this.setCurrentSelection(new IFileStore[]{fileStore});
                }
            }
            catch (CoreException cExc) {
                errMsg = String.format(Messages.getString("GridFileDialog.create_file_store_error"), cExc.getLocalizedMessage());
            }
            if (errMsg != null) {
                this.setFilename(null);
                this.setCurrentSelection(null);
            }
            this.setErrorMessage(errMsg);
        } else {
            this.setFilename(null);
            this.setCurrentSelection(null);
        }
    }

    protected void setMode(int mode) {
        switch (mode) {
            case 1: {
                this.treeViewer.setInput((Object)GridModel.getConnectionManager());
                break;
            }
            case 4: {
                this.treeViewer.setInput((Object)EFS.getLocalFileSystem().getStore((IPath)new Path("/")));
                break;
            }
            case 2: {
                String home = System.getProperty(HOME_PROPERTY);
                this.treeViewer.setInput((Object)EFS.getLocalFileSystem().getStore((IPath)new Path(home)));
                break;
            }
            case 3: {
                this.treeViewer.setInput((Object)GridModel.getRoot());
            }
        }
    }

    protected void refreshViewer(final IGridElement element) {
        Control control = this.treeViewer.getControl();
        if (!control.isDisposed()) {
            Display display = control.getDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    if (!GridFileDialog.this.treeViewer.getControl().isDisposed()) {
                        if (element == null) {
                            GridFileDialog.this.treeViewer.refresh(false);
                        } else {
                            IGridContainer container;
                            if (element instanceof IGridContainer && (container = (IGridContainer)element).isLazy() && container.isDirty()) {
                                GridFileDialog.this.treeViewer.setChildCount((Object)container, container.getChildCount());
                            }
                            GridFileDialog.this.treeViewer.refresh((Object)element, false);
                        }
                    }
                }
            });
        }
    }

    private void addFileTypeFilter(FileTypeFilter filter, String description) {
        this.filetypeFilters.put(description, filter);
        this.configureViewerFilters();
    }

    private boolean hasStyle(int bit) {
        return (this.style & bit) != 0;
    }

    private void initializeFileTypeCombo() {
        if (this.filetypeCombo != null) {
            this.filetypeCombo.removeAll();
            Set<String> keySet = this.filetypeFilters.keySet();
            String[] keyArray = keySet.toArray(new String[keySet.size()]);
            Arrays.sort(keyArray, new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    String p1 = GridFileDialog.this.filetypeFilters.get(s1).getPrefix();
                    String p2 = GridFileDialog.this.filetypeFilters.get(s2).getPrefix();
                    return p1.compareToIgnoreCase(p2);
                }
            });
            this.filetypeCombo.setItems(keyArray);
            this.filetypeCombo.select(0);
        }
    }

    private void assertStyle() {
        Assert.isTrue((!(this.hasStyle(1) && this.hasStyle(2) || this.hasStyle(1) && this.hasStyle(4) || this.hasStyle(2) && this.hasStyle(4)) ? 1 : 0) != 0, (String)"Only one of STYLE_ALLOW_ONLY_LOCAL, STYLE_ALLOW_ONLY_CONNECTIONS and STYLE_ALLOW_ONLY_REMOTE_CONNECTIONS is allowed");
        Assert.isTrue((!this.hasStyle(8) || !this.hasStyle(16) ? 1 : 0) != 0, (String)"Only one of STYLE_ALLOW_ONLY_FILES and STYLE_ALLOW_ONLY_FOLDERS is allowed");
    }

    private String getFilename() {
        String result = null;
        if (this.filenameCombo != null && !this.filenameCombo.isDisposed()) {
            result = this.filenameCombo.getText();
        }
        return result;
    }

    private IFileStore[] getSelection() {
        IFileStore[] result = null;
        if (this.treeViewer != null && !this.treeViewer.getTree().isDisposed()) {
            ArrayList<IFileStore> list = new ArrayList<IFileStore>();
            IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
            for (Object o : selection) {
                if (o instanceof IGridConnectionElement) {
                    try {
                        o = ((IGridConnectionElement)o).getConnectionFileStore();
                    }
                    catch (CoreException coreException) {}
                } else if (o instanceof IGridElement) {
                    o = ((IGridElement)o).getFileStore();
                }
                if (!(o instanceof IFileStore)) continue;
                list.add((IFileStore)o);
            }
            if (!list.isEmpty()) {
                result = list.toArray(new IFileStore[list.size()]);
            }
        }
        return result;
    }

    private URI getURI() {
        URI result = null;
        this.setErrorMessage(null);
        if (this.uriCombo != null && !this.uriCombo.isDisposed()) {
            String text = this.uriCombo.getText();
            try {
                result = new URI(text);
            }
            catch (URISyntaxException uriExc) {
                this.setErrorMessage(String.format(Messages.getString("GridFileDialog.invalid_uri_error"), uriExc.getLocalizedMessage()));
            }
        }
        return result;
    }

    private void setCurrentSelection(IFileStore[] selection) {
        if (selection != null && selection.length > 0) {
            this.currentSelection = new IFileStore[selection.length];
            System.arraycopy(selection, 0, this.currentSelection, 0, selection.length);
            this.getButton(0).setEnabled(true);
        } else {
            this.currentSelection = null;
            this.getButton(0).setEnabled(false);
        }
    }

    private void setFilename(String filename) {
        if (this.filenameCombo != null && !this.filenameCombo.isDisposed()) {
            if (filename == null) {
                this.filenameCombo.setText(EMPTY_STRING);
            } else {
                this.filenameCombo.setText(filename);
            }
        }
    }

    private void setURI(URI uri) {
        if (this.uriCombo != null && !this.uriCombo.isDisposed()) {
            if (uri == null) {
                this.uriCombo.setText(EMPTY_STRING);
            } else {
                GEclipseURI geclURI = new GEclipseURI(uri);
                this.uriCombo.setText(geclURI.toSlaveURI().toString());
            }
        }
    }

    protected void setNotificationEnabled(boolean b) {
        if (b) {
            if (this.uriCombo != null) {
                this.uriCombo.addModifyListener(this.uriListener);
            }
            if (this.filenameCombo != null) {
                this.filenameCombo.addVerifyListener(this.filenameListener);
            }
            this.treeViewer.addSelectionChangedListener(this.selectionListener);
        } else {
            if (this.uriCombo != null) {
                this.uriCombo.removeModifyListener(this.uriListener);
            }
            if (this.filenameCombo != null) {
                this.filenameCombo.removeVerifyListener(this.filenameListener);
            }
            this.treeViewer.removeSelectionChangedListener(this.selectionListener);
        }
    }

    private boolean validateFilename(String filename) {
        return POSIX_FILENAME.matcher(filename).matches();
    }

    private static class FileTypeFilter
    extends ViewerFilter {
        private static final String WILDCARD = "*";
        private static final String PREFIX_SEPARATOR = ".";
        private String prefix;

        public FileTypeFilter() {
            this(null);
        }

        public FileTypeFilter(String prefix) {
            this.prefix = prefix;
        }

        public String getPrefix() {
            return this.prefix == null ? WILDCARD : this.prefix;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            boolean result = false;
            if (this.prefix != null) {
                if (element instanceof IFileStore) {
                    boolean isDir = ((IFileStore)element).fetchInfo().isDirectory();
                    String name = ((IFileStore)element).getName();
                    result = isDir || name.endsWith(PREFIX_SEPARATOR + this.prefix);
                } else if (element instanceof IGridConnectionElement) {
                    boolean isDir = ((IGridConnectionElement)element).isFolder();
                    String name = ((IGridConnectionElement)element).getName();
                    result = isDir || name.endsWith(PREFIX_SEPARATOR + this.prefix);
                } else if (element instanceof IGridContainer) {
                    IResource resource = ((IGridContainer)element).getResource();
                    if (resource != null && resource.getType() == 1) {
                        String name = resource.getName();
                        result = name.endsWith(PREFIX_SEPARATOR + this.prefix);
                    } else {
                        result = true;
                    }
                } else if (element instanceof IGridElement) {
                    String name = ((IGridElement)element).getName();
                    result = name.endsWith(PREFIX_SEPARATOR + this.prefix);
                } else if (element instanceof ProgressTreeNode) {
                    result = true;
                }
            } else {
                result = true;
            }
            return result;
        }
    }

    private static class FolderFilter
    extends ViewerFilter {
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            boolean result = false;
            if (element instanceof IGridElement) {
                if (element instanceof IGridConnectionElement) {
                    result = ((IGridConnectionElement)element).isFolder();
                } else if (element instanceof IGridContainer) {
                    result = true;
                }
            } else if (element instanceof IFileStore) {
                IFileInfo info = ((IFileStore)element).fetchInfo();
                result = info.isDirectory();
            } else if (element instanceof ProgressTreeNode) {
                result = true;
            }
            return result;
        }
    }

    private static interface IModeChangeListener {
        public void modeChanged(int var1);
    }

    private static class ModeManager
    extends SelectionAdapter {
        public static final int CONNECTION_MODE = 1;
        public static final int HOME_MODE = 2;
        public static final int WS_MODE = 3;
        public static final int ROOT_MODE = 4;
        private static final String MODE_KEY = "button.mode";
        private List<ToolItem> modeItems = new ArrayList<ToolItem>();
        private List<IModeChangeListener> listeners = new ArrayList<IModeChangeListener>();

        public void addModeChangeListener(IModeChangeListener l) {
            if (!this.listeners.contains(l)) {
                this.listeners.add(l);
            }
        }

        public void addModeItem(ToolItem item, int mode) {
            item.setData(MODE_KEY, (Object)mode);
            this.modeItems.add(item);
            item.addSelectionListener((SelectionListener)this);
        }

        public void setMode(int mode) {
            Iterator<ToolItem> iterator = this.modeItems.iterator();
            while (iterator.hasNext()) {
                ToolItem item;
                Integer m = (Integer)(item = iterator.next()).getData(MODE_KEY);
                item.setSelection(m != null && m == mode);
            }
        }

        public void widgetSelected(SelectionEvent e) {
            for (ToolItem item : this.modeItems) {
                item.setSelection(item == e.widget);
            }
            Object mode = e.widget.getData(MODE_KEY);
            if (mode instanceof Integer) {
                this.fireModeChanged((Integer)mode);
            }
        }

        private void fireModeChanged(int mode) {
            for (IModeChangeListener l : this.listeners) {
                l.modeChanged(mode);
            }
        }
    }

    private static class RemoteConnectionFilter
    extends ViewerFilter {
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            boolean result = false;
            if (element instanceof IGridConnectionElement) {
                result = !((IGridConnectionElement)element).isLocal();
            } else if (element instanceof ProgressTreeNode) {
                result = true;
            }
            return result;
        }
    }
}

