/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal;

import eu.geclipse.core.model.IGridConnectionElement;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.impl.ContainerMarker;
import eu.geclipse.ui.providers.ProgressTreeNode;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridConnectionFilter
extends ViewerFilter {
    private static final String FILTER_PREFIX = "*.";
    private static final String WILDCARD_FILTER = "*";
    private List<String> filters = new ArrayList<String>();
    private String activeFilter;

    public void addFileExtensionFilter(String filter) {
        if (!this.matches(filter, this.filters)) {
            this.filters.add(filter);
            if (this.activeFilter == null) {
                this.activeFilter = filter;
            }
        }
    }

    public void clearFileExtensionFilters() {
        this.filters.clear();
        this.activeFilter = null;
    }

    public void link(final StructuredViewer viewer, final Combo combo) {
        viewer.addFilter((ViewerFilter)this);
        combo.removeAll();
        if (this.filters.isEmpty()) {
            combo.add("*.*");
            combo.setText("*.*");
        } else {
            for (String filter : this.filters) {
                combo.add(FILTER_PREFIX + filter);
            }
            combo.setText(FILTER_PREFIX + this.activeFilter);
        }
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String filter = combo.getText();
                GridConnectionFilter.this.setActiveFilter(filter.substring(2));
                viewer.refresh();
            }
        });
    }

    public void setActiveFilter(String filter) {
        if (filter != null) {
            this.addFileExtensionFilter(filter);
        }
        this.activeFilter = filter;
    }

    public void setFileExtensionFilter(String filter) {
        this.clearFileExtensionFilters();
        this.addFileExtensionFilter(filter);
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        boolean result = false;
        if (element instanceof IGridConnectionElement) {
            result = this.select((IGridConnectionElement)element);
        } else if (element instanceof IGridContainer || element instanceof ProgressTreeNode || element instanceof ContainerMarker) {
            result = true;
        }
        return result;
    }

    protected boolean select(IGridConnectionElement element) {
        boolean result = this.filters.isEmpty();
        if (this.activeFilter != null) {
            Path path;
            String extension;
            result = element.isFolder() ? true : ((extension = (path = new Path(element.getName())).getFileExtension()) == null ? false : this.activeFilter.equals(WILDCARD_FILTER) || this.matches(extension, this.activeFilter));
        }
        return result;
    }

    private boolean matches(String extension, List<String> filterList) {
        boolean result = false;
        for (String filter : filterList) {
            if (!this.matches(extension, filter)) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean matches(String extension, String filter) {
        return extension.equalsIgnoreCase(filter);
    }
}

