/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal;

import eu.geclipse.core.model.IGridConnectionElement;
import eu.geclipse.ui.internal.Activator;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class GridConnectionProtocolFilter
extends ViewerFilter {
    private List<String> protocolsToFilter = new ArrayList<String>();

    public void addFilterProtocol(String protocol) {
        if (!this.protocolsToFilter.contains(protocol)) {
            this.protocolsToFilter.add(protocol);
        }
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        boolean result = false;
        if (element instanceof IGridConnectionElement) {
            result = this.select((IGridConnectionElement)element);
        }
        return result;
    }

    private boolean select(IGridConnectionElement element) {
        boolean result = true;
        try {
            String protocol;
            int start;
            String query = element.getConnectionFileStore().toURI().getQuery();
            if (query != null && (start = query.indexOf("geclslave=")) != -1 && this.protocolsToFilter.contains(protocol = query.substring(start + "geclslave=".length(), query.indexOf("&", start)))) {
                result = false;
            }
        }
        catch (CoreException e) {
            Activator.logException(e);
        }
        return result;
    }
}

