/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal;

import eu.geclipse.core.model.IGridElement;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

public class GridElementSelectionAdapter
implements ISelectionProvider,
ISelectionChangedListener {
    private List<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>();
    private ISelection currentSelection;

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public ISelection getSelection() {
        return this.currentSelection == null ? StructuredSelection.EMPTY : this.currentSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setSelection(event.getSelection());
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.setSelection((IStructuredSelection)selection);
        }
    }

    public void setSelection(IStructuredSelection selection) {
        this.currentSelection = this.remapSelection(selection);
        this.fireSelectionChanged();
    }

    protected void fireSelectionChanged() {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        for (ISelectionChangedListener listener : this.listeners) {
            listener.selectionChanged(event);
        }
    }

    protected IStructuredSelection remapSelection(IStructuredSelection selection) {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        for (Object o : selection.toList()) {
            IResource resource = this.remapObject(o);
            if (resource == null) continue;
            resources.add(resource);
        }
        return new StructuredSelection(resources);
    }

    private IResource remapGridElement(IGridElement e) {
        return e.getResource();
    }

    private IResource remapObject(Object o) {
        IResource resource = null;
        if (o instanceof IResource) {
            resource = (IResource)o;
        } else if (o instanceof IGridElement) {
            resource = this.remapGridElement((IGridElement)o);
        } else if (o instanceof IAdaptable) {
            resource = (IResource)((IAdaptable)o).getAdapter(IResource.class);
        }
        return resource;
    }
}

