/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.actions;

import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.internal.GridElementSelectionAdapter;
import eu.geclipse.ui.internal.actions.Messages;
import eu.geclipse.ui.internal.actions.RefreshAction;
import eu.geclipse.ui.views.GridModelViewPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.dialogs.PropertyDialogAction;

public class CommonActions
extends ActionGroup {
    RefreshAction refreshAction;
    private IWorkbenchSite site;
    private GridElementSelectionAdapter selectionAdapter;
    private PropertyDialogAction propertyAction;

    public CommonActions(GridModelViewPart part) {
        this.site = part.getSite();
        Shell shell = this.site.getShell();
        SameShellProvider shellProvider = new SameShellProvider((Control)shell);
        ISelectionProvider selectionProvider = this.site.getSelectionProvider();
        this.selectionAdapter = new GridElementSelectionAdapter();
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.selectionAdapter);
        this.propertyAction = new PropertyDialogAction((IShellProvider)shellProvider, (ISelectionProvider)this.selectionAdapter);
        this.refreshAction = new RefreshAction(shell);
        this.refreshAction.setText(Messages.getString("CommonActions.refresh"));
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.refreshAction);
        ImageRegistry imgReg = Activator.getDefault().getImageRegistry();
        Image image = imgReg.get("refresh");
        ImageDescriptor refreshImage = ImageDescriptor.createFromImage((Image)image);
        this.refreshAction.setImageDescriptor(refreshImage);
        part.getViewer().getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000E) {
                    CommonActions.this.refreshAction.run();
                }
            }
        });
    }

    public void dispose() {
        ISelectionProvider selectionProvider = this.site.getSelectionProvider();
        selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.selectionAdapter);
        selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.refreshAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        if (this.propertyAction.isEnabled()) {
            menu.appendToGroup("group.properties", (IAction)this.propertyAction);
        }
        if (this.refreshAction.isEnabled()) {
            menu.appendToGroup("group.build", (IAction)this.refreshAction);
        }
        super.fillContextMenu(menu);
    }

    public void updateActionBars() {
        super.updateActionBars();
        IStructuredSelection selection = null;
        if (this.getContext() != null && this.getContext().getSelection() instanceof IStructuredSelection) {
            selection = (IStructuredSelection)this.getContext().getSelection();
        }
        this.refreshAction.selectionChanged(selection);
        this.propertyAction.selectionChanged(selection);
    }
}

