/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.actions;

import eu.geclipse.ui.internal.actions.Messages;
import eu.geclipse.ui.internal.actions.UpdateJobStatusAction;
import eu.geclipse.ui.views.jobdetails.JobDetailsView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.actions.ActionGroup;

public class JobDetailsViewActions
extends ActionGroup {
    private static final String MEMENTOKEY_SHOW_EMPTY_VALUES = "ShowEmptyValues";
    private JobDetailsView view;
    private IAction showEmptyValuesAction;
    private UpdateJobStatusAction updateJobStatusAction;

    public JobDetailsViewActions(JobDetailsView view) {
        this.view = view;
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.getToolBarManager().add((IAction)this.getUpdateJobStatusAction());
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        menu.add((IAction)this.getUpdateJobStatusAction());
        menu.add(this.getShowEmptyValuesAction());
    }

    private IAction getShowEmptyValuesAction() {
        if (this.showEmptyValuesAction == null) {
            this.showEmptyValuesAction = new Action(Messages.getString("JobDetailsViewActions.showEmptyValues"), 2){

                public void run() {
                    JobDetailsViewActions.this.getView().refresh();
                }
            };
        }
        return this.showEmptyValuesAction;
    }

    public boolean isShowEmptyEnabled() {
        return this.getShowEmptyValuesAction().isChecked();
    }

    private boolean getMementoBoolean(IMemento currentMemento, String key) {
        Integer integer = currentMemento.getInteger(key);
        return integer != null && integer != 0;
    }

    public void readState(IMemento memento) {
        this.getShowEmptyValuesAction().setChecked(this.getMementoBoolean(memento, MEMENTOKEY_SHOW_EMPTY_VALUES));
    }

    public void saveState(IMemento memento) {
        memento.putInteger(MEMENTOKEY_SHOW_EMPTY_VALUES, this.isShowEmptyEnabled() ? 1 : 0);
    }

    private UpdateJobStatusAction getUpdateJobStatusAction() {
        if (this.updateJobStatusAction == null) {
            this.updateJobStatusAction = new UpdateJobStatusAction();
            this.view.getJobSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this.updateJobStatusAction);
        }
        return this.updateJobStatusAction;
    }

    public void dispose() {
        if (this.updateJobStatusAction != null) {
            this.view.getJobSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this.updateJobStatusAction);
            this.updateJobStatusAction = null;
        }
        super.dispose();
    }

    JobDetailsView getView() {
        return this.view;
    }
}

