/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.actions;

import eu.geclipse.ui.internal.actions.Messages;
import eu.geclipse.ui.internal.actions.SubmitJobAction;
import eu.geclipse.ui.internal.actions.ToggleUpdateJobsAction;
import eu.geclipse.ui.internal.actions.UpdateJobStatusAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;

public class JobViewActions
extends ActionGroup {
    private ToggleUpdateJobsAction toggleJobsUpdateAction;
    private UpdateJobStatusAction updateSelectedJobStatusAction;
    private SubmitJobAction submitJobAction;
    private IWorkbenchSite site;

    public JobViewActions(IWorkbenchSite site) {
        this.site = site;
        this.toggleJobsUpdateAction = new ToggleUpdateJobsAction();
        this.updateSelectedJobStatusAction = new UpdateJobStatusAction(site.getWorkbenchWindow());
        this.submitJobAction = new SubmitJobAction(site);
        ISelectionProvider provider = this.site.getSelectionProvider();
        provider.addSelectionChangedListener((ISelectionChangedListener)this.toggleJobsUpdateAction);
        provider.addSelectionChangedListener((ISelectionChangedListener)this.updateSelectedJobStatusAction);
        provider.addSelectionChangedListener((ISelectionChangedListener)this.submitJobAction);
    }

    public void setJobsUpdateStatus(boolean status) {
        this.toggleJobsUpdateAction.setChecked(status);
        if (status) {
            this.toggleJobsUpdateAction.setToolTipText(Messages.getString("ToggleJobsUpdatesAction.toggle_jobs_updates_action_active_text"));
        } else {
            this.toggleJobsUpdateAction.setToolTipText(Messages.getString("ToggleJobsUpdatesAction.toggle_jobs_updates_action_inactive_text"));
        }
    }

    public void dispose() {
        ISelectionProvider provider = this.site.getSelectionProvider();
        provider.removeSelectionChangedListener((ISelectionChangedListener)this.toggleJobsUpdateAction);
        provider.removeSelectionChangedListener((ISelectionChangedListener)this.updateSelectedJobStatusAction);
        provider.removeSelectionChangedListener((ISelectionChangedListener)this.submitJobAction);
    }

    public void fillActionBars(IActionBars actionBars) {
        IToolBarManager manager = actionBars.getToolBarManager();
        manager.add((IAction)this.updateSelectedJobStatusAction);
        manager.add((IAction)this.toggleJobsUpdateAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        if (this.toggleJobsUpdateAction != null) {
            menu.appendToGroup("group.new", (IAction)this.toggleJobsUpdateAction);
            if (this.updateSelectedJobStatusAction.isEnabled()) {
                menu.appendToGroup("group.build", (IAction)this.updateSelectedJobStatusAction);
            }
            menu.appendToGroup("group.build", (IAction)this.submitJobAction);
            super.fillContextMenu(menu);
        }
    }

    public void updateActionBars() {
        super.updateActionBars();
        IStructuredSelection selection = null;
        if (this.getContext() != null && this.getContext().getSelection() instanceof IStructuredSelection) {
            selection = (IStructuredSelection)this.getContext().getSelection();
        }
        this.updateSelectedJobStatusAction.selectionChanged(selection);
    }
}

