/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.actions;

import eu.geclipse.core.accesscontrol.IACL;
import eu.geclipse.core.model.IProtectable;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.dialogs.AccessControlDialog;
import eu.geclipse.ui.dialogs.ProblemDialog;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.internal.actions.Messages;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.SelectionListenerAction;

public class ManagePermissionsAction
extends SelectionListenerAction {
    private IWorkbenchSite site;
    private List<IProtectable> selectedElements;

    public ManagePermissionsAction(IWorkbenchPartSite site) {
        super(Messages.getString("ManagePermissionsAction.title"));
        super.setToolTipText(Messages.getString("ManagePermissionsAction.tooltip"));
        this.site = site;
        this.selectedElements = new ArrayList<IProtectable>();
    }

    public void run() {
        if (this.selectedElements == null) {
            return;
        }
        ArrayList<IACL> aclList = new ArrayList<IACL>();
        try {
            for (IProtectable next : this.selectedElements) {
                IACL acl = next.fetchACL(null);
                if (acl == null) {
                    throw new ProblemException("eu.geclipse.core.problem.accesscontrol.invalidACL", Messages.getString("ManagePermissionsAction.null_ACL_error"), "eu.geclipse.ui");
                }
                aclList.add(acl);
            }
            boolean saveAsWhole = ((IACL)aclList.get(0)).canSaveWholeACL();
            AccessControlDialog dialog = new AccessControlDialog(aclList, saveAsWhole, this.site.getShell());
            dialog.open();
        }
        catch (ProblemException pe) {
            ProblemDialog.openProblem(this.site.getShell(), Messages.getString("ManagePermissionsAction.error_fetching_ACL_title"), Messages.getString("ManagePermissionsAction.error_fetching_ACL_description"), pe);
            Activator.logException(pe);
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        Class<?> type = null;
        this.selectedElements.clear();
        boolean enabled = super.updateSelection(selection);
        Iterator it = selection.iterator();
        while (enabled && it.hasNext()) {
            Object next = it.next();
            IProtectable protectable = null;
            if (next instanceof IProtectable) {
                protectable = (IProtectable)next;
            } else if (next instanceof IAdaptable) {
                IAdaptable adaptable = (IAdaptable)next;
                protectable = (IProtectable)adaptable.getAdapter(IProtectable.class);
            }
            if (protectable != null) {
                this.selectedElements.add(protectable);
            } else {
                enabled = false;
            }
            if (type == null) {
                type = next.getClass();
                continue;
            }
            if (type == next.getClass()) continue;
            enabled = false;
        }
        if (this.selectedElements.size() > 1) {
            enabled = false;
        }
        return enabled && !this.selectedElements.isEmpty();
    }
}

