/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.actions;

import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.ui.internal.actions.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefreshAction
extends BaseSelectionListenerAction {
    private org.eclipse.ui.actions.RefreshAction resourcesRefresh;
    private List<IGridElement> virtualElements;

    protected RefreshAction(Shell shell) {
        super(Messages.getString("RefreshAction.refresh"));
        this.resourcesRefresh = new org.eclipse.ui.actions.RefreshAction(shell);
    }

    public void run() {
        if (this.resourcesRefresh.isEnabled()) {
            this.resourcesRefresh.run();
        }
        if (!this.virtualElements.isEmpty()) {
            this.refreshElements(this.virtualElements);
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        boolean result = false;
        ArrayList<IResource> resources = new ArrayList<IResource>();
        this.virtualElements = new ArrayList<IGridElement>();
        result = this.filterSelection(selection, resources, this.virtualElements);
        if (result) {
            if (!resources.isEmpty() || resources.isEmpty() && this.virtualElements.isEmpty()) {
                this.resourcesRefresh.selectionChanged((IStructuredSelection)new StructuredSelection(resources));
                result = this.resourcesRefresh.isEnabled();
            }
            result |= resources.isEmpty() && !this.virtualElements.isEmpty();
        }
        return result;
    }

    private boolean filterSelection(IStructuredSelection selection, List<IResource> resources, List<IGridElement> elements) {
        for (Object o : selection) {
            IResource resource = this.getResource(o);
            if (resource != null) {
                resources.add(resource);
                continue;
            }
            if (!(o instanceof IGridElement)) continue;
            elements.add((IGridElement)o);
        }
        return resources.size() + elements.size() == selection.size();
    }

    private void refreshElements(final List<IGridElement> elements) {
        WorkspaceJob job = new WorkspaceJob("Element Refresh"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                SubMonitor sMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Refreshing virtual grid elements", (int)elements.size());
                for (IGridElement element : elements) {
                    if (!(element instanceof IGridContainer)) continue;
                    IGridContainer container = (IGridContainer)element;
                    container.setDirty();
                    container.refresh((IProgressMonitor)sMonitor.newChild(1));
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private IResource getResource(Object o) {
        IResource resource = null;
        if (o instanceof IResource) {
            resource = (IResource)o;
        } else if (o instanceof IAdaptable) {
            resource = (IResource)((IAdaptable)o).getAdapter(IResource.class);
        }
        return resource;
    }
}

