/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.actions;

import eu.geclipse.ui.Extensions;
import eu.geclipse.ui.ISimpleTestUIFactory;
import eu.geclipse.ui.internal.actions.Messages;
import eu.geclipse.ui.internal.actions.SimpleTestAction;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;

public class SimpleTestActions
extends ActionGroup {
    private IWorkbenchSite site;
    private List<SimpleTestAction> testActions;
    private MenuManager dropDownMenuMgr;

    public SimpleTestActions(IWorkbenchSite site) {
        this.site = site;
        ISelectionProvider provider = site.getSelectionProvider();
        this.testActions = new ArrayList<SimpleTestAction>();
        List<ISimpleTestUIFactory> factories = Extensions.getRegisteredSimpleTestUIFactories();
        for (ISimpleTestUIFactory factory : factories) {
            SimpleTestAction action = new SimpleTestAction(this.site, factory);
            provider.addSelectionChangedListener((ISelectionChangedListener)action);
            this.testActions.add(action);
        }
    }

    public void dispose() {
        ISelectionProvider provider = this.site.getSelectionProvider();
        for (SimpleTestAction action : this.testActions) {
            provider.removeSelectionChangedListener((ISelectionChangedListener)action);
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        this.dropDownMenuMgr = new MenuManager(Messages.getString("SimpleTestActions.title"));
        for (SimpleTestAction action : this.testActions) {
            if (!action.isEnabled()) continue;
            this.dropDownMenuMgr.add((IAction)action);
        }
        menu.appendToGroup("additions", (IContributionItem)this.dropDownMenuMgr);
        super.fillContextMenu(menu);
    }

    public void updateActionBars() {
        super.updateActionBars();
        IStructuredSelection selection = null;
        if (this.getContext() != null && this.getContext().getSelection() instanceof IStructuredSelection) {
            selection = (IStructuredSelection)this.getContext().getSelection();
        }
        for (SimpleTestAction action : this.testActions) {
            action.selectionChanged(selection);
        }
    }
}

