/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.actions;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridElementCreator;
import eu.geclipse.core.model.IGridJobDescription;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.internal.actions.TransformAction;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.CompoundContributionItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformMenu
extends CompoundContributionItem
implements ISelectionChangedListener {
    private List<TransformAction> actions = new ArrayList<TransformAction>();
    private IWorkbenchSite site;

    public TransformMenu(IWorkbenchSite site) {
        this.checkVisible();
        this.site = site;
    }

    protected IContributionItem[] getContributionItems() {
        IContributionItem[] result = new IContributionItem[]{};
        if (this.actions != null && this.actions.size() > 0) {
            result = new IContributionItem[this.actions.size()];
            int i = 0;
            while (i < this.actions.size()) {
                result[i] = new ActionContributionItem((IAction)this.actions.get(i));
                ++i;
            }
        }
        return result;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            ArrayList<IGridJobDescription> descList = new ArrayList<IGridJobDescription>();
            List selectionList = ((IStructuredSelection)selection).toList();
            for (Object obj : selectionList) {
                if (obj instanceof IGridJobDescription) {
                    descList.add((IGridJobDescription)obj);
                    continue;
                }
                descList = null;
                break;
            }
            this.setSelectedDescriptions(descList);
        }
    }

    protected void setSelectedDescriptions(List<IGridJobDescription> descriptions) {
        this.createActions(descriptions);
        this.checkVisible();
    }

    protected void checkVisible() {
        this.setVisible(this.actions != null && this.actions.size() > 0);
    }

    private void createActions(List<IGridJobDescription> descriptions) {
        List configs;
        this.actions.clear();
        Class<?> sourceType = null;
        if (descriptions != null && descriptions.size() > 0) {
            sourceType = descriptions.get(0).getClass();
            int i = 1;
            while (i < descriptions.size()) {
                if (!descriptions.get(i).getClass().equals(sourceType)) {
                    sourceType = null;
                    break;
                }
                ++i;
            }
        }
        if (sourceType != null && (configs = GridModel.getCreatorRegistry().getConfigurations(sourceType, IGridJobDescription.class)) != null && configs.size() > 0) {
            IGridJobDescription[] array = descriptions.toArray(new IGridJobDescription[descriptions.size()]);
            for (IConfigurationElement element : configs) {
                TransformAction action = this.getAction(element, array);
                if (action == null) continue;
                this.actions.add(action);
            }
        }
    }

    private TransformAction getAction(IConfigurationElement fromElement, IGridJobDescription[] descriptions) {
        TransformAction result = null;
        String name = fromElement.getAttribute("name");
        try {
            IGridElementCreator creator = (IGridElementCreator)fromElement.createExecutableExtension("class");
            result = new TransformAction(name, creator, descriptions, this.site);
        }
        catch (CoreException cExc) {
            Activator.logException(cExc);
        }
        return result;
    }
}

