/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.actions;

import eu.geclipse.core.jobs.GridJob;
import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridJob;
import eu.geclipse.core.model.IGridJobStatus;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.internal.actions.Messages;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.SelectionListenerAction;

public class UpdateJobStatusAction
extends SelectionListenerAction {
    ArrayList<IGridJob> selectedJobs = new ArrayList();
    private IWorkbenchWindow workbenchWindow;

    public UpdateJobStatusAction(IWorkbenchWindow workbenchWindow) {
        super(Messages.getString("UpdateJobStatusAction.title"));
        this.workbenchWindow = workbenchWindow;
        this.setImageDescriptor(Activator.getDefault().getImageRegistry().getDescriptor("UpdateJobStatus"));
    }

    protected UpdateJobStatusAction() {
        super(Messages.getString("UpdateJobStatusAction.title"));
        this.setImageDescriptor(Activator.getDefault().getImageRegistry().getDescriptor("UpdateJobStatus"));
    }

    public void run() {
        if (this.selectedJobs.size() > 0) {
            final ArrayList jobsToUpdate = (ArrayList)this.selectedJobs.clone();
            Job job = new Job(Messages.getString("UpdateJobStatusAction.manual_update_job_name")){

                protected IStatus run(IProgressMonitor monitor) {
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
                    subMonitor.beginTask(Messages.getString("UpdateJobStatusAction.manual_update_task_name"), jobsToUpdate.size());
                    for (IGridJob jobToUpdate : jobsToUpdate) {
                        if (subMonitor.isCanceled()) continue;
                        subMonitor.subTask(String.valueOf(Messages.getString("UpdateJobStatusAction.manual_update_subtask_name")) + " " + jobToUpdate.getJobName());
                        IGridJobStatus oldStatus = jobToUpdate.getJobStatus();
                        jobToUpdate.updateJobStatus((IProgressMonitor)subMonitor.newChild(1), true);
                        GridModel.getJobManager().jobStatusChanged(jobToUpdate, oldStatus);
                    }
                    subMonitor.done();
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        this.selectedJobs.clear();
        for (Object element : selection) {
            if (!(element instanceof GridJob)) continue;
            this.selectedJobs.add((IGridJob)((GridJob)element));
        }
        if (this.selectedJobs.size() > 0) {
            if (!this.isEnabled()) {
                this.setEnabled(true);
            }
        } else {
            this.setEnabled(false);
        }
        return super.updateSelection(selection) && this.selectedJobs.size() > 0;
    }

    public IWorkbenchWindow getWorkbenchWindow() {
        return this.workbenchWindow;
    }
}

