/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.dialogs;

import eu.geclipse.core.security.ICertificateTrustVerifier;
import eu.geclipse.ui.dialogs.CertificateInfoDialog;
import eu.geclipse.ui.internal.Activator;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

public class CertificateTrustDialog
extends TitleAreaDialog {
    private static final String NEVER_TRUST_IMG = "icons/obj16/cert_trust_never_obj.gif";
    private static final String NOTNOW_TRUST_IMG = "icons/obj16/cert_trust_notnow_obj.gif";
    private static final String TEMP_TRUST_IMG = "icons/obj16/cert_trust_temp_obj.gif";
    private static final String SESSION_TRUST_IMG = "icons/obj16/cert_trust_session_obj.gif";
    private static final String PERMANENT_TRUST_IMG = "icons/obj16/cert_trust_permanent_obj.gif";
    private static Hashtable<String, Image> images = new Hashtable();
    protected ICertificateTrustVerifier.TrustMode selection;
    private X509Certificate[] certificateChain;
    private Label issuerDNLabel;
    private Button neverButton;
    private Button notNowButton;
    private Button tempButton;
    private Button sessionButton;
    private Button permanentButton;

    public CertificateTrustDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(67696);
        URL imgURL = Activator.getDefault().getBundle().getResource("icons/wizban/cacert_wiz.gif");
        ImageDescriptor imgDesc = ImageDescriptor.createFromURL((URL)imgURL);
        this.setTitleImage(imgDesc.createImage());
    }

    public static ICertificateTrustVerifier.TrustMode openDialog(Shell parentShell, X509Certificate[] chain) {
        CertificateTrustDialog dialog = new CertificateTrustDialog(parentShell);
        dialog.setCertificateChain(chain);
        dialog.open();
        return dialog.getSelection();
    }

    public ICertificateTrustVerifier.TrustMode getSelection() {
        return this.selection;
    }

    public void setCertificateChain(X509Certificate[] chain) {
        this.certificateChain = chain;
        if (this.issuerDNLabel != null && !this.issuerDNLabel.isDisposed() && chain != null && chain.length > 0) {
            this.issuerDNLabel.setText(chain[0].getIssuerX500Principal().getName());
            this.issuerDNLabel.pack();
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Certificate Trust Dialog");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Control createDialogArea(Composite parent) {
        FontData[] fData;
        Label topRule = new Label(parent, 258);
        topRule.setLayoutData((Object)new GridData(768));
        Composite mainComp = new Composite(parent, 0);
        GridData gData = new GridData(4, 4, true, true);
        gData.widthHint = 250;
        mainComp.setLayoutData((Object)gData);
        mainComp.setLayout((Layout)new GridLayout(1, false));
        Label label1 = new Label(mainComp, 64);
        label1.setText("A secured operation requires to trust a specific certificate. Since the certificate is issued by an unknown Certificate Authority (CA), there is no way to securely verify the certificate.");
        label1.setLayoutData((Object)new GridData(4, 1, true, false));
        Label label2 = new Label(mainComp, 64);
        label2.setText("The Distinguished Name (DN) of the certificate's issuer is:");
        label2.setLayoutData((Object)new GridData(4, 1, true, false));
        this.issuerDNLabel = new Label(mainComp, 64);
        Font font = this.issuerDNLabel.getFont();
        FontData[] fontDataArray = fData = font.getFontData();
        int n = fData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fd = fontDataArray[n2];
            fd.setStyle(fd.getStyle() | 1);
            ++n2;
        }
        this.issuerDNLabel.setFont(new Font(font.getDevice(), fData));
        if (this.certificateChain != null && this.certificateChain.length > 0) {
            this.issuerDNLabel.setText(this.certificateChain[0].getIssuerX500Principal().getName());
        } else {
            this.issuerDNLabel.setText("N/A");
        }
        this.issuerDNLabel.setLayoutData((Object)new GridData(4, 1, true, false));
        Link link = new Link(mainComp, 64);
        link.setText("<a>See certificate details.</a>");
        Label label4 = new Label(mainComp, 64);
        label4.setText("Please choose one of the following options:");
        label4.setLayoutData((Object)new GridData(4, 1, true, false));
        Composite buttonComp = new Composite(mainComp, 0);
        buttonComp.setLayoutData((Object)new GridData(4, 1, true, true));
        buttonComp.setLayout((Layout)new GridLayout(2, false));
        this.neverButton = this.createRadioButton(buttonComp, NEVER_TRUST_IMG, "Never trust this certificate. Adds this certificate chain's subject certificate to the list of untrusted certificates for the duration of this session.");
        this.notNowButton = this.createRadioButton(buttonComp, NOTNOW_TRUST_IMG, "Do not trust this certificate now. You still have the chance to trust this certificate the next time.");
        this.tempButton = this.createRadioButton(buttonComp, TEMP_TRUST_IMG, "Trust this certificate temporarily. You still have the chance to not trust this certificate the next time.");
        this.sessionButton = this.createRadioButton(buttonComp, SESSION_TRUST_IMG, "Trust this certificate for the whole session. Adds the whole certificate chain to the list of trusted certificates for the duration of this session.");
        this.permanentButton = this.createRadioButton(buttonComp, PERMANENT_TRUST_IMG, "Always trust this certificate. Adds the whole certificate chain to the certificate manager.");
        Label bottomRule = new Label(parent, 258);
        bottomRule.setLayoutData((Object)new GridData(768));
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CertificateTrustDialog.this.openInfoDialog();
            }
        });
        this.neverButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CertificateTrustDialog.this.selection = ICertificateTrustVerifier.TrustMode.Never;
            }
        });
        this.notNowButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CertificateTrustDialog.this.selection = ICertificateTrustVerifier.TrustMode.NotNow;
            }
        });
        this.tempButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CertificateTrustDialog.this.selection = ICertificateTrustVerifier.TrustMode.Temporarily;
            }
        });
        this.sessionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CertificateTrustDialog.this.selection = ICertificateTrustVerifier.TrustMode.Session;
            }
        });
        this.permanentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CertificateTrustDialog.this.selection = ICertificateTrustVerifier.TrustMode.Permanent;
            }
        });
        this.notNowButton.setSelection(true);
        this.selection = ICertificateTrustVerifier.TrustMode.NotNow;
        this.setTitle("Certificate Trust Verifier");
        this.setMessage("You should carefully select from the options below if you are willing to trust this certificate or not.");
        return mainComp;
    }

    protected void openInfoDialog() {
        CertificateInfoDialog dialog = new CertificateInfoDialog(this.getShell());
        dialog.setCertificateChain(this.certificateChain);
        dialog.open();
    }

    private Button createRadioButton(Composite parent, String image, String text) {
        Button button = new Button(parent, 16);
        button.setImage(CertificateTrustDialog.getCertImage(image));
        button.setLayoutData((Object)new GridData(1, 1, false, false));
        Label label = new Label(parent, 64);
        label.setText(text);
        label.setLayoutData((Object)new GridData(1, 1, true, false));
        return button;
    }

    private static Image getCertImage(String path) {
        Image image = images.get(path);
        if (image == null) {
            image = CertificateTrustDialog.loadCertImage(path);
            images.put(path, image);
        }
        return image;
    }

    private static Image loadCertImage(String path) {
        URL url = Activator.getDefault().getBundle().getEntry(path);
        ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)url);
        return descriptor.createImage();
    }
}

