/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.dialogs;

import eu.geclipse.core.reporting.IProblem;
import eu.geclipse.core.reporting.ISolution;
import eu.geclipse.core.reporting.ProblemException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;

public class ProblemReport {
    private static final String PLUG_IN_HEADER = "Plug-In";
    private static final String CONTACT_ADDRESS_HEADER = "Contact Address";
    private static final String DESCRIPTION_HEADER = "Description";
    private static final String REASONS_HEADER = "Reasons";
    private static final String SOLUTIONS_HEADER = "Proposed Solutions";
    private static final String STACKTRACE_HEADER = "Stacktrace";
    private static final String SEVERITY_HEADER = "Severity";
    private static final String THROWABLE_DESCRIPTION_TEXT = "Caught an exception: ";
    private static final String HEADER_PREFIX = ":";
    private static final String FIELD_PREFIX = "\t";
    private static final String SOLUTION_FORMAT = "%s (ID=%s)";
    private static final String NA_STRING = "N/A";
    private Throwable exc;

    public ProblemReport(Throwable throwable) {
        this.exc = throwable;
    }

    public String createReport() {
        IProblem problem = null;
        IStatus status = null;
        if (this.exc instanceof ProblemException) {
            problem = ((ProblemException)this.exc).getProblem();
        } else if (this.exc instanceof CoreException) {
            status = ((CoreException)this.exc).getStatus();
        }
        StringWriter sWriter = new StringWriter();
        PrintWriter pWriter = new PrintWriter(sWriter);
        if (problem != null) {
            this.writeField(pWriter, PLUG_IN_HEADER, problem.getPluginID());
            this.writeField(pWriter, CONTACT_ADDRESS_HEADER, problem.getMailTo());
            this.writeField(pWriter, DESCRIPTION_HEADER, problem.getDescription());
            this.writeField(pWriter, REASONS_HEADER, problem.getReasons());
            this.writeField(pWriter, SOLUTIONS_HEADER, problem.getSolutions());
        } else if (status != null) {
            this.writeField(pWriter, PLUG_IN_HEADER, status.getPlugin());
            this.writeField(pWriter, DESCRIPTION_HEADER, status.getMessage());
            this.writeField(pWriter, SEVERITY_HEADER, this.severity(status.getSeverity()));
        } else {
            this.writeField(pWriter, DESCRIPTION_HEADER, THROWABLE_DESCRIPTION_TEXT + this.exc.getClass().getName());
        }
        this.writeField(pWriter, STACKTRACE_HEADER, this.exc);
        pWriter.close();
        return sWriter.toString();
    }

    private String severity(int severity) {
        String sSeverity = NA_STRING;
        switch (severity) {
            case 0: {
                sSeverity = "OK";
                break;
            }
            case 1: {
                sSeverity = "INFO";
                break;
            }
            case 2: {
                sSeverity = "WARNING";
                break;
            }
            case 4: {
                sSeverity = "ERROR";
                break;
            }
            case 8: {
                sSeverity = "CANCEL";
                break;
            }
            default: {
                sSeverity = NA_STRING;
            }
        }
        return sSeverity;
    }

    private void writeField(PrintWriter writer, String header, Throwable t) {
        if (t == null) {
            this.writeField(writer, header, NA_STRING);
        } else {
            StringWriter sWriter = new StringWriter();
            PrintWriter pWriter = new PrintWriter(sWriter);
            t.printStackTrace(pWriter);
            pWriter.close();
            this.writeField(writer, header, sWriter.toString());
        }
    }

    private void writeField(PrintWriter writer, String header, ISolution[] solutions) {
        if (solutions == null || solutions.length == 0) {
            this.writeField(writer, header, NA_STRING);
        } else {
            String[] sols = new String[solutions.length];
            int i = 0;
            while (i < sols.length) {
                sols[i] = String.format(SOLUTION_FORMAT, solutions[i].getDescription(), solutions[i].getID());
                ++i;
            }
            this.writeField(writer, header, sols);
        }
    }

    private void writeField(PrintWriter writer, String header, String content) {
        if (content == null || content.length() == 0) {
            this.writeField(writer, header, NA_STRING);
        } else {
            this.writeField(writer, header, new String[]{content});
        }
    }

    private void writeField(PrintWriter writer, String header, String[] content) {
        if (content == null || content.length == 0) {
            this.writeField(writer, header, NA_STRING);
        } else {
            writer.println(String.valueOf(header) + HEADER_PREFIX);
            String[] stringArray = content;
            int n = content.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                writer.println(FIELD_PREFIX + s);
                ++n2;
            }
            writer.println();
        }
    }
}

