/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.dialogs;

import eu.geclipse.core.reporting.IProblem;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.dialogs.GridFileDialog;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.internal.dialogs.ProblemReport;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class ProblemReportDialog
extends TitleAreaDialog {
    private static final int SEND_ID = 1;
    private static final int SAVE_ID = 2;
    private static final int COPY_ID = 3;
    private Throwable exc;
    private IProblem problem;
    private Text mailtoText;
    private Text reportText;

    public ProblemReportDialog(Shell parentShell, Throwable throwable) {
        super(parentShell);
        this.exc = throwable;
        this.problem = this.exc instanceof ProblemException ? ((ProblemException)this.exc).getProblem() : null;
        this.setShellStyle(67696);
        URL imgURL = Activator.getDefault().getBundle().getResource("icons/extras/problem_report_dlg.gif");
        ImageDescriptor imgDesc = ImageDescriptor.createFromURL((URL)imgURL);
        this.setTitleImage(imgDesc.createImage());
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Problem Report");
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            this.sendPressed();
        } else if (buttonId == 1026) {
            this.savePressed();
        } else if (buttonId == 1027) {
            this.copyPressed();
        } else if (buttonId == 12) {
            this.closePressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, "Send", true);
        this.createButton(parent, 1026, "Save", false);
        this.createButton(parent, 1027, "Copy", false);
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, false);
        this.updateUI();
    }

    protected Control createDialogArea(Composite parent) {
        Label topRule = new Label(parent, 258);
        topRule.setLayoutData((Object)new GridData(768));
        Composite mainComp = new Composite(parent, 0);
        mainComp.setLayout((Layout)new GridLayout(1, false));
        mainComp.setLayoutData((Object)new GridData(4, 4, true, true));
        Label mailtoLabel = new Label(mainComp, 0);
        mailtoLabel.setText("Email address:");
        mailtoLabel.setLayoutData((Object)new GridData());
        this.mailtoText = new Text(mainComp, 2048);
        String mailto = null;
        if (this.problem != null) {
            mailto = this.problem.getMailTo();
        }
        this.mailtoText.setText(mailto == null ? "" : mailto);
        this.mailtoText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label reportLabel = new Label(mainComp, 0);
        reportLabel.setText("Problem Report:");
        reportLabel.setLayoutData((Object)new GridData());
        this.reportText = new Text(mainComp, 2818);
        ProblemReport factory = new ProblemReport(this.exc);
        this.reportText.setText(factory.createReport());
        GridData gData = new GridData(4, 4, true, true);
        gData.widthHint = 500;
        gData.heightHint = 400;
        this.reportText.setLayoutData((Object)gData);
        Label bottomRule = new Label(parent, 258);
        bottomRule.setLayoutData((Object)new GridData(768));
        this.mailtoText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProblemReportDialog.this.updateUI();
            }
        });
        this.setTitle("Problem Report");
        this.setMessage("A problem report was created, you may save it, send it via email, or copy it to clipboard.");
        this.updateUI();
        return mainComp;
    }

    protected void closePressed() {
        this.setReturnCode(0);
        this.close();
    }

    protected void copyPressed() {
        try {
            Transfer[] dataTypes = new Transfer[]{TextTransfer.getInstance()};
            Object[] data = new Object[]{this.reportText.getText()};
            Clipboard clipboard = new Clipboard(this.getShell().getDisplay());
            clipboard.setContents(data, dataTypes);
            clipboard.dispose();
            this.setMessage("The problem report was copied to the system clipboard", 1);
        }
        catch (Throwable t) {
            this.setErrorMessage(String.format("Copy failed: %s", t.getLocalizedMessage()));
        }
    }

    protected void savePressed() {
        try {
            IFileStore[] fsList;
            GridFileDialog dialog = new GridFileDialog(this.getShell(), 8);
            if (dialog.open() == 0 && (fsList = dialog.getSelectedFileStores()) != null && fsList.length > 0) {
                this.saveReport(fsList[0], this.reportText.getText());
                this.setMessage(String.format("The problem report saved to %s", fsList[0].toString()), 1);
            }
        }
        catch (Throwable t) {
            this.setErrorMessage(String.format("Save failed: %s", t.getLocalizedMessage()));
        }
    }

    protected void sendPressed() {
        try {
            String mailto = this.mailtoText.getText();
            if (mailto == null || mailto.length() == 0) {
                throw new IllegalArgumentException("The mailto address is empty");
            }
            URL link = this.getMailToLink(this.reportText.getText(), mailto);
            IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
            IWebBrowser externalBrowser = browserSupport.getExternalBrowser();
            externalBrowser.openURL(link);
            this.setMessage(String.format("An attempt was made to send to problem report to %s", mailto), 1);
        }
        catch (Throwable t) {
            this.setErrorMessage(String.format("Send failed: %s", t.getLocalizedMessage()));
        }
    }

    protected void updateUI() {
        Button sendButton = this.getButton(1025);
        if (sendButton != null) {
            String mailto = this.mailtoText.getText();
            sendButton.setEnabled(mailto != null && mailto.length() > 0);
        }
    }

    private URL getMailToLink(String report, String address) throws MalformedURLException {
        if (address == null || address.length() == 0) {
            throw new IllegalArgumentException("The mailto address is empty");
        }
        return new URL("mailto:" + address + "?subject=Problem Report: " + this.problem.getDescription() + "&body=" + report);
    }

    private void saveReport(IFileStore store, String report) throws CoreException, IOException {
        OutputStream oStream = store.openOutputStream(0, null);
        oStream.write(report.getBytes());
        oStream.close();
    }
}

