/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.layout;

import eu.geclipse.ui.internal.layout.PackData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;

public class PackLayout
extends Layout {
    public int type;
    public int marginWidth;
    public int marginHeight;
    public int spacing;

    public PackLayout() {
        this(256);
    }

    public PackLayout(int type) {
        this.type = type;
        this.marginWidth = 0;
        this.marginHeight = 0;
        this.spacing = 0;
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Control[] children = composite.getChildren();
        int width = 0;
        int height = 0;
        if (children != null) {
            Control[] controlArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                Point size = this.computeChildSize(child, wHint, hHint, flushCache);
                if (this.type == 512) {
                    width = Math.max(size.x, width);
                    height += size.y;
                } else {
                    width += size.x;
                    height = Math.max(size.y, height);
                }
                ++n2;
            }
            if (children.length > 1) {
                if (this.type == 512) {
                    height += (children.length - 1) * this.spacing;
                } else {
                    width += (children.length - 1) * this.spacing;
                }
            }
        }
        return new Point(width += 2 * this.marginWidth, height += 2 * this.marginHeight);
    }

    protected boolean flushCache(Control control) {
        Object data = control.getLayoutData();
        if (data != null) {
            ((PackData)data).flushCache();
        }
        return true;
    }

    protected void layout(Composite composite, boolean flushCache) {
        Rectangle area = composite.getClientArea();
        int x = area.x + this.marginWidth;
        int y = area.y + this.marginHeight;
        int w = area.width - 2 * this.marginWidth;
        int h = area.height - 2 * this.marginHeight;
        Control[] children = composite.getChildren();
        if (children != null) {
            Control[] controlArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                Point size = this.computeChildSize(child, -1, -1, flushCache);
                if (this.type == 512) {
                    h = size.y;
                } else {
                    w = size.x;
                }
                child.setBounds(x, y, w, h);
                if (this.type == 512) {
                    y += this.spacing + h;
                } else {
                    x += this.spacing + w;
                }
                ++n2;
            }
        }
    }

    private Point computeChildSize(Control control, int wHint, int hHint, boolean flushCache) {
        PackData data = (PackData)control.getLayoutData();
        if (data == null) {
            data = new PackData();
            control.setLayoutData((Object)data);
        }
        Point size = null;
        if (wHint == -1 && hHint == -1) {
            size = data.computeSize(control, wHint, hHint, flushCache);
        } else {
            int trimY;
            int trimX;
            if (control instanceof Scrollable) {
                Rectangle rect = ((Scrollable)control).computeTrim(0, 0, 0, 0);
                trimX = rect.width;
                trimY = rect.height;
            } else {
                trimY = trimX = control.getBorderWidth() * 2;
            }
            int w = wHint == -1 ? wHint : Math.max(0, wHint - trimX);
            int h = hHint == -1 ? hHint : Math.max(0, hHint - trimY);
            size = data.computeSize(control, w, h, flushCache);
        }
        return size;
    }
}

