/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.preference;

import eu.geclipse.core.security.ICertificateHandle;
import eu.geclipse.core.security.ICertificateManager;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.internal.preference.CertificateContentProvider;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

public class CertificateLabelProvider
extends ColumnLabelProvider
implements ITableLabelProvider {
    private static final String CERT_IMG = "icons/obj16/cert_obj.gif";
    private static final String ORG_IMG = "icons/obj16/ca_obj.gif";
    private static final String NEVER_TRUST_IMG = "icons/obj16/cert_trust_never_obj.gif";
    private static final String SESSION_TRUST_IMG = "icons/obj16/cert_trust_session_obj.gif";
    private static final String PERMANENT_TRUST_IMG = "icons/obj16/cert_trust_permanent_obj.gif";
    private static final String NA_STRING = "N/A";
    private static Hashtable<String, Image> images = new Hashtable();

    public Image getColumnImage(Object element, int columnIndex) {
        Image result = null;
        if (columnIndex == 0) {
            if (element instanceof Map.Entry) {
                result = CertificateLabelProvider.getCertImage(ORG_IMG);
            } else if (element instanceof ICertificateHandle) {
                ICertificateManager.CertTrust trust = ((ICertificateHandle)element).getTrust();
                result = trust == ICertificateManager.CertTrust.Untrusted ? CertificateLabelProvider.getCertImage(NEVER_TRUST_IMG) : (trust == ICertificateManager.CertTrust.Trusted ? CertificateLabelProvider.getCertImage(SESSION_TRUST_IMG) : (trust == ICertificateManager.CertTrust.AlwaysTrusted ? CertificateLabelProvider.getCertImage(PERMANENT_TRUST_IMG) : CertificateLabelProvider.getCertImage(CERT_IMG)));
            }
        }
        return result;
    }

    public String getColumnText(Object element, int columnIndex) {
        String result = "";
        if (element instanceof Map.Entry && columnIndex == 0) {
            Object key = ((Map.Entry)element).getKey();
            result = key.toString();
        } else if (element instanceof ICertificateHandle) {
            ICertificateHandle c = (ICertificateHandle)element;
            switch (columnIndex) {
                case 0: {
                    result = CertificateContentProvider.getSubjectDN(c.getCertificate(), "CN");
                    break;
                }
                case 1: {
                    result = c.getTrust().toString();
                    break;
                }
                case 2: {
                    result = c.getCertificate().getNotAfter().toString();
                }
            }
        }
        return result;
    }

    private static Image getCertImage(String path) {
        Image image = images.get(path);
        if (image == null) {
            image = CertificateLabelProvider.loadCertImage(path);
            images.put(path, image);
        }
        return image;
    }

    private static Image loadCertImage(String path) {
        URL url = Activator.getDefault().getBundle().getEntry(path);
        ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)url);
        return descriptor.createImage();
    }

    private static String getSubjectCommonName(X509Certificate c) {
        String[] parts;
        String result = NA_STRING;
        String[] stringArray = parts = c.getSubjectX500Principal().getName().split("[,/]");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.trim().toUpperCase().startsWith("CN=")) {
                result = s.trim().substring(3);
                break;
            }
            ++n2;
        }
        return result;
    }
}

