/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.preference;

import eu.geclipse.core.security.ICertificateHandle;
import eu.geclipse.core.security.ICertificateManager;
import eu.geclipse.core.security.ISecurityManager;
import eu.geclipse.core.security.ISecurityManagerListener;
import eu.geclipse.core.security.Security;
import eu.geclipse.core.security.X509Util;
import eu.geclipse.ui.comparators.TreeColumnComparator;
import eu.geclipse.ui.dialogs.CertificateInfoDialog;
import eu.geclipse.ui.dialogs.GridFileDialog;
import eu.geclipse.ui.dialogs.ProblemDialog;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.internal.preference.CertificateContentProvider;
import eu.geclipse.ui.internal.preference.CertificateLabelProvider;
import eu.geclipse.ui.internal.wizards.CertificateImportWizard;
import eu.geclipse.ui.listeners.TreeColumnListener;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SecurityPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
ISecurityManagerListener {
    private static String EXPAND_ALL_IMG = "icons/elcl16/expandall.gif";
    private static String COLLAPSE_ALL_IMG = "icons/elcl16/collapseall.gif";
    private static String VIEW_MENU_IMG = "icons/elcl16/view_menu.gif";
    private static Hashtable<String, Image> images = new Hashtable();
    protected CertificateInfoDialog infoDialog;
    protected TreeViewer certViewer;
    protected CertificateContentProvider cProvider;
    private Button addButton;
    private Button importButton;
    private Button infoButton;
    private Button deleteButton;
    private MenuItem flatItem;
    private MenuItem groupedItem;
    private MenuItem trustItem;
    private MenuItem countryItem;
    private MenuItem stateItem;
    private MenuItem localityItem;
    private MenuItem organizationItem;
    private MenuItem unitItem;

    public SecurityPreferencePage() {
        this.setDescription("Manage your trusted and untrusted certificates. Import CA certificates from remote repositories or add them from a local or remote directory.");
        Security.getCertificateManager().addListener((ISecurityManagerListener)this);
    }

    public void contentChanged(ISecurityManager manager) {
        this.getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                SecurityPreferencePage.this.certViewer.setInput((Object)Security.getCertificateManager());
            }
        });
    }

    public void dispose() {
        Security.getCertificateManager().removeListener((ISecurityManagerListener)this);
        if (this.infoDialog != null) {
            this.infoDialog.close();
        }
        super.dispose();
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.noDefaultAndApplyButton();
        Composite mainComp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        mainComp.setLayout((Layout)layout);
        final ToolBar toolBar = new ToolBar(mainComp, 8519936);
        toolBar.setLayoutData((Object)new GridData(3, 3, false, false));
        ToolItem expandAllItem = new ToolItem(toolBar, 8);
        expandAllItem.setImage(SecurityPreferencePage.getImage(EXPAND_ALL_IMG));
        ToolItem collapseAllItem = new ToolItem(toolBar, 8);
        collapseAllItem.setImage(SecurityPreferencePage.getImage(COLLAPSE_ALL_IMG));
        final ToolItem menuItem = new ToolItem(toolBar, 8);
        menuItem.setImage(SecurityPreferencePage.getImage(VIEW_MENU_IMG));
        final Menu settingsMenu = new Menu((Decorations)this.getShell(), 8);
        MenuItem modeItem = new MenuItem(settingsMenu, 64);
        modeItem.setText("Mode");
        Menu modeMenu = new Menu(settingsMenu);
        modeItem.setMenu(modeMenu);
        this.flatItem = this.createModeItem(modeMenu, "Flat", false);
        this.groupedItem = this.createModeItem(modeMenu, "Grouped", true);
        MenuItem groupItem = new MenuItem(settingsMenu, 64);
        groupItem.setText("Group by");
        Menu groupMenu = new Menu(settingsMenu);
        groupItem.setMenu(groupMenu);
        this.trustItem = this.createGroupItem(groupMenu, "Trust", CertificateContentProvider.GroupMode.Trust);
        new MenuItem(groupMenu, 2);
        this.countryItem = this.createGroupItem(groupMenu, "Country (C)", CertificateContentProvider.GroupMode.Country);
        this.stateItem = this.createGroupItem(groupMenu, "State (ST)", CertificateContentProvider.GroupMode.State);
        this.localityItem = this.createGroupItem(groupMenu, "Locality (L)", CertificateContentProvider.GroupMode.Locality);
        this.organizationItem = this.createGroupItem(groupMenu, "Organization (O)", CertificateContentProvider.GroupMode.Organization);
        this.unitItem = this.createGroupItem(groupMenu, "Organizational Unit (OU)", CertificateContentProvider.GroupMode.OrganizationalUnit);
        new Label(mainComp, 0);
        this.certViewer = new TreeViewer(mainComp, 2818);
        Tree certTree = this.certViewer.getTree();
        GridData gData = new GridData(4, 4, true, true);
        gData.heightHint = 150;
        certTree.setLayoutData((Object)gData);
        certTree.setHeaderVisible(true);
        TreeColumn nameColumn = new TreeColumn(certTree, 16384);
        nameColumn.setText("Certificate");
        nameColumn.setWidth(200);
        nameColumn.setResizable(true);
        TreeColumn typeColumn = new TreeColumn(certTree, 16384);
        typeColumn.setText("Trust");
        typeColumn.setWidth(80);
        typeColumn.setResizable(true);
        TreeColumn timeColumn = new TreeColumn(certTree, 16384);
        timeColumn.setText("Valid until");
        timeColumn.setWidth(200);
        timeColumn.setResizable(true);
        this.cProvider = new CertificateContentProvider();
        this.certViewer.setContentProvider((IContentProvider)this.cProvider);
        this.certViewer.setLabelProvider((IBaseLabelProvider)new CertificateLabelProvider());
        this.certViewer.setInput((Object)Security.getCertificateManager());
        TreeColumnListener columnListener = new TreeColumnListener(this.certViewer);
        TreeColumn[] treeColumnArray = certTree.getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            column.addSelectionListener((SelectionListener)columnListener);
            ++n2;
        }
        certTree.setSortColumn(nameColumn);
        certTree.setSortDirection(128);
        this.certViewer.setComparator((ViewerComparator)new TreeColumnComparator(nameColumn));
        Composite buttons = new Composite(mainComp, 0);
        gData = new GridData(2);
        gData.horizontalSpan = 1;
        buttons.setLayoutData((Object)gData);
        layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        this.addButton = new Button(buttons, 8);
        this.addButton.setText("&Add...");
        gData = new GridData(768);
        this.addButton.setLayoutData((Object)gData);
        this.importButton = new Button(buttons, 8);
        this.importButton.setText("&Import...");
        gData = new GridData(768);
        this.importButton.setLayoutData((Object)gData);
        this.infoButton = new Button(buttons, 8);
        this.infoButton.setText("I&nfo...");
        gData = new GridData(768);
        this.infoButton.setLayoutData((Object)gData);
        this.deleteButton = new Button(buttons, 8);
        this.deleteButton.setText("&Delete");
        gData = new GridData(768);
        this.deleteButton.setLayoutData((Object)gData);
        expandAllItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SecurityPreferencePage.this.certViewer.expandAll();
            }
        });
        collapseAllItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SecurityPreferencePage.this.certViewer.collapseAll();
            }
        });
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Rectangle bounds = menuItem.getBounds();
                Point point = toolBar.toDisplay(bounds.x, bounds.y + bounds.height);
                settingsMenu.setLocation(point);
                settingsMenu.setVisible(true);
            }
        });
        this.certViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SecurityPreferencePage.this.updateButtons();
                SecurityPreferencePage.this.updateInfoDialog();
            }
        });
        this.certViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SecurityPreferencePage.this.processDoubleClickEvent(event);
            }
        });
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SecurityPreferencePage.this.openAddDialog();
            }
        });
        this.importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SecurityPreferencePage.this.openImportWizard();
            }
        });
        this.infoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SecurityPreferencePage.this.openInfoDialog();
            }
        });
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SecurityPreferencePage.this.deleteSelectedCertificates();
            }
        });
        this.updateButtons();
        this.updateMenu();
        return mainComp;
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected void addCertificates(IFileStore[] certStores, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Adding certificates", certStores.length);
        X509Certificate[] certs = new X509Certificate[certStores.length];
        int i = 0;
        while (i < certStores.length) {
            monitor.subTask(certStores[i].getName());
            InputStream iStream = certStores[i].openInputStream(0, null);
            certs[i] = X509Util.loadCertificate((InputStream)iStream);
            monitor.worked(1);
            ++i;
        }
        Security.getCertificateManager().addCertificates(certs, ICertificateManager.CertTrust.AlwaysTrusted);
    }

    protected void deleteSelectedCertificates() {
        boolean confirm = MessageDialog.openConfirm((Shell)this.getShell(), (String)"Delete certificates", (String)"Do you really want to delete all selected certificates?");
        if (confirm) {
            ICertificateHandle[] certificates = this.getSelectedCertificates();
            Security.getCertificateManager().removeCertificates(certificates);
        }
    }

    protected void openAddDialog() {
        int style = 104;
        GridFileDialog dialog = new GridFileDialog(this.getShell(), style);
        dialog.addFileTypeFilter("0", "Base64 encoded certificate (*.0)");
        dialog.addFileTypeFilter("pem", "Base64 encoded certificate (*.pem)");
        dialog.addFileTypeFilter("der", "DER encoded certificate (*.der)");
        dialog.addFileTypeFilter("crt", "Base64 or DER encoded certificate (*.crt)");
        if (dialog.open() == 0) {
            final IFileStore[] fileStores = dialog.getSelectedFileStores();
            try {
                new ProgressMonitorDialog(this.getShell()).run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            SecurityPreferencePage.this.addCertificates(fileStores, monitor);
                        }
                        catch (CoreException cExc) {
                            throw new InvocationTargetException(cExc);
                        }
                    }
                });
            }
            catch (InvocationTargetException itExc) {
                Throwable t = itExc.getCause() == null ? itExc : itExc.getCause();
                ProblemDialog.openProblem(this.getShell(), "Certificate problem", "Failed to add certificates", t);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected void openImportWizard() {
        CertificateImportWizard wizard = new CertificateImportWizard();
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.open();
    }

    protected void openInfoDialog() {
        ICertificateHandle[] certificates = this.getSelectedCertificates();
        if (certificates != null && certificates.length > 0) {
            if (this.infoDialog == null) {
                this.infoDialog = new CertificateInfoDialog(this.getShell());
            }
            this.infoDialog.setCertificate(certificates[0].getCertificate());
            this.infoDialog.open();
        }
    }

    protected void processDoubleClickEvent(DoubleClickEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            Object element = ((IStructuredSelection)selection).getFirstElement();
            if (element instanceof ICertificateHandle) {
                this.openInfoDialog();
            } else {
                boolean state = this.certViewer.getExpandedState(element);
                this.certViewer.setExpandedState(element, !state);
            }
        }
    }

    protected void updateButtons() {
        int orgCount = 0;
        int certCount = 0;
        ISelection selection = this.certViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            for (Object obj : (IStructuredSelection)selection) {
                if (obj instanceof ICertificateHandle) {
                    ++certCount;
                    continue;
                }
                if (!(obj instanceof Map.Entry)) continue;
                ++orgCount;
            }
        }
        this.infoButton.setEnabled(certCount == 1 && orgCount == 0);
        this.deleteButton.setEnabled(orgCount > 0 || certCount > 0);
    }

    protected void updateInfoDialog() {
        ICertificateHandle[] certs;
        if (this.infoDialog != null && (certs = this.getSelectedCertificates()).length > 0) {
            this.infoDialog.setCertificate(certs[0].getCertificate());
        }
    }

    protected void updateMenu() {
        boolean grouped = this.cProvider.isGrouped();
        this.flatItem.setSelection(!grouped);
        this.groupedItem.setSelection(grouped);
        CertificateContentProvider.GroupMode groupMode = this.cProvider.getGroupMode();
        this.countryItem.setSelection(groupMode == CertificateContentProvider.GroupMode.Country);
        this.stateItem.setSelection(groupMode == CertificateContentProvider.GroupMode.State);
        this.localityItem.setSelection(groupMode == CertificateContentProvider.GroupMode.Locality);
        this.organizationItem.setSelection(groupMode == CertificateContentProvider.GroupMode.Organization);
        this.unitItem.setSelection(groupMode == CertificateContentProvider.GroupMode.OrganizationalUnit);
        this.trustItem.setSelection(groupMode == CertificateContentProvider.GroupMode.Trust);
        this.countryItem.setEnabled(grouped);
        this.stateItem.setEnabled(grouped);
        this.localityItem.setEnabled(grouped);
        this.organizationItem.setEnabled(grouped);
        this.unitItem.setEnabled(grouped);
        this.trustItem.setEnabled(grouped);
    }

    private MenuItem createModeItem(Menu parent, String text, final boolean grouped) {
        MenuItem item = new MenuItem(parent, 16);
        item.setText(text);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SecurityPreferencePage.this.cProvider.setGrouped(grouped);
                SecurityPreferencePage.this.certViewer.refresh();
                SecurityPreferencePage.this.updateMenu();
            }
        });
        return item;
    }

    private MenuItem createGroupItem(Menu parent, String text, final CertificateContentProvider.GroupMode mode) {
        MenuItem item = new MenuItem(parent, 16);
        item.setText(text);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SecurityPreferencePage.this.cProvider.setGroupMode(mode);
                SecurityPreferencePage.this.certViewer.refresh();
                SecurityPreferencePage.this.updateMenu();
            }
        });
        return item;
    }

    private ICertificateHandle[] getSelectedCertificates() {
        ArrayList<ICertificateHandle> result = new ArrayList<ICertificateHandle>();
        ISelection selection = this.certViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            for (Object next : (IStructuredSelection)selection) {
                Object value;
                if (next instanceof ICertificateHandle && !result.contains(next)) {
                    result.add((ICertificateHandle)next);
                    continue;
                }
                if (!(next instanceof Map.Entry) || !((value = ((Map.Entry)next).getValue()) instanceof List)) continue;
                for (Object o : (List)value) {
                    if (!(o instanceof ICertificateHandle) || result.contains(o)) continue;
                    result.add((ICertificateHandle)o);
                }
            }
        }
        return result.toArray(new ICertificateHandle[result.size()]);
    }

    private static Image getImage(String path) {
        Image result = images.get(path);
        if (result == null) {
            result = SecurityPreferencePage.loadImage(path);
            images.put(path, result);
        }
        return result;
    }

    private static Image loadImage(String path) {
        URL url = Activator.getDefault().getBundle().getEntry(path);
        ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)url);
        return descriptor.createImage();
    }
}

