/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.preference;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridModelEvent;
import eu.geclipse.core.model.IGridModelListener;
import eu.geclipse.core.model.IGridProject;
import eu.geclipse.core.model.IVirtualOrganization;
import eu.geclipse.core.model.IVoManager;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.comparators.TableColumnComparator;
import eu.geclipse.ui.dialogs.ProblemDialog;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.internal.preference.Messages;
import eu.geclipse.ui.internal.wizards.VoImportWizard;
import eu.geclipse.ui.listeners.TableColumnListener;
import eu.geclipse.ui.wizards.wizardselection.ExtPointWizardSelectionListPage;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VoPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IGridModelListener {
    CheckboxTableViewer voViewer;
    private Button addButton;
    private Button importButton;
    private Button removeButton;
    private Button editButton;

    public VoPreferencePage() {
        this.setDescription(Messages.getString("VoPreferencePage.description"));
    }

    public void dispose() {
        GridModel.getVoManager().removeGridModelListener((IGridModelListener)this);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.noDefaultAndApplyButton();
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        Label voLabel = new Label(parent, 0);
        voLabel.setText(Messages.getString("VoPreferencePage.vo_list_label"));
        GridData gData = new GridData();
        gData.horizontalSpan = 2;
        gData.grabExcessHorizontalSpace = true;
        voLabel.setLayoutData((Object)gData);
        Table voTable = new Table(parent, 67618);
        voTable.setHeaderVisible(true);
        voTable.setLinesVisible(true);
        gData = new GridData(1808);
        gData.horizontalSpan = 1;
        gData.grabExcessHorizontalSpace = true;
        gData.grabExcessVerticalSpace = true;
        gData.widthHint = 200;
        gData.heightHint = 100;
        voTable.setLayoutData((Object)gData);
        voTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                IVirtualOrganization selectedVo = VoPreferencePage.this.getSelectedVo();
                if (selectedVo != null) {
                    VoPreferencePage.this.editVO(selectedVo);
                }
            }
        });
        voTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0) {
                    VoPreferencePage.this.removeSelectedVOs();
                }
            }
        });
        TableColumn nameColumn = new TableColumn(voTable, 16384);
        nameColumn.setText(Messages.getString("VoPreferencePage.name_column_text"));
        nameColumn.setWidth(100);
        TableColumn typeColumn = new TableColumn(voTable, 0x1000000);
        typeColumn.setText(Messages.getString("VoPreferencePage.type_column_text"));
        typeColumn.setWidth(100);
        final IVoManager manager = GridModel.getVoManager();
        this.voViewer = new CheckboxTableViewer(voTable);
        this.voViewer.setLabelProvider((IBaseLabelProvider)new VoLabelProvider());
        this.voViewer.setContentProvider((IContentProvider)new VoContentProvider());
        TableColumnListener columnListener = new TableColumnListener((TableViewer)this.voViewer);
        nameColumn.addSelectionListener((SelectionListener)columnListener);
        typeColumn.addSelectionListener((SelectionListener)columnListener);
        voTable.setSortColumn(nameColumn);
        voTable.setSortDirection(128);
        this.voViewer.setComparator((ViewerComparator)new TableColumnComparator(nameColumn));
        this.voViewer.setInput((Object)manager);
        this.voViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                VoPreferencePage.this.updateButtons();
            }
        });
        manager.addGridModelListener((IGridModelListener)this);
        IVirtualOrganization defaultVo = (IVirtualOrganization)manager.getDefault();
        if (defaultVo != null) {
            this.voViewer.setCheckedElements(new Object[]{defaultVo});
        }
        this.voViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (element instanceof IVirtualOrganization) {
                    IVirtualOrganization vo = (IVirtualOrganization)element;
                    try {
                        if (!event.getChecked()) {
                            manager.setDefault(null);
                        } else {
                            VoPreferencePage.this.voViewer.setCheckedElements(new Object[]{vo});
                            VoPreferencePage.this.voViewer.refresh();
                            manager.setDefault((IGridElement)vo);
                        }
                    }
                    catch (ProblemException pExc) {
                        Activator.logException(pExc);
                    }
                }
            }
        });
        Composite buttons = new Composite(parent, 0);
        gData = new GridData(2);
        gData.horizontalSpan = 1;
        buttons.setLayoutData((Object)gData);
        GridLayout gLayout = new GridLayout(1, false);
        gLayout.marginHeight = 0;
        gLayout.marginWidth = 0;
        buttons.setLayout((Layout)gLayout);
        this.addButton = new Button(buttons, 8);
        this.addButton.setText(Messages.getString("VoPreferencePage.add_button"));
        gData = new GridData(768);
        this.addButton.setLayoutData((Object)gData);
        this.importButton = new Button(buttons, 8);
        this.importButton.setText(Messages.getString("VoPreferencePage.import_button"));
        gData = new GridData(768);
        this.importButton.setLayoutData((Object)gData);
        this.editButton = new Button(buttons, 8);
        this.editButton.setText(Messages.getString("VoPreferencePage.edit_button"));
        gData = new GridData(768);
        this.editButton.setLayoutData((Object)gData);
        this.removeButton = new Button(buttons, 8);
        this.removeButton.setText(Messages.getString("VoPreferencePage.remove_button"));
        gData = new GridData(768);
        this.removeButton.setLayoutData((Object)gData);
        Label separator = new Label(buttons, 0);
        separator.setVisible(false);
        gData = new GridData();
        gData.horizontalAlignment = 4;
        gData.heightHint = 4;
        separator.setLayoutData((Object)gData);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VoPreferencePage.this.editVO(null);
            }
        });
        this.importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VoPreferencePage.this.importVOs();
            }
        });
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IVirtualOrganization selectedVo = VoPreferencePage.this.getSelectedVo();
                if (selectedVo != null) {
                    VoPreferencePage.this.editVO(selectedVo);
                }
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VoPreferencePage.this.removeSelectedVOs();
            }
        });
        this.updateButtons();
        return parent;
    }

    public IVirtualOrganization getSelectedVo() {
        IVirtualOrganization selectedVo = null;
        IStructuredSelection selection = (IStructuredSelection)this.voViewer.getSelection();
        Object obj = selection.getFirstElement();
        if (obj instanceof IVirtualOrganization) {
            selectedVo = (IVirtualOrganization)obj;
        }
        return selectedVo;
    }

    public List<IVirtualOrganization> getSelectedVos() {
        IStructuredSelection selection = (IStructuredSelection)this.voViewer.getSelection();
        List selectionList = selection.toList();
        ArrayList<IVirtualOrganization> result = new ArrayList<IVirtualOrganization>();
        for (Object element : selectionList) {
            if (!(element instanceof IVirtualOrganization)) continue;
            IVirtualOrganization vo = (IVirtualOrganization)element;
            result.add(vo);
        }
        return result;
    }

    protected void editVO(final IVirtualOrganization vo) {
        URL imgUrl = Activator.getDefault().getBundle().getEntry("icons/wizban/vo_wiz.gif");
        Wizard wizard = new Wizard(){

            public void addPages() {
                ExtPointWizardSelectionListPage page = new ExtPointWizardSelectionListPage("pagename", "eu.geclipse.ui.newVoWizards", Messages.getString("VoPreferencePage.create_new_vo"), Messages.getString("VoPreferencePage.create_new_vo_long"), Messages.getString("VoPreferencePage.no_vo_providers"));
                page.setInitData(vo);
                if (vo != null) {
                    page.setPreselectedId(vo.getWizardId(), true);
                }
                this.addPage((IWizardPage)page);
            }

            public boolean performFinish() {
                return false;
            }
        };
        wizard.setForcePreviousAndNextButtons(true);
        wizard.setNeedsProgressMonitor(true);
        wizard.setWindowTitle(Messages.getString("VoPreferencePage.create_new_vo"));
        wizard.setDefaultPageImageDescriptor(ImageDescriptor.createFromURL((URL)imgUrl));
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.open();
        this.checkDefaultVo();
    }

    protected void importVOs() {
        try {
            VoImportWizard wizard = new VoImportWizard();
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            dialog.open();
            this.checkDefaultVo();
        }
        catch (ProblemException problemException) {
            ProblemDialog.openProblem(this.getShell(), Messages.getString("VoPreferencePage.couldNotOpenImportVoWizard"), Messages.getString("VoPreferencePage.couldNotOpenImportVoWizard"), problemException);
        }
    }

    protected void removeSelectedVOs() {
        boolean confirm;
        List<IVirtualOrganization> vos = this.getSelectedVos();
        if (!vos.isEmpty() && (confirm = MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("VoPreferencePage.delete_vos"), (String)Messages.getString("VoPreferencePage.really_delete_vos")))) {
            IGridElement[] projectElements = new IGridElement[]{};
            try {
                projectElements = GridModel.getRoot().getChildren(null);
            }
            catch (ProblemException problemException) {}
            IVoManager manager = GridModel.getVoManager();
            IGridProject igp = null;
            for (IVirtualOrganization vo : vos) {
                boolean used = false;
                IGridElement[] iGridElementArray = projectElements;
                int n = projectElements.length;
                int n2 = 0;
                while (n2 < n) {
                    IGridElement element = iGridElementArray[n2];
                    igp = (IGridProject)element;
                    IVirtualOrganization realVo = null;
                    IVirtualOrganization projectVo = igp.getVO();
                    if (projectVo != null && (realVo = (IVirtualOrganization)projectVo.getAdapter(IVirtualOrganization.class)) != null && vo == realVo) {
                        used = true;
                        break;
                    }
                    ++n2;
                }
                if (used) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("VoPreferencePage.error"), (String)String.format(Messages.getString("VoPreferencePage.vo_in_use"), vo.getName(), igp.getName()));
                    continue;
                }
                try {
                    manager.delete((IGridElement)vo);
                }
                catch (ProblemException pExc) {
                    ProblemDialog.openProblem(this.getShell(), Messages.getString("VoPreferencePage.error"), String.valueOf(Messages.getString("VoPreferencePage.delete_vo_failed")) + " " + vo.getName(), pExc);
                }
            }
            this.checkDefaultVo();
            this.updateButtons();
        }
    }

    private void checkDefaultVo() {
        IVoManager manager = GridModel.getVoManager();
        if (manager.getChildCount() > 0 && !this.voViewer.getControl().isDisposed()) {
            Object[] checked = new Object[]{manager.getDefault()};
            this.voViewer.setCheckedElements(checked);
        }
    }

    protected void updateButtons() {
        ISelection selection = this.voViewer.getSelection();
        boolean selectionAvailable = !selection.isEmpty();
        this.addButton.setEnabled(true);
        this.importButton.setEnabled(true);
        this.removeButton.setEnabled(selectionAvailable);
        this.editButton.setEnabled(selectionAvailable);
    }

    public void gridModelChanged(IGridModelEvent source) {
        this.voViewer.refresh();
        IVoManager manager = GridModel.getVoManager();
        IGridElement defaultVo = manager.getDefault();
        if (defaultVo != null) {
            this.voViewer.setCheckedElements(new Object[]{defaultVo});
        }
        this.updateButtons();
    }

    public boolean performOk() {
        try {
            GridModel.getVoManager().saveElements();
        }
        catch (ProblemException pExc) {
            Activator.logException(pExc);
        }
        return super.performOk();
    }

    protected void performDefaults() {
        try {
            GridModel.getVoManager().loadElements();
        }
        catch (ProblemException pExc) {
            Activator.logException(pExc);
        }
        super.performDefaults();
    }

    static class VoContentProvider
    implements IStructuredContentProvider {
        private Shell shell;

        VoContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] result = null;
            if (inputElement instanceof IVoManager) {
                IVoManager manager = (IVoManager)inputElement;
                try {
                    result = manager.getChildren(null);
                    Arrays.sort(result, new Comparator<IGridElement>(){

                        @Override
                        public int compare(IGridElement vo1, IGridElement vo2) {
                            return vo1.getName().compareTo(vo2.getName());
                        }
                    });
                }
                catch (ProblemException pExc) {
                    if (this.shell != null) {
                        ProblemDialog.openProblem(this.shell, Messages.getString("VoPreferencePage.content_provider_problem"), Messages.getString("VoPreferencePage.query_vo_failed"), pExc);
                    }
                    Activator.logException(pExc);
                }
            }
            return result;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (viewer != null) {
                this.shell = viewer.getControl().getShell();
            }
        }
    }

    static class VoLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        VoLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String text = null;
            if (element instanceof IVirtualOrganization) {
                switch (columnIndex) {
                    case 0: {
                        text = ((IVirtualOrganization)element).getName();
                        break;
                    }
                    case 1: {
                        text = ((IVirtualOrganization)element).getTypeName();
                    }
                }
            }
            return text;
        }
    }
}

