/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.transfer;

import eu.geclipse.core.filesystem.GEclipseURI;
import eu.geclipse.core.filesystem.TransferInformation;
import eu.geclipse.core.filesystem.TransferManager;
import eu.geclipse.core.model.IGridConnection;
import eu.geclipse.core.model.IGridConnectionElement;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.ITransferInformation;
import eu.geclipse.core.reporting.IProblem;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.dialogs.ProblemDialog;
import eu.geclipse.ui.internal.transfer.Messages;
import java.net.URI;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class GridElementTransferOperation
extends Job {
    private IGridContainer globalTarget;
    private IGridElement[] elements;
    private TransferInformation transferOperation;
    private boolean move;
    private OverwriteMode overwriteMode = OverwriteMode.ASK;

    public GridElementTransferOperation(IGridElement[] elements, IGridContainer target, boolean move) {
        super(Messages.getString("GridElementTransferOperation.transfer_name"));
        this.globalTarget = target;
        this.elements = elements;
        this.move = move;
    }

    public GridElementTransferOperation(TransferInformation transferOperation) {
        super(Messages.getString("GridElementTransferOperation.transfer_name"));
        this.transferOperation = transferOperation;
    }

    public IGridContainer getTarget() {
        return this.globalTarget;
    }

    public IStatus run(IProgressMonitor monitor) {
        IProgressMonitor localMonitor = monitor == null ? new NullProgressMonitor() : monitor;
        MultiStatus status = new MultiStatus("eu.geclipse.ui", 0, Messages.getString("GridElementTransferOperation.op_status"), null);
        if (this.transferOperation != null) {
            localMonitor.beginTask(Messages.getString("GridElementTransferOperation.transfering_element_progress"), 1);
            String sourceName = new Path(this.transferOperation.getSource().toURI().getPath()).lastSegment();
            TransferParams data = new TransferParams(this.transferOperation.getSource(), null, this.transferOperation.getDestination(), this.transferOperation.getDestination().getChild(sourceName), localMonitor);
            try {
                this.checkExistingTarget(data);
            }
            catch (ProblemException exc) {
                String msg = String.format(Messages.getString("GridElementTransferOperation.errCannotCopyFile"), sourceName);
                data.status = new Status(4, "eu.geclipse.ui", msg, (Throwable)exc);
                status.merge(data.status);
            }
            if (localMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (data.status.isOK()) {
                IStatus resStatus = TransferManager.getManager().resumeTransfer((ITransferInformation)this.transferOperation, localMonitor);
                status.merge(resStatus);
            }
        } else {
            localMonitor.beginTask(Messages.getString("GridElementTransferOperation.transfering_element_progress"), this.elements.length + 1);
            int i = 0;
            while (i < this.elements.length) {
                localMonitor.subTask(this.elements[i].getName());
                SubProgressMonitor subMonitor = new SubProgressMonitor(localMonitor, 1);
                IStatus tempStatus = this.transferElement(this.elements[i], this.globalTarget, (IProgressMonitor)subMonitor);
                if (!tempStatus.isOK()) {
                    status.merge(tempStatus);
                }
                if (localMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (this.move) {
                    IGridContainer parent = this.elements[i].getParent();
                    boolean refresh = true;
                    int j = i + 1;
                    while (j < this.elements.length) {
                        if (this.elements[j].getParent().equals(parent)) {
                            refresh = false;
                            break;
                        }
                        ++j;
                    }
                    if (refresh) {
                        try {
                            parent.refresh(null);
                        }
                        catch (ProblemException pExc) {
                            status.merge(pExc.getStatus());
                        }
                    }
                }
                ++i;
            }
            try {
                if (status.isOK()) {
                    if (this.globalTarget.getResource() instanceof IContainer) {
                        this.globalTarget.refresh((IProgressMonitor)new SubProgressMonitor(localMonitor, 1));
                    } else {
                        this.globalTarget.getParent().refresh((IProgressMonitor)new SubProgressMonitor(localMonitor, 1));
                        IGridElement[] iGridElementArray = this.globalTarget.getParent().getChildren((IProgressMonitor)new SubProgressMonitor(localMonitor, 1));
                        int n = iGridElementArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IGridElement elem = iGridElementArray[n2];
                            if (elem.getResource() instanceof IContainer && elem instanceof IGridContainer) {
                                ((IGridContainer)elem).refresh((IProgressMonitor)new SubProgressMonitor(localMonitor, 1));
                            }
                            ++n2;
                        }
                    }
                }
            }
            catch (ProblemException pExc) {
                status.merge(pExc.getStatus());
            }
        }
        if (status.getSeverity() == 4) {
            this.showProblemDialog(status);
        }
        return Status.OK_STATUS;
    }

    private void showProblemDialog(final MultiStatus status) {
        IWorkbenchWindow[] windows;
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null && (windows = workbench.getWorkbenchWindows()).length > 0) {
            window = windows[0];
        }
        if (window != null) {
            final Shell shell = window.getShell();
            shell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    ProblemDialog.openProblem(shell, Messages.getString("GridElementTransferOperation.problemDialogTitle"), status.getChildren().length == 1 ? Messages.getString("GridElementTransferOperation.msgElementCannotBeCopied") : Messages.getString("GridElementTransferOperation.msgElementsCannotBeCopied"), GridElementTransferOperation.this.createProblemException(status));
                }
            });
        }
    }

    ProblemException createProblemException(MultiStatus multiStatus) {
        ProblemException problemException = null;
        ArrayList<IStatus> failedStatuses = new ArrayList<IStatus>();
        IStatus[] iStatusArray = multiStatus.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus childStatus = iStatusArray[n2];
            if (childStatus.getSeverity() != 0) {
                failedStatuses.add(childStatus);
            }
            ++n2;
        }
        Throwable firstException = failedStatuses.size() > 0 ? ((IStatus)failedStatuses.get(0)).getException() : null;
        problemException = new ProblemException("eu.geclipse.ui.problem.tranfserOperationFailed", firstException, "eu.geclipse.ui");
        IProblem problem = problemException.getProblem();
        for (IStatus status : failedStatuses) {
            String msg = status.getMessage();
            if (status.getException() != null && !msg.equals(status.getException().getMessage())) {
                msg = String.valueOf(msg) + "\n" + status.getException().getMessage();
            }
            problem.addReason(msg);
        }
        return problemException;
    }

    private IStatus copy(IFileStore from, IFileStore to, IProgressMonitor monitor) {
        TransferParams data = new TransferParams(from, null, to, to.getChild(from.getName()), monitor);
        try {
            this.checkExistingTarget(data);
        }
        catch (ProblemException exc) {
            String msg = String.format(Messages.getString("GridElementTransferOperation.errCannotCopyFile"), from.getName());
            data.status = new Status(4, "eu.geclipse.ui", msg, (Throwable)exc);
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (data.status.isOK()) {
            data.status = TransferManager.getManager().startTransfer(from, to, this.move, monitor);
        }
        return data.status;
    }

    private IStatus transferElement(IGridElement element, IGridContainer target, IProgressMonitor monitor) {
        IStatus status;
        block22: {
            status = Status.OK_STATUS;
            monitor.beginTask(String.valueOf(Messages.getString("GridElementTransferOperation.transfering_progress")) + element.getName(), 10);
            if (!(element instanceof IGridConnectionElement) && !(target instanceof IGridConnectionElement)) {
                IResource sResource = element.getResource();
                IResource tResource = target.getResource();
                IPath destination = tResource.getFullPath().append(sResource.getName());
                try {
                    if (this.move) {
                        sResource.move(destination, 0, monitor);
                        break block22;
                    }
                    sResource.copy(destination, 0, monitor);
                }
                catch (CoreException cExc) {
                    status = new Status(4, "eu.geclipse.ui", 0, Messages.getString("GridElementTransferOperation.copy_resources_failed"), (Throwable)cExc);
                }
            } else if (element instanceof IGridConnection && !(target instanceof IGridConnectionElement)) {
                try {
                    IGridConnection connection = (IGridConnection)element;
                    URI uri = ((IGridConnection)element).getConnectionFileStore().toURI();
                    IResource sResource = element.getResource();
                    IContainer tFolder = (IContainer)target.getResource();
                    if (connection.isFolder()) {
                        IFolder folder = tFolder.getFolder((IPath)new Path(sResource.getName()));
                        folder.createLink(uri, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
                    } else {
                        IFile file = tFolder.getFile((IPath)new Path(sResource.getName()));
                        file.createLink(uri, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
                    }
                    if (this.move) {
                        sResource.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
                    }
                }
                catch (CoreException cExc) {
                    status = new Status(4, "eu.geclipse.ui", 0, Messages.getString("GridElementTransferOperation.copy_linked_resource_failed"), (Throwable)cExc);
                }
            } else {
                IFileStore inStore = null;
                IFileStore outStore = null;
                try {
                    inStore = this.getFileStore(element);
                }
                catch (CoreException cExc) {
                    status = new Status(4, "eu.geclipse.ui", 0, String.format(Messages.getString("GridElementTransferOperation.unable_get_filestore"), element.getName()), (Throwable)cExc);
                }
                if (status.isOK()) {
                    try {
                        outStore = this.getFileStore((IGridElement)target);
                    }
                    catch (CoreException cExc) {
                        status = new Status(4, "eu.geclipse.ui", 0, String.format(Messages.getString("GridElementTransferOperation.unable_get_filestore"), target.getName()), (Throwable)cExc);
                    }
                }
                if (status.isOK()) {
                    try {
                        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, this.move ? 9 : 10);
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        status = this.copy(inStore, outStore, (IProgressMonitor)subMonitor);
                    }
                    finally {
                        monitor.done();
                    }
                }
            }
        }
        return status;
    }

    private IFileStore getFileStore(IGridElement element) throws CoreException {
        IFileStore result = null;
        result = element instanceof IGridConnectionElement ? ((IGridConnectionElement)element).getConnectionFileStore() : element.getFileStore();
        return result;
    }

    private void checkExistingTarget(TransferParams data) throws ProblemException {
        IFileInfo targetInfo = null;
        GEclipseURI geclURI = new GEclipseURI(data.targetFile.toURI());
        try {
            targetInfo = EFS.getStore((URI)geclURI.toSlaveURI()).fetchInfo(0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ProblemException problemExc) {
            throw new ProblemException("eu.geclipse.core.filesystem.serverCouldNotBeContacted", String.format("Could not contact server to fetch file info for %s", data.targetFile.toURI().toString()), (Throwable)problemExc, "eu.geclipse.ui");
        }
        catch (CoreException exc) {
            throw new ProblemException("eu.geclipse.core.problem.net.malformedURL", String.format("URL %s is malformed or EFS using scheme %s doesn't exist", data.targetFile.toURI().toString(), geclURI.getSlaveScheme()), (Throwable)exc, "eu.geclipse.ui");
        }
        if (targetInfo != null && targetInfo.exists()) {
            if (data.sourceFile.toURI().equals(data.targetFile.toURI())) {
                String msg = String.format(Messages.getString("GridElementTransferOperation.errSourceAndTargetAreTheSame"), data.sourceFile.getName());
                throw new ProblemException("eu.geclipse.ui.problem.fileCannotOverwriteItself", msg, "eu.geclipse.ui");
            }
            switch (this.overwriteMode) {
                case ASK: {
                    this.askOverwrite(data, targetInfo);
                    break;
                }
                case OVERWRITE_ALL: {
                    this.deleteTarget(data);
                    break;
                }
                case IGNORE_ALL: {
                    this.ignoreTransfer(data);
                }
            }
        }
    }

    private void askOverwrite(TransferParams data, IFileInfo targetInfo) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        class Runner
        implements Runnable {
            int exitCode;
            private final Display display;
            private final /* synthetic */ TransferParams val$data;
            private final /* synthetic */ IFileInfo val$targetInfo;

            Runner(Display display, TransferParams transferParams, IFileInfo iFileInfo) {
                this.val$data = transferParams;
                this.val$targetInfo = iFileInfo;
                this.display = display;
            }

            public void run() {
                Shell shell = null;
                String[] labels = new String[]{Messages.getString("GridElementTransferOperation.buttonYes"), Messages.getString("GridElementTransferOperation.buttonYesAll"), Messages.getString("GridElementTransferOperation.buttonNo"), Messages.getString("GridElementTransferOperation.buttonNoAll"), Messages.getString("GridElementTransferOperation.buttonCancel")};
                if (this.display != null) {
                    shell = this.display.getActiveShell();
                }
                String message = String.format(Messages.getString("GridElementTransferOperation.overwriteMsg"), this.val$data.targetFile.getName(), GridElementTransferOperation.this.formatURI(this.val$data.targetFile.toURI()), GridElementTransferOperation.this.formatDate(this.val$targetInfo.getLastModified()), GridElementTransferOperation.this.formatURI(this.val$data.sourceFile.toURI()), "");
                MessageDialog dialog = new MessageDialog(shell, Messages.getString("GridElementTransferOperation.overwriteTitle"), null, message, 3, labels, 0);
                this.exitCode = dialog.open();
            }
        }
        Runner runner = new Runner(display, data, targetInfo);
        display.syncExec((Runnable)runner);
        switch (runner.exitCode) {
            case 0: {
                this.deleteTarget(data);
                break;
            }
            case 1: {
                this.overwriteMode = OverwriteMode.OVERWRITE_ALL;
                this.deleteTarget(data);
                break;
            }
            case 2: {
                this.ignoreTransfer(data);
                break;
            }
            case 3: {
                this.overwriteMode = OverwriteMode.IGNORE_ALL;
                this.ignoreTransfer(data);
                break;
            }
            case 4: {
                data.status = Status.CANCEL_STATUS;
                data.monitor.setCanceled(true);
            }
        }
    }

    String formatURI(URI uri) {
        String uriString = "";
        GEclipseURI gUri = new GEclipseURI(uri);
        URI slaveURI = gUri.toSlaveURI();
        uriString = slaveURI == null ? uri.toString() : slaveURI.toString();
        return uriString;
    }

    String formatDate(long lastModified) {
        String dateString = "";
        if (lastModified != 0L) {
            dateString = DateFormat.getDateTimeInstance().format(new Date(lastModified));
        }
        return dateString;
    }

    private void deleteTarget(TransferParams data) {
        String filename = data.targetFile.getName();
        try {
            data.monitor.subTask(String.format(Messages.getString("GridElementTransferOperation.deletingTarget"), filename));
            data.targetFile.delete(0, data.monitor);
            if (!data.monitor.isCanceled()) {
                data.targetFile = data.targetDirectory.getChild(filename);
            }
        }
        catch (CoreException exception) {
            data.status = new Status(4, "eu.geclipse.ui", String.format(Messages.getString("GridElementTransferOperation.errCannotDeleteTarget"), data.targetFile.getName()), (Throwable)exception);
        }
    }

    private void ignoreTransfer(TransferParams data) {
        data.status = new Status(1, "eu.geclipse.ui", Messages.getString("GridElementTransferOperation.targetExists"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum OverwriteMode {
        ASK,
        OVERWRITE_ALL,
        IGNORE_ALL;

    }

    private static class TransferParams {
        IFileStore sourceFile;
        IFileStore targetDirectory;
        IFileStore targetFile;
        IFileInfo sourceFileInfo;
        IStatus status = Status.OK_STATUS;
        IProgressMonitor monitor;

        TransferParams(IFileStore sourceFile, IFileInfo sourceFileInfo, IFileStore toDirectory, IFileStore to, IProgressMonitor monitor) {
            this.sourceFile = sourceFile;
            this.targetDirectory = toDirectory;
            this.targetFile = to;
            this.sourceFileInfo = sourceFileInfo;
            this.monitor = monitor;
        }
    }
}

