/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.transfer;

import eu.geclipse.core.model.IGridConnection;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridJob;
import eu.geclipse.ui.internal.transfer.GridElementTransferOperation;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class SelectionTransferDropAdapter
implements TransferDropTargetListener {
    private IGridContainer lastTarget;
    private int lastDetail;

    public Transfer getTransfer() {
        return LocalSelectionTransfer.getInstance();
    }

    public boolean isEnabled(DropTargetEvent event) {
        IGridContainer target = this.getTarget(event);
        return target != null;
    }

    public void dragEnter(DropTargetEvent event) {
        this.lastTarget = this.getTarget(event);
        this.lastDetail = event.detail;
        this.validateDrop(event);
    }

    public void dragLeave(DropTargetEvent event) {
        this.lastTarget = null;
        this.lastDetail = 0;
    }

    public void dragOperationChanged(DropTargetEvent event) {
        this.lastDetail = event.detail;
        this.validateDrop(event);
        this.computeFeedback(event);
    }

    public void dragOver(DropTargetEvent event) {
        IGridContainer newTarget = this.getTarget(event);
        if (newTarget != this.lastTarget) {
            this.lastTarget = newTarget;
            this.validateDrop(event);
        }
        this.computeFeedback(event);
    }

    public void drop(DropTargetEvent event) {
        IGridContainer target = this.getTarget(event);
        IGridElement[] elements = this.getElements();
        GridElementTransferOperation op = null;
        switch (event.detail) {
            case 1: {
                op = new GridElementTransferOperation(elements, target, false);
                break;
            }
            case 2: {
                op = new GridElementTransferOperation(elements, target, true);
            }
        }
        if (op != null) {
            op.setUser(true);
            op.setPriority(30);
            op.schedule();
        } else {
            event.detail = 0;
        }
    }

    public void dropAccept(DropTargetEvent event) {
        this.lastTarget = this.getTarget(event);
        this.validateDrop(event);
        this.lastDetail = event.detail;
    }

    protected void computeFeedback(DropTargetEvent event) {
        event.feedback = 25;
    }

    protected IGridElement[] getElements() {
        IGridElement[] result = null;
        ISelection selection = LocalSelectionTransfer.getInstance().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sSelection = (IStructuredSelection)selection;
            Iterator iter = sSelection.iterator();
            ArrayList<IGridElement> elements = new ArrayList<IGridElement>();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof IGridElement)) continue;
                elements.add((IGridElement)obj);
            }
            if (elements.size() == sSelection.size()) {
                result = elements.toArray(new IGridElement[elements.size()]);
            }
        }
        return result;
    }

    protected IGridContainer getTarget(DropTargetEvent event) {
        Object data;
        IGridContainer result = null;
        Widget item = event.item;
        if (item != null && (data = item.getData()) != null && data instanceof IGridContainer) {
            result = (IGridContainer)data;
        }
        return result;
    }

    protected void validateDrop(DropTargetEvent event) {
        int ops = this.computeDropOperations(event);
        event.detail = (ops & this.lastDetail) != 0 ? this.lastDetail : ((ops & 0x10) != 0 ? 16 : ((ops & 2) != 0 ? 2 : ((ops & 1) != 0 ? 1 : 0)));
    }

    protected int computeDropOperations(DropTargetEvent event) {
        IGridElement[] elements;
        int ops = 0;
        if (this.lastTarget != null && (elements = this.getElements()) != null && elements.length > 0) {
            ops = event.operations;
            IGridElement[] iGridElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IGridElement element = iGridElementArray[n2];
                if ((ops &= this.computeDropOperations(this.lastTarget, element)) == 0) break;
                ++n2;
            }
        }
        return ops;
    }

    protected int computeDropOperations(IGridContainer target, IGridElement element) {
        int result = 19;
        if (target == element || target == element.getParent() || !target.canContain(element) || this.isGridJob(target)) {
            result = 0;
        } else {
            boolean tLocal = this.isLocal((IGridElement)target);
            boolean eLocal = this.isLocal(element);
            if (!tLocal || !eLocal) {
                if (!tLocal && !eLocal) {
                    IGridElement eParent;
                    IGridElement tParent = this.findLastRemoteElement((IGridElement)target);
                    if (tParent != (eParent = this.findLastRemoteElement(element))) {
                        result = 1;
                    }
                } else if (!eLocal) {
                    IGridElement eParent = this.findLastRemoteElement(element);
                    if (eParent != element) {
                        result = 1;
                    }
                } else {
                    result = 1;
                }
            }
        }
        return result;
    }

    private IGridElement findLastRemoteElement(IGridElement element) {
        IGridElement result = element;
        IGridContainer parent = element.getParent();
        while (parent != null && !parent.isLocal()) {
            result = parent;
            parent = parent.getParent();
        }
        return result;
    }

    private boolean isLocal(IGridElement element) {
        boolean local = false;
        if (element.isLocal()) {
            local = true;
        } else if (element instanceof IGridConnection) {
            IGridConnection connection = (IGridConnection)element;
            try {
                IFileStore fileStore = connection.getConnectionFileStore();
                if (fileStore != null) {
                    local = "file".equals(fileStore.getFileSystem().getScheme());
                }
            }
            catch (CoreException coreException) {}
        }
        return local;
    }

    private boolean isGridJob(IGridContainer element) {
        boolean isGridJob = false;
        IGridContainer currentElement = element;
        while (currentElement != null && !isGridJob) {
            isGridJob = currentElement instanceof IGridJob;
            currentElement = currentElement.getParent();
        }
        return isGridJob;
    }
}

