/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.transfer;

import eu.geclipse.core.filesystem.GEclipseURI;
import eu.geclipse.core.filesystem.TransferInformation;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransferResumeDialog
extends IconAndMessageDialog {
    List<TransferInformation> operationsToResume = new ArrayList<TransferInformation>();
    private List<TransferInformation> operations;
    private CheckboxTableViewer tableViewer;

    protected TransferResumeDialog(Shell parentShell, List<TransferInformation> operations) {
        super(parentShell);
        this.setShellStyle(3312);
        this.operations = operations;
        this.message = "Following transfers were not completed. Select transfers you want to resume and press Resume. All transfers which were not selected to resume will be abandoned";
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Transfer resuming");
    }

    protected Control createDialogArea(Composite parent) {
        Composite mainComp = new Composite(parent, 0);
        mainComp.setLayout((Layout)new GridLayout(1, false));
        mainComp.setLayoutData((Object)new GridData(1808));
        Composite msgComp = new Composite(mainComp, 2048);
        msgComp.setLayout((Layout)new GridLayout(2, false));
        msgComp.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.createMessageArea(msgComp);
        Composite composite = (Composite)super.createDialogArea(mainComp);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        Group group = new Group(composite, 8);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setText("Pending transfers");
        GridData gData = new GridData(768);
        gData.grabExcessHorizontalSpace = true;
        gData.heightHint = 150;
        gData.verticalIndent = 20;
        group.setLayoutData((Object)gData);
        int style = 2852;
        Table table = new Table((Composite)group, style);
        gData = new GridData(4, 4, true, false);
        table.setLayoutData((Object)gData);
        table.setHeaderVisible(true);
        TableColumn checkCol = new TableColumn(table, 0x1000000);
        checkCol.setWidth(20);
        TableColumn nameCol = new TableColumn(table, 0x1000000);
        nameCol.setText("Name");
        nameCol.setWidth(80);
        TableColumn sizeCol = new TableColumn(table, 16384);
        sizeCol.setText("Size");
        sizeCol.setWidth(50);
        TableColumn fromCol = new TableColumn(table, 16384);
        fromCol.setText("From");
        fromCol.setWidth(350);
        TableColumn toCol = new TableColumn(table, 16384);
        toCol.setText("To");
        toCol.setWidth(350);
        this.tableViewer = new CheckboxTableViewer(table);
        this.tableViewer.setContentProvider((IContentProvider)new TransferContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TransferLabelProvider());
        if (this.operations != null && this.operations.size() > 0) {
            this.tableViewer.setInput(this.operations);
            for (TransferInformation op : this.operations) {
                this.operationsToResume.add(op);
            }
        }
        this.tableViewer.setAllChecked(true);
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    Object obj = event.getElement();
                    if (obj instanceof TransferInformation) {
                        TransferResumeDialog.this.operationsToResume.add((TransferInformation)obj);
                    }
                } else {
                    Object obj = event.getElement();
                    if (obj instanceof TransferInformation) {
                        TransferResumeDialog.this.operationsToResume.remove(obj);
                    }
                }
            }
        });
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Resume selected", true);
        this.createButton(parent, 3, "Abandon all transfers", false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (3 == buttonId) {
            this.noPressed();
        }
    }

    private void noPressed() {
        this.setReturnCode(3);
        this.close();
    }

    public List<TransferInformation> getOperationsToResume() {
        return this.operationsToResume;
    }

    protected Image getImage() {
        return this.getInfoImage();
    }

    class TransferContentProvider
    implements IStructuredContentProvider {
        TransferContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<TransferInformation> result = new ArrayList<TransferInformation>();
            if (inputElement instanceof List) {
                for (Object obj : (List)inputElement) {
                    if (!(obj instanceof TransferInformation)) continue;
                    result.add((TransferInformation)obj);
                }
            }
            return result.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class TransferLabelProvider
    implements ITableLabelProvider {
        TransferLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String columnText = "";
            if (element instanceof TransferInformation) {
                TransferInformation operation = (TransferInformation)element;
                String source = "";
                String name = "";
                String destination = "";
                String length = "";
                IFileStore sourceStore = operation.getSource();
                GEclipseURI sourceURI = new GEclipseURI(sourceStore.toURI());
                source = sourceURI.toSlaveURI().toString();
                Path path = new Path(sourceStore.toURI().getPath());
                name = path.lastSegment();
                GEclipseURI destinationURI = new GEclipseURI(operation.getDestination().toURI());
                destination = destinationURI.toSlaveURI().toString();
                long size = operation.getSize();
                if (size / 0x40000000L > 1L) {
                    length = String.valueOf(String.valueOf(size / 0x40000000L)) + " GB";
                } else if (size / 0x100000L > 1L) {
                    length = String.valueOf(String.valueOf(size / 0x100000L)) + " MB";
                } else if (size / 1024L > 1L) {
                    length = String.valueOf(String.valueOf(size / 1024L)) + " KB";
                }
                switch (columnIndex) {
                    case 1: {
                        columnText = name;
                        break;
                    }
                    case 2: {
                        columnText = length;
                        break;
                    }
                    case 3: {
                        columnText = source;
                        break;
                    }
                    case 4: {
                        columnText = destination;
                        break;
                    }
                }
            }
            return columnText;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

