/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.transfer;

import eu.geclipse.core.filesystem.TransferInformation;
import eu.geclipse.core.filesystem.TransferManager;
import eu.geclipse.ui.internal.transfer.GridElementTransferOperation;
import eu.geclipse.ui.internal.transfer.Messages;
import eu.geclipse.ui.internal.transfer.TransferResumeDialog;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class TransferResumer
extends Job {
    public TransferResumer(String name) {
        super(name);
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        TransferManager trManager = TransferManager.getManager();
        List pendingTransfers = trManager.getPendingTransfers();
        if (pendingTransfers.size() > 0) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class Runner
            implements Runnable {
                int exitCode;
                private final Display display;
                private final List<TransferInformation> operations;
                private List<TransferInformation> operationsToResume;

                Runner(Display display, List<TransferInformation> operations) {
                    this.display = display;
                    this.operations = operations;
                }

                @Override
                public void run() {
                    Shell shell = null;
                    String[] stringArray = new String[]{Messages.getString("GridElementTransferOperation.buttonYes"), Messages.getString("GridElementTransferOperation.buttonYesAll"), Messages.getString("GridElementTransferOperation.buttonNo"), Messages.getString("GridElementTransferOperation.buttonNoAll"), Messages.getString("GridElementTransferOperation.buttonCancel")};
                    if (this.display != null) {
                        shell = this.display.getActiveShell();
                    }
                    TransferResumeDialog dialog = new TransferResumeDialog(shell, this.operations);
                    this.exitCode = dialog.open();
                    this.operationsToResume = dialog.getOperationsToResume();
                }

                public List<TransferInformation> getOperationsToResume() {
                    return this.operationsToResume;
                }
            }
            Runner runner = new Runner(display, pendingTransfers);
            display.syncExec((Runnable)runner);
            List<TransferInformation> operationsToResume = runner.getOperationsToResume();
            switch (runner.exitCode) {
                case 0: {
                    for (TransferInformation op : pendingTransfers) {
                        if (operationsToResume.contains(op)) {
                            GridElementTransferOperation gridElementTransferOp = new GridElementTransferOperation(op);
                            gridElementTransferOp.setUser(true);
                            gridElementTransferOp.schedule();
                            continue;
                        }
                        trManager.unregisterTransfer(op.getId());
                    }
                    break;
                }
                case 1: {
                    break;
                }
                case 3: {
                    for (TransferInformation op : pendingTransfers) {
                        trManager.unregisterTransfer(op.getId());
                    }
                    break;
                }
            }
        }
        return status;
    }
}

