/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.wizards;

import eu.geclipse.core.ExtensionManager;
import eu.geclipse.core.security.ICertificateLoader;
import eu.geclipse.ui.internal.wizards.CertificateLoaderContentProvider;
import eu.geclipse.ui.internal.wizards.CertificateLoaderLabelProvider;
import eu.geclipse.ui.widgets.StoredCombo;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;

public class CertificateLoaderSelectionPage
extends WizardPage {
    private StoredCombo uriCombo;
    private TreeViewer certLoaderViewer;
    private Text descriptionText;

    public CertificateLoaderSelectionPage() {
        super("certLoaderPage", "Certificate Repository", null);
        this.setDescription("Select one of the available repositories");
    }

    public void createControl(Composite parent) {
        Composite mainComp = new Composite(parent, 0);
        mainComp.setLayout((Layout)new GridLayout(2, false));
        GridData gData = new GridData(1808);
        mainComp.setLayoutData((Object)gData);
        Label uriLabel = new Label(mainComp, 0);
        uriLabel.setText("URI:");
        uriLabel.setLayoutData((Object)new GridData());
        this.uriCombo = new StoredCombo(mainComp, 0);
        this.uriCombo.setLayoutData(new GridData(4, 2, true, false));
        Label repoLabel = new Label(mainComp, 0);
        repoLabel.setText("Certificate repositories:");
        gData = new GridData();
        gData.horizontalSpan = 2;
        repoLabel.setLayoutData((Object)gData);
        this.certLoaderViewer = new TreeViewer(mainComp, 2820);
        gData = new GridData(4, 4, true, true);
        gData.horizontalSpan = 2;
        gData.heightHint = 150;
        this.certLoaderViewer.getTree().setLayoutData((Object)gData);
        this.certLoaderViewer.setContentProvider((IContentProvider)new CertificateLoaderContentProvider());
        this.certLoaderViewer.setLabelProvider((IBaseLabelProvider)new CertificateLoaderLabelProvider());
        ExtensionManager manager = new ExtensionManager();
        this.certLoaderViewer.setInput((Object)manager.getConfigurationElements("eu.geclipse.core.certificateLoader", "loader"));
        Label descLabel = new Label(mainComp, 0);
        descLabel.setText("Description:");
        gData = new GridData();
        gData.horizontalSpan = 2;
        descLabel.setLayoutData((Object)gData);
        this.descriptionText = new Text(mainComp, 2634);
        gData = new GridData(4, 2, true, false);
        gData.horizontalSpan = 2;
        gData.heightHint = 50;
        this.descriptionText.setLayoutData((Object)gData);
        this.certLoaderViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CertificateLoaderSelectionPage.this.setSelection(event.getSelection());
            }
        });
        this.uriCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CertificateLoaderSelectionPage.this.validatePage();
            }
        });
        this.certLoaderViewer.expandAll();
        TreeItem[] items = this.certLoaderViewer.getTree().getItems();
        while (items != null && items.length > 0) {
            Object data = items[0].getData();
            if (data instanceof IConfigurationElement && "distribution".equals(((IConfigurationElement)data).getName())) {
                this.certLoaderViewer.setSelection((ISelection)new StructuredSelection(data));
                break;
            }
            items = items[0].getItems();
        }
        this.validatePage();
        this.setControl((Control)mainComp);
    }

    public ICertificateLoader getSelectedLoader() {
        ICertificateLoader result = null;
        ISelection selection = this.certLoaderViewer.getSelection();
        IConfigurationElement element = null;
        if (selection instanceof IStructuredSelection) {
            Object object = ((IStructuredSelection)selection).getFirstElement();
            while (object != null && object instanceof IConfigurationElement) {
                element = (IConfigurationElement)object;
                object = element.getParent();
            }
        }
        if (element != null && "loader".equals(element.getName())) {
            try {
                result = (ICertificateLoader)element.createExecutableExtension("class");
            }
            catch (CoreException cExc) {
                this.setErrorMessage("No valid certificate loader found: " + cExc.getLocalizedMessage());
            }
        } else {
            this.setErrorMessage("No valid certificate loader found");
        }
        return result;
    }

    public URI getURI() {
        URI result = null;
        String text = this.uriCombo.getText().trim();
        if (text.length() > 0) {
            try {
                result = new URI(text);
                this.setErrorMessage(null);
                this.setDescription("Select one of the available repositories");
            }
            catch (URISyntaxException uriExc) {
                this.setErrorMessage("Invalid URI: " + uriExc.getLocalizedMessage());
            }
        }
        return result;
    }

    protected void setSelection(ISelection selection) {
        Object element;
        if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof IConfigurationElement) {
            this.setSelection((IConfigurationElement)element);
        }
    }

    protected void validatePage() {
        URI uri = this.getURI();
        ICertificateLoader loader = this.getSelectedLoader();
        this.setPageComplete(uri != null && loader != null);
    }

    private void setSelection(IConfigurationElement element) {
        String url = "";
        String description = "";
        String name = element.getName();
        if ("authority".equals(name)) {
            description = element.getAttribute("description");
        } else if ("distribution".equals(name)) {
            url = element.getAttribute("url");
            description = element.getAttribute("description");
        }
        this.uriCombo.setText(url);
        this.descriptionText.setText(description);
    }
}

