/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.wizards;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class ConfigurationDetailsComposite
extends Composite {
    private Text confNameText;
    private Text confDescText;
    private Text confPrereqText;
    private Tree certTree;
    private Tree voTree;
    private Tree projectTree;

    public ConfigurationDetailsComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        TabFolder tabber = new TabFolder((Composite)this, 0);
        tabber.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createGeneralTab(tabber);
        this.createCertificateTab(tabber);
        this.createVoTab(tabber);
        this.createProjectTab(tabber);
    }

    public void setConfigurator(IConfigurationElement configurator) {
        this.updateGeneralInfo(configurator);
        this.updateCertificateInfo(configurator);
        this.updateVoInfo(configurator);
        this.updateProjectInfo(configurator);
    }

    protected void updateCertificateInfo(IConfigurationElement configurator) {
        this.certTree.removeAll();
        if (configurator != null) {
            IConfigurationElement[] certs = configurator.getChildren("certificates");
            if (certs != null && certs.length > 0) {
                int i = 0;
                while (i < certs.length) {
                    TreeItem certItem = this.createTreeItem(this.certTree, String.format("Certificate Configuration #%d", i + 1), null);
                    this.createTreeItem(certItem, "Loader ID", certs[i].getAttribute("loaderID"));
                    IConfigurationElement[] loaders = certs[i].getChildren();
                    if (loaders != null) {
                        int j = 0;
                        while (j < loaders.length) {
                            if (loaders[j].getName().equals("certificateDistribution")) {
                                String authorityID = loaders[j].getAttribute("authorityID");
                                String distributionID = loaders[j].getAttribute("distributionID");
                                this.createTreeItem(certItem, String.format("Authority ID #%d", j + 1), authorityID);
                                this.createTreeItem(certItem, String.format("Distribution ID #%d", j + 1), distributionID);
                            } else if (loaders[j].getName().equals("certificateURL")) {
                                String url = loaders[j].getAttribute("url");
                                this.createTreeItem(certItem, String.format("URL #%d", j + 1), url);
                            }
                            ++j;
                        }
                    }
                    certItem.setExpanded(true);
                    ++i;
                }
            } else {
                new TreeItem(this.certTree, 0).setText("None");
            }
        } else {
            new TreeItem(this.certTree, 0).setText("N/A");
        }
    }

    protected void updateGeneralInfo(IConfigurationElement configurator) {
        String prereq;
        this.confNameText.setText(this.securelyGetAttribute(configurator, "name"));
        this.confDescText.setText(this.securelyGetAttribute(configurator, "description"));
        String string = prereq = configurator == null ? null : configurator.getAttribute("prerequisites");
        if (prereq == null) {
            this.confPrereqText.setText("N/A");
        } else {
            String[] split = prereq.split(";");
            StringBuffer buffer = new StringBuffer();
            String[] stringArray = split;
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                buffer.append("- " + s + "\n");
                ++n2;
            }
            this.confPrereqText.setText(buffer.toString());
        }
    }

    protected void updateProjectInfo(IConfigurationElement configurator) {
        this.projectTree.removeAll();
        if (configurator != null) {
            IConfigurationElement[] projects = configurator.getChildren("project");
            if (projects != null && projects.length > 0) {
                IConfigurationElement[] iConfigurationElementArray = projects;
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement project = iConfigurationElementArray[n2];
                    TreeItem projectItem = this.createTreeItem(this.projectTree, project.getAttribute("projectName"), null);
                    this.createTreeItem(projectItem, "VO Name", project.getAttribute("voName"));
                    IConfigurationElement[] folders = project.getChildren("projectFolder");
                    TreeItem foldersItem = this.createTreeItem(projectItem, "Project Folders", null);
                    IConfigurationElement[] iConfigurationElementArray2 = folders;
                    int n3 = folders.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement folder = iConfigurationElementArray2[n4];
                        this.createTreeItem(foldersItem, folder.getAttribute("folderID"), folder.getAttribute("folderName"));
                        ++n4;
                    }
                    foldersItem.setExpanded(true);
                    projectItem.setExpanded(true);
                    ++n2;
                }
            } else {
                new TreeItem(this.projectTree, 0).setText("None");
            }
        } else {
            new TreeItem(this.projectTree, 0).setText("N/A");
        }
    }

    protected void updateVoInfo(IConfigurationElement configurator) {
        this.voTree.removeAll();
        if (configurator != null) {
            IConfigurationElement[] vos = configurator.getChildren("vo");
            if (vos != null && vos.length > 0) {
                IConfigurationElement[] iConfigurationElementArray = vos;
                int n = vos.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement vo = iConfigurationElementArray[n2];
                    TreeItem voItem = this.createTreeItem(this.voTree, vo.getAttribute("voName"), null);
                    this.createTreeItem(voItem, "VO Creator", vo.getAttribute("creatorID"));
                    IConfigurationElement[] parameters = vo.getChildren("voParameter");
                    TreeItem paramsItem = this.createTreeItem(voItem, "Parameters", null);
                    IConfigurationElement[] iConfigurationElementArray2 = parameters;
                    int n3 = parameters.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement parameter = iConfigurationElementArray2[n4];
                        IConfigurationElement[] values = parameter.getChildren("parameterValue");
                        if (values != null) {
                            if (values.length == 1) {
                                this.createTreeItem(paramsItem, parameter.getAttribute("key"), values[0].getAttribute("value"));
                            } else if (values.length > 1) {
                                TreeItem paramItem = this.createTreeItem(paramsItem, parameter.getAttribute("key"), null);
                                IConfigurationElement[] iConfigurationElementArray3 = values;
                                int n5 = values.length;
                                int n6 = 0;
                                while (n6 < n5) {
                                    IConfigurationElement value = iConfigurationElementArray3[n6];
                                    this.createTreeItem(paramItem, value.getAttribute("value"), null);
                                    ++n6;
                                }
                                paramItem.setExpanded(true);
                            }
                        }
                        ++n4;
                    }
                    paramsItem.setExpanded(true);
                    voItem.setExpanded(true);
                    ++n2;
                }
            } else {
                new TreeItem(this.voTree, 0).setText("None");
            }
        } else {
            new TreeItem(this.voTree, 0).setText("N/A");
        }
    }

    private void createCertificateTab(TabFolder tabber) {
        TabItem certificatesTab = new TabItem(tabber, 0);
        certificatesTab.setText("Certificates");
        Composite certComp = new Composite((Composite)tabber, 0);
        certComp.setLayout((Layout)new GridLayout(1, false));
        certComp.setLayoutData((Object)new GridData(4, 4, true, true));
        certificatesTab.setControl((Control)certComp);
        Label certLabel = new Label(certComp, 0);
        certLabel.setText("Certificate Configurations");
        certLabel.setLayoutData((Object)new GridData());
        this.certTree = new Tree(certComp, 2816);
        this.certTree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.certTree.setHeaderVisible(true);
        TreeColumn certFieldColumn = new TreeColumn(this.certTree, 16384);
        certFieldColumn.setText("Field");
        certFieldColumn.setWidth(200);
        TreeColumn certValueColumn = new TreeColumn(this.certTree, 16384);
        certValueColumn.setText("Value");
        certValueColumn.setWidth(100);
    }

    private void createGeneralTab(TabFolder tabber) {
        TabItem generalTab = new TabItem(tabber, 0);
        generalTab.setText("General");
        Composite generalComp = new Composite((Composite)tabber, 0);
        generalComp.setLayout((Layout)new GridLayout(1, false));
        generalComp.setLayoutData((Object)new GridData(4, 4, true, true));
        generalTab.setControl((Control)generalComp);
        Label confNameLabel = new Label(generalComp, 0);
        confNameLabel.setLayoutData((Object)new GridData());
        confNameLabel.setText("Configuration Name:");
        this.confNameText = new Text(generalComp, 2060);
        this.confNameText.setLayoutData((Object)new GridData(4, 1, true, false));
        Label confDescLabel = new Label(generalComp, 0);
        confDescLabel.setLayoutData((Object)new GridData());
        confDescLabel.setText("Description:");
        this.confDescText = new Text(generalComp, 2634);
        GridData gData = new GridData(4, 4, true, true);
        gData.widthHint = 300;
        gData.heightHint = 80;
        this.confDescText.setLayoutData((Object)gData);
        Label confPrereqLabel = new Label(generalComp, 0);
        confPrereqLabel.setLayoutData((Object)new GridData());
        confPrereqLabel.setText("Prerequisites:");
        this.confPrereqText = new Text(generalComp, 2634);
        gData = new GridData(4, 4, true, true);
        gData.widthHint = 300;
        gData.heightHint = 80;
        this.confPrereqText.setLayoutData((Object)gData);
    }

    private void createProjectTab(TabFolder tabber) {
        TabItem projectTab = new TabItem(tabber, 0);
        projectTab.setText("Projects");
        Composite projectComp = new Composite((Composite)tabber, 0);
        projectComp.setLayout((Layout)new GridLayout(1, false));
        projectComp.setLayoutData((Object)new GridData(4, 4, true, true));
        projectTab.setControl((Control)projectComp);
        Label projectLabel = new Label(projectComp, 0);
        projectLabel.setText("Project Configurations");
        projectLabel.setLayoutData((Object)new GridData());
        this.projectTree = new Tree(projectComp, 2816);
        this.projectTree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.projectTree.setHeaderVisible(true);
        TreeColumn voFieldColumn = new TreeColumn(this.projectTree, 16384);
        voFieldColumn.setText("Field");
        voFieldColumn.setWidth(200);
        TreeColumn voValueColumn = new TreeColumn(this.projectTree, 16384);
        voValueColumn.setText("Value");
        voValueColumn.setWidth(100);
    }

    private TreeItem createTreeItem(Tree tree, String s1, String s2) {
        TreeItem item = new TreeItem(tree, 0);
        this.fillTreeItem(item, s1, s2);
        return item;
    }

    private TreeItem createTreeItem(TreeItem parent, String s1, String s2) {
        TreeItem item = new TreeItem(parent, 0);
        this.fillTreeItem(item, s1, s2);
        return item;
    }

    private void createVoTab(TabFolder tabber) {
        TabItem voTab = new TabItem(tabber, 0);
        voTab.setText("Virtual Organizations");
        Composite voComp = new Composite((Composite)tabber, 0);
        voComp.setLayout((Layout)new GridLayout(1, false));
        voComp.setLayoutData((Object)new GridData(4, 4, true, true));
        voTab.setControl((Control)voComp);
        Label voLabel = new Label(voComp, 0);
        voLabel.setText("VO Configurations");
        voLabel.setLayoutData((Object)new GridData());
        this.voTree = new Tree(voComp, 2816);
        this.voTree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.voTree.setHeaderVisible(true);
        TreeColumn voFieldColumn = new TreeColumn(this.voTree, 16384);
        voFieldColumn.setText("Field");
        voFieldColumn.setWidth(200);
        TreeColumn voValueColumn = new TreeColumn(this.voTree, 16384);
        voValueColumn.setText("Value");
        voValueColumn.setWidth(100);
    }

    private void fillTreeItem(TreeItem item, String s1, String s2) {
        item.setText(0, s1 == null ? "" : s1);
        item.setText(1, s2 == null ? "" : s2);
    }

    private String securelyGetAttribute(IConfigurationElement conf, String attribute) {
        String s;
        String result = "N/A";
        if (conf != null && (s = conf.getAttribute(attribute)) != null && s.trim().length() > 0) {
            result = s;
        }
        return result;
    }
}

