/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.wizards;

import eu.geclipse.core.config.ConfiguratorFactory;
import eu.geclipse.core.config.IConfigurator;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.dialogs.ProblemDialog;
import eu.geclipse.ui.internal.wizards.ConfiguratorSelectionPage;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;

public class ConfigurationWizard
extends Wizard {
    private ConfiguratorSelectionPage selectionPage;

    public void addPages() {
        this.selectionPage = new ConfiguratorSelectionPage();
        this.addPage((IWizardPage)this.selectionPage);
    }

    public boolean canFinish() {
        return super.canFinish();
    }

    public String getWindowTitle() {
        return "g-Eclipse Easy Configuration";
    }

    public boolean performFinish() {
        final IConfigurationElement[] selection = this.selectionPage.getSelection();
        final Shell shell = this.getShell();
        Job configurationJob = new Job("g-Eclipse configuration"){

            protected IStatus run(IProgressMonitor monitor) {
                MultiStatus status = new MultiStatus("org.eclipse.ui.net", 0, "Problems while configuring g-Eclipse", null);
                SubMonitor sMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Configuring g-Eclipse", (int)selection.length);
                try {
                    IConfigurationElement[] iConfigurationElementArray = selection;
                    int n = selection.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConfigurationElement element = iConfigurationElementArray[n2];
                        IConfigurator configurator = ConfiguratorFactory.createConfigurator((IConfigurationElement)element);
                        sMonitor.setTaskName("Configuring " + element.getAttribute("name"));
                        IStatus stat = configurator.configure((IProgressMonitor)sMonitor.newChild(1));
                        if (!stat.isOK()) {
                            status.merge(stat);
                        }
                        if (sMonitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        ++n2;
                    }
                }
                catch (ProblemException pExc) {
                    ProblemDialog.openProblem(shell, "g-Eclipse configuration problem", "The configuration process could not be finished. It is possible that some parts are configured properly whereas others are not configured at all.", pExc);
                }
                return status.getChildren() == null || status.getChildren().length == 0 ? Status.OK_STATUS : status;
            }
        };
        configurationJob.setUser(true);
        configurationJob.schedule();
        return true;
    }
}

