/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.wizards;

import eu.geclipse.core.model.IVoLoader;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.internal.wizards.VoLoaderSelectionPage;
import eu.geclipse.ui.widgets.StoredCombo;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class VoImportLocationChooserPage
extends WizardPage {
    private VoLoaderSelectionPage selectionPage;
    private StoredCombo combo;

    public VoImportLocationChooserPage(VoLoaderSelectionPage selectionPage) {
        super("voImportLocationChooserPage", "Import Location", null);
        this.setDescription("Choose the remote location from which you want to import VOs");
        this.selectionPage = selectionPage;
    }

    public void createControl(Composite parent) {
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        IVoLoader loader = this.getLoader();
        Composite mainComp = new Composite(parent, 0);
        mainComp.setLayout((Layout)new GridLayout(1, false));
        GridData gData = new GridData(1808);
        mainComp.setLayoutData((Object)gData);
        Label label = new Label(mainComp, 0);
        label.setText("Remote Repository URL:");
        gData = new GridData();
        label.setLayoutData((Object)gData);
        this.combo = new StoredCombo(mainComp, 0);
        if (loader != null) {
            String preferenceID = String.valueOf(loader.getClass().toString()) + "_import_locations";
            this.combo.setPreferences(preferenceStore, preferenceID);
        }
        gData = new GridData(768);
        gData.grabExcessHorizontalSpace = true;
        this.combo.setLayoutData(gData);
        this.combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                VoImportLocationChooserPage.this.validatePage();
            }
        });
        this.validatePage();
        this.setControl((Control)mainComp);
    }

    public IVoLoader getLoader() {
        return this.selectionPage.getSelectedLoader();
    }

    public URI getSelectedLocation() {
        URI result = null;
        String text = this.combo.getText();
        try {
            result = new URI(text);
        }
        catch (URISyntaxException uriExc) {
            Activator.logException(uriExc);
        }
        return result;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.populateLocationCombo();
        }
        super.setVisible(visible);
    }

    protected void validatePage() {
        String errorMessage = null;
        String location = this.combo.getText();
        if (location != null && location.length() != 0) {
            try {
                new URI(location);
            }
            catch (URISyntaxException uriExc) {
                errorMessage = String.format("Invalid URI -> %1$s", uriExc.getLocalizedMessage());
            }
        } else {
            errorMessage = "Please specify a valid URL";
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }

    private void populateLocationCombo() {
        URI[] locations;
        IVoLoader loader = this.getLoader();
        if (loader != null && (locations = loader.getPredefinedURIs()) != null && locations.length > 0) {
            String text = this.combo.getText();
            if (text == null || text.length() == 0) {
                this.combo.setText(locations[0].toString());
            }
            URI[] uRIArray = locations;
            int n = locations.length;
            int n2 = 0;
            while (n2 < n) {
                URI location = uRIArray[n2];
                this.combo.addUnique(location.toString());
                ++n2;
            }
        }
    }
}

