/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.properties;

import eu.geclipse.ui.properties.AbstractPropertySource;
import eu.geclipse.ui.properties.IProperty;
import eu.geclipse.ui.properties.PropertyId;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProperty<ESourceType>
implements IProperty<ESourceType> {
    private String nameString;
    private String categoryString;
    private ILabelProvider labelProvider;
    private boolean showEmptyValue;
    private PropertyDescriptor descriptor;

    public AbstractProperty(String name, String category, boolean showEmptyValue) {
        this.nameString = name;
        this.categoryString = category;
        this.showEmptyValue = showEmptyValue;
    }

    public AbstractProperty(String name, String category) {
        this(name, category, true);
    }

    @Override
    public abstract Object getValue(ESourceType var1);

    protected String getName() {
        return this.nameString;
    }

    void setLabelProvider(ILabelProvider provider) {
        this.labelProvider = provider;
    }

    @Override
    public IPropertyDescriptor getDescriptor(Class<? extends AbstractPropertySource<?>> propSourceClass) {
        if (this.descriptor == null) {
            this.descriptor = this.createDescriptor(new PropertyId(propSourceClass, this), this.nameString);
            this.descriptor.setCategory(this.categoryString);
            this.descriptor.setLabelProvider(this.labelProvider);
        }
        return this.descriptor;
    }

    protected PropertyDescriptor createDescriptor(PropertyId<ESourceType> propertyId, String name) {
        return new PropertyDescriptor(propertyId, name);
    }

    protected String getBytesFormattedString(double value) {
        double smallerValue = value;
        ArrayList<String> suffixList = new ArrayList<String>(7);
        suffixList.add("B");
        suffixList.add("kB");
        suffixList.add("MB");
        suffixList.add("GB");
        suffixList.add("TB");
        suffixList.add("PB");
        suffixList.add("EB");
        Iterator iterator = suffixList.iterator();
        String suffixString = (String)iterator.next();
        while (iterator.hasNext() && smallerValue > 1000.0) {
            suffixString = (String)iterator.next();
            smallerValue /= 1000.0;
        }
        String formattedString = (double)((int)smallerValue) == smallerValue ? String.format("%d", (int)smallerValue) : String.format("%.2f", smallerValue);
        return String.valueOf(formattedString) + ' ' + suffixString;
    }

    @Override
    public boolean isShowEmptyValue() {
        return this.showEmptyValue;
    }
}

