/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.properties;

import eu.geclipse.ui.properties.IProperty;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPropertySource<ESourceType> {
    private ESourceType sourceObject;
    private List<AbstractPropertySource<?>> childPropSourceList = new LinkedList();

    public AbstractPropertySource(ESourceType sourceObject) {
        this.sourceObject = sourceObject;
    }

    protected abstract Class<? extends AbstractPropertySource<?>> getPropertySourceClass();

    protected abstract List<IProperty<ESourceType>> getStaticProperties();

    public List<IPropertyDescriptor> getPropertyDescriptors() {
        ArrayList<IPropertyDescriptor> descriptorsList = new ArrayList<IPropertyDescriptor>();
        this.appendDescriptors(descriptorsList);
        return descriptorsList;
    }

    Object getPropertyValue(IProperty property) {
        return property.getValue(this.sourceObject);
    }

    AbstractPropertySource<?> getPropertySourceInstanceFor(Class<? extends AbstractPropertySource<?>> propertySourceClass) {
        AbstractPropertySource<?> propertySource = null;
        if (this.getPropertySourceClass() == propertySourceClass) {
            propertySource = this;
        } else {
            Iterator<AbstractPropertySource<?>> iterator = this.childPropSourceList.iterator();
            while (iterator.hasNext() && propertySource == null) {
                AbstractPropertySource<?> childSource = iterator.next();
                propertySource = childSource.getPropertySourceInstanceFor(propertySourceClass);
            }
        }
        return propertySource;
    }

    protected void appendDescriptors(List<IPropertyDescriptor> descriptorsList) {
        for (IProperty<ESourceType> iProperty : this.getStaticProperties()) {
            if (!iProperty.isShowEmptyValue() && iProperty.getValue(this.sourceObject) == null) continue;
            descriptorsList.add(iProperty.getDescriptor(this.getPropertySourceClass()));
        }
        if (this.childPropSourceList != null) {
            for (AbstractPropertySource abstractPropertySource : this.childPropSourceList) {
                abstractPropertySource.appendDescriptors(descriptorsList);
            }
        }
    }

    protected void addChildSource(AbstractPropertySource<?> childPropertySource) {
        this.childPropSourceList.add(childPropertySource);
    }
}

