/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.properties;

import eu.geclipse.core.filesystem.internal.filesystem.GEclipseFileStore;
import eu.geclipse.core.model.IGridConnectionElement;
import eu.geclipse.core.model.IPropertiesProvider;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.properties.AbstractProperty;
import eu.geclipse.ui.properties.AbstractPropertySource;
import eu.geclipse.ui.properties.FileInfoSource;
import eu.geclipse.ui.properties.IProperty;
import eu.geclipse.ui.properties.Messages;
import eu.geclipse.ui.properties.PropertiesProviderSource;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridConnectionElementSource
extends AbstractPropertySource<IGridConnectionElement> {
    private static List<IProperty<IGridConnectionElement>> staticProperties;

    public GridConnectionElementSource(IGridConnectionElement sourceObject) {
        super(sourceObject);
        try {
            if (sourceObject.getConnectionFileInfo() != null) {
                this.addChildSource(new FileInfoSource(sourceObject.getConnectionFileInfo()));
            }
        }
        catch (CoreException cExc) {
            Activator.logException(cExc);
        }
        try {
            GEclipseFileStore geclFS;
            IFileStore slaveFileStore;
            IFileStore fileStore = sourceObject.getConnectionFileStore();
            if (fileStore instanceof GEclipseFileStore && (slaveFileStore = (geclFS = (GEclipseFileStore)fileStore).getSlave()) instanceof IPropertiesProvider) {
                IPropertiesProvider propProvider = (IPropertiesProvider)slaveFileStore;
                this.addChildSource(new PropertiesProviderSource(propProvider));
            }
        }
        catch (CoreException coreException) {}
    }

    @Override
    protected Class<? extends AbstractPropertySource<?>> getPropertySourceClass() {
        return GridConnectionElementSource.class;
    }

    @Override
    protected List<IProperty<IGridConnectionElement>> getStaticProperties() {
        if (staticProperties == null) {
            staticProperties = GridConnectionElementSource.createProperties();
        }
        return staticProperties;
    }

    private static List<IProperty<IGridConnectionElement>> createProperties() {
        ArrayList<IProperty<IGridConnectionElement>> propertiesList = new ArrayList<IProperty<IGridConnectionElement>>();
        propertiesList.add(GridConnectionElementSource.createUri());
        return propertiesList;
    }

    private static IProperty<IGridConnectionElement> createUri() {
        return new AbstractProperty<IGridConnectionElement>(Messages.getString("GridConnectionElementSource.uri"), null, false){

            @Override
            public Object getValue(IGridConnectionElement sourceObject) {
                String uriString = null;
                URI uri = sourceObject.getURI();
                if (uri != null) {
                    uriString = uri.toString();
                }
                return uriString;
            }

            private URI addSeparator(URI uri) {
                URI separatedUri = uri;
                String path = uri.getPath();
                if (path != null && path.length() > 0 && path.charAt(path.length() - 1) != '/') {
                    try {
                        separatedUri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), path.concat(Character.toString('/')), uri.getQuery(), uri.getFragment());
                    }
                    catch (URISyntaxException uRISyntaxException) {}
                }
                return separatedUri;
            }
        };
    }
}

