/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.properties;

import eu.geclipse.core.model.IGridJobDescription;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.properties.AbstractProperty;
import eu.geclipse.ui.properties.AbstractPropertySource;
import eu.geclipse.ui.properties.IProperty;
import eu.geclipse.ui.properties.Messages;
import eu.geclipse.ui.properties.MultilineProperty;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridJobDescSource
extends AbstractPropertySource<IGridJobDescription> {
    private static List<IProperty<IGridJobDescription>> staticProperties;

    public GridJobDescSource(IGridJobDescription source) {
        super(source);
    }

    @Override
    protected List<IProperty<IGridJobDescription>> getStaticProperties() {
        if (staticProperties == null) {
            staticProperties = GridJobDescSource.createProperties();
        }
        return staticProperties;
    }

    @Override
    protected Class<? extends AbstractPropertySource<?>> getPropertySourceClass() {
        return GridJobDescSource.class;
    }

    private static List<IProperty<IGridJobDescription>> createProperties() {
        ArrayList<IProperty<IGridJobDescription>> propertiesList = new ArrayList<IProperty<IGridJobDescription>>();
        propertiesList.add(GridJobDescSource.createDescription());
        propertiesList.add(GridJobDescSource.createPropertyExecutable());
        propertiesList.add(GridJobDescSource.createPropertyExecutableArg());
        propertiesList.add(GridJobDescSource.createPropertyInput());
        propertiesList.add(GridJobDescSource.createPropertyOutput());
        propertiesList.add(GridJobDescSource.createPropertyError());
        propertiesList.add(GridJobDescSource.createPropertyStdOutputUri());
        propertiesList.add(GridJobDescSource.createPropertyStdInputUri());
        propertiesList.add(GridJobDescSource.createPropertyStdErrorUri());
        return propertiesList;
    }

    private static IProperty<IGridJobDescription> createDescription() {
        return new MultilineProperty<IGridJobDescription>(Messages.getString("GridJobDescSource.propertyDescription"), Messages.getString("GridJobDescSource.categoryApplication")){

            @Override
            public Object getValue(IGridJobDescription source) {
                return source.getDescription();
            }
        };
    }

    private static IProperty<IGridJobDescription> createPropertyExecutable() {
        return new AbstractProperty<IGridJobDescription>(Messages.getString("GridJobDescSource.propertyExecutable"), Messages.getString("GridJobDescSource.categoryApplication")){

            @Override
            public Object getValue(IGridJobDescription source) {
                return source.getExecutable();
            }
        };
    }

    private static IProperty<IGridJobDescription> createPropertyExecutableArg() {
        return new AbstractProperty<IGridJobDescription>(Messages.getString("GridJobDescSource.propertyExecArgs"), Messages.getString("GridJobDescSource.categoryApplication")){

            @Override
            public Object getValue(IGridJobDescription jobDescription) {
                StringBuilder stringBuilder = new StringBuilder();
                if (jobDescription.getExecutableArguments() != null) {
                    List argList = jobDescription.getExecutableArguments();
                    for (String argString : argList) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(", ");
                        }
                        stringBuilder.append(argString);
                    }
                }
                return stringBuilder.toString();
            }
        };
    }

    private static IProperty<IGridJobDescription> createPropertyInput() {
        return new AbstractProperty<IGridJobDescription>(Messages.getString("GridJobDescSource.propertyInput"), Messages.getString("GridJobDescSource.categoryApplication"), false){

            @Override
            public Object getValue(IGridJobDescription jobDescription) {
                return jobDescription.getStdInputFileName();
            }
        };
    }

    private static IProperty<IGridJobDescription> createPropertyOutput() {
        return new AbstractProperty<IGridJobDescription>(Messages.getString("GridJobDescSource.propertyOutput"), Messages.getString("GridJobDescSource.categoryApplication"), false){

            @Override
            public Object getValue(IGridJobDescription jobDescription) {
                return jobDescription.getStdOutputFileName();
            }
        };
    }

    private static IProperty<IGridJobDescription> createPropertyError() {
        return new AbstractProperty<IGridJobDescription>(Messages.getString("GridJobDescSource.propertyStdErrFilename"), Messages.getString("GridJobDescSource.categoryApplication"), false){

            @Override
            public Object getValue(IGridJobDescription jobDescription) {
                return jobDescription.getStdErrorFileName();
            }
        };
    }

    private static IProperty<IGridJobDescription> createPropertyStdOutputUri() {
        return new AbstractProperty<IGridJobDescription>(Messages.getString("GridJobDescSource.propertyStdOutputUri"), Messages.getString("GridJobDescSource.categoryApplication"), false){

            @Override
            public Object getValue(IGridJobDescription jobDescription) {
                String value = null;
                try {
                    URI stdOutputUri = jobDescription.getStdOutputUri();
                    if (stdOutputUri != null) {
                        value = stdOutputUri.toString();
                    }
                }
                catch (ProblemException problemException) {}
                return value;
            }
        };
    }

    private static IProperty<IGridJobDescription> createPropertyStdInputUri() {
        return new AbstractProperty<IGridJobDescription>(Messages.getString("GridJobDescSource.propertyStdInputUri"), Messages.getString("GridJobDescSource.categoryApplication"), false){

            @Override
            public Object getValue(IGridJobDescription jobDescription) {
                String value = null;
                try {
                    URI stdInputUri = jobDescription.getStdInputUri();
                    if (stdInputUri != null) {
                        value = stdInputUri.toString();
                    }
                }
                catch (ProblemException problemException) {}
                return value;
            }
        };
    }

    private static IProperty<IGridJobDescription> createPropertyStdErrorUri() {
        return new AbstractProperty<IGridJobDescription>(Messages.getString("GridJobDescSource.propertyStdErrUri"), Messages.getString("GridJobDescSource.categoryApplication"), false){

            @Override
            public Object getValue(IGridJobDescription jobDescription) {
                String value = null;
                try {
                    URI stdErrorUri = jobDescription.getStdErrorUri();
                    if (stdErrorUri != null) {
                        value = stdErrorUri.toString();
                    }
                }
                catch (ProblemException problemException) {}
                return value;
            }
        };
    }
}

