/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.properties;

import eu.geclipse.core.model.IGridJob;
import eu.geclipse.ui.properties.AbstractProperty;
import eu.geclipse.ui.properties.AbstractPropertySource;
import eu.geclipse.ui.properties.GridJobDescSource;
import eu.geclipse.ui.properties.IProperty;
import eu.geclipse.ui.properties.Messages;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridJobSource
extends AbstractPropertySource<IGridJob> {
    private static List<IProperty<IGridJob>> staticProperties;

    public GridJobSource(IGridJob gridJob) {
        super(gridJob);
        if (gridJob.getJobDescription() != null) {
            this.addChildSource(new GridJobDescSource(gridJob.getJobDescription()));
        }
    }

    @Override
    protected Class<? extends AbstractPropertySource<?>> getPropertySourceClass() {
        return GridJobSource.class;
    }

    @Override
    protected List<IProperty<IGridJob>> getStaticProperties() {
        if (staticProperties == null) {
            staticProperties = GridJobSource.createProperties();
        }
        return staticProperties;
    }

    private static List<IProperty<IGridJob>> createProperties() {
        ArrayList<IProperty<IGridJob>> propertiesList = new ArrayList<IProperty<IGridJob>>(1);
        propertiesList.add(GridJobSource.createName());
        propertiesList.add(GridJobSource.createId());
        propertiesList.add(GridJobSource.createStatus());
        return propertiesList;
    }

    private static IProperty<IGridJob> createName() {
        return new AbstractProperty<IGridJob>(Messages.getString("JobPropertySource.propertyName"), Messages.getString("JobPropertySource.categoryGeneral")){

            @Override
            public Object getValue(IGridJob sourceObject) {
                return sourceObject.getName();
            }
        };
    }

    private static IProperty<IGridJob> createId() {
        return new AbstractProperty<IGridJob>(Messages.getString("JobPropertySource.propertyId"), Messages.getString("JobPropertySource.categoryGeneral")){

            @Override
            public Object getValue(IGridJob gridJob) {
                String value = null;
                if (gridJob.getID() != null) {
                    value = gridJob.getID().getJobID();
                }
                return value;
            }
        };
    }

    private static IProperty<IGridJob> createStatus() {
        return new AbstractProperty<IGridJob>(Messages.getString("JobPropertySource.propertyStatus"), Messages.getString("JobPropertySource.categoryGeneral")){

            @Override
            public Object getValue(IGridJob gridJob) {
                String value = null;
                if (gridJob.getJobStatus() != null) {
                    value = gridJob.getJobStatus().getName();
                }
                return value;
            }
        };
    }
}

