/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.properties;

import eu.geclipse.ui.properties.AbstractProperty;
import eu.geclipse.ui.properties.PropertyId;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.PropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultilineProperty<ESourceType>
extends AbstractProperty<ESourceType> {
    private static ILabelProvider multilineLabelProvider = null;

    public MultilineProperty(String name, String category) {
        super(name, category);
        if (multilineLabelProvider == null) {
            multilineLabelProvider = MultilineProperty.createLabelProvider();
        }
        this.setLabelProvider(MultilineProperty.createLabelProvider());
    }

    @Override
    protected PropertyDescriptor createDescriptor(PropertyId<ESourceType> propertyId, String nameString) {
        PropertyDescriptor descriptor = new PropertyDescriptor(propertyId, nameString){

            public CellEditor createPropertyEditor(Composite parent) {
                return MultilineProperty.this.createCellEditor(parent);
            }
        };
        return descriptor;
    }

    protected CellEditor createCellEditor(Composite parent) {
        return new DialogCellEditor(parent){

            protected Object openDialogBox(Control cellEditorWindow) {
                PropertyDialog dialog = new PropertyDialog(cellEditorWindow.getShell());
                Object value = this.getValue();
                if (value != null && value instanceof String) {
                    dialog.setValue((String)value);
                }
                dialog.open();
                return null;
            }
        };
    }

    private static ILabelProvider createLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                String string = element instanceof String ? this.removeNewLineChars((String)element) : element.toString();
                return string;
            }

            private String removeNewLineChars(String valueString) {
                String result = valueString;
                int nlIndex = -1;
                int index = 0;
                while (index < valueString.length() && nlIndex == -1) {
                    if (valueString.charAt(index) == '\r' || valueString.charAt(index) == '\n') {
                        nlIndex = index;
                    }
                    ++index;
                }
                if (nlIndex > -1) {
                    result = String.valueOf(valueString.substring(0, nlIndex)) + "...";
                }
                return result;
            }
        };
    }

    private class PropertyDialog
    extends Dialog {
        private Text valueText;
        private String valueString;

        protected PropertyDialog(Shell parentShell) {
            super(parentShell);
            this.setShellStyle(this.getShellStyle() | 0x10);
        }

        protected Control createDialogArea(Composite parent) {
            Composite dlgComposite = (Composite)super.createDialogArea(parent);
            this.valueText = new Text(dlgComposite, 2888);
            if (this.valueString != null) {
                this.valueText.setText(this.valueString);
            }
            GridData gridData = new GridData(1808);
            gridData.heightHint = 200;
            gridData.widthHint = 350;
            this.valueText.setLayoutData((Object)gridData);
            this.getShell().setText(MultilineProperty.this.getName());
            return dlgComposite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        }

        void setValue(String value) {
            this.valueString = value;
        }
    }
}

